/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.selector;

import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.selector.OptimizedBy;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ByTextCaseInsensitive
extends OptimizedBy {
    private static final JavaScript js = new JavaScript("find-elements-by-text-case-insensitive.js");
    private final String elementText;

    public ByTextCaseInsensitive(String elementText) {
        this.elementText = elementText;
    }

    @Override
    @Nonnull
    protected List<WebElement> findElements(SearchContext context, int limit) {
        return (List)js.execute(context, js.node(context), this.elementText, limit);
    }

    @Nonnull
    @CheckReturnValue
    public String toString() {
        return "by text (case-insensitive): " + this.elementText;
    }
}

