/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Config;
import java.util.regex.Pattern;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BrowserResizer {
    private static final Pattern DIMENSION_REGEX = Pattern.compile("\\d+x\\d+");
    private static final Logger log = LoggerFactory.getLogger(BrowserResizer.class);

    BrowserResizer() {
    }

    void adjustBrowserPosition(Config config, WebDriver driver) {
        String browserPosition = config.browserPosition();
        if (browserPosition != null) {
            if (!BrowserResizer.isValidDimension(browserPosition)) {
                throw new IllegalArgumentException(String.format("Browser position %s is incorrect", browserPosition));
            }
            log.info("Set browser position to {}", (Object)browserPosition);
            String[] coordinates = browserPosition.split("x");
            int x = Integer.parseInt(coordinates[0]);
            int y = Integer.parseInt(coordinates[1]);
            Point target = new Point(x, y);
            Point current = driver.manage().window().getPosition();
            if (!current.equals((Object)target)) {
                driver.manage().window().setPosition(target);
            }
        }
    }

    void adjustBrowserSize(Config config, WebDriver driver) {
        String browserSize = config.browserSize();
        if (browserSize != null) {
            if (!BrowserResizer.isValidDimension(browserSize)) {
                throw new IllegalArgumentException(String.format("Browser size %s is incorrect", browserSize));
            }
            log.info("Set browser size to {}", (Object)browserSize);
            String[] dimension = browserSize.split("x");
            int width = Integer.parseInt(dimension[0]);
            int height = Integer.parseInt(dimension[1]);
            driver.manage().window().setSize(new Dimension(width, height));
        }
    }

    static boolean isValidDimension(String dimension) {
        return DIMENSION_REGEX.matcher(dimension).matches();
    }
}

