/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class FirefoxDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(FirefoxDriverFactory.class);

    @Override
    public void setupWebdriverBinary() {
        if (this.isSystemPropertyNotSet("webdriver.gecko.driver")) {
            WebDriverManager.firefoxdriver().setup();
        }
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebDriver create(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        SessionNotCreatedException failure = null;
        for (int retries = 0; retries < 5; ++retries) {
            try {
                return new FirefoxDriver((FirefoxDriverService)this.createDriverService(config), this.createCapabilities(config, browser, proxy, browserDownloadsFolder));
            }
            catch (SessionNotCreatedException probablyPortAlreadyUsed) {
                log.error("Failed to start firefox", (Throwable)probablyPortAlreadyUsed);
                failure = probablyPortAlreadyUsed;
                continue;
            }
        }
        throw failure;
    }

    @CheckReturnValue
    @Nonnull
    protected GeckoDriverService createDriverService(Config config) {
        return (GeckoDriverService)this.withLog(config, new GeckoDriverService.Builder());
    }

    @CheckReturnValue
    @Nonnull
    public FirefoxOptions createCapabilities(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        FirefoxOptions initialOptions = new FirefoxOptions();
        initialOptions.setHeadless(config.headless());
        this.setupBrowserBinary(config, initialOptions);
        this.setupPreferences(initialOptions);
        this.setupDownloadsFolder(initialOptions, browserDownloadsFolder);
        FirefoxOptions options = initialOptions.merge((Capabilities)this.createCommonCapabilities(new FirefoxOptions(), config, browser, proxy));
        this.transferFirefoxProfileFromSystemProperties(options).ifPresent(profile -> options.setProfile(profile));
        this.injectFirefoxPrefs(options);
        return options;
    }

    protected void setupBrowserBinary(Config config, FirefoxOptions firefoxOptions) {
        if (StringUtils.isNotEmpty((CharSequence)config.browserBinary())) {
            log.info("Using browser binary: {}", (Object)config.browserBinary());
            firefoxOptions.setBinary(config.browserBinary());
        }
    }

    protected void setupPreferences(FirefoxOptions firefoxOptions) {
        firefoxOptions.addPreference("network.automatic-ntlm-auth.trusted-uris", (Object)"http://,https://");
        firefoxOptions.addPreference("network.automatic-ntlm-auth.allow-non-fqdn", (Object)true);
        firefoxOptions.addPreference("network.negotiate-auth.delegation-uris", (Object)"http://,https://");
        firefoxOptions.addPreference("network.negotiate-auth.trusted-uris", (Object)"http://,https://");
        firefoxOptions.addPreference("network.http.phishy-userpass-length", (Object)255);
        firefoxOptions.addPreference("security.csp.enable", (Object)false);
        firefoxOptions.addPreference("network.proxy.no_proxies_on", (Object)"");
        firefoxOptions.addPreference("network.proxy.allow_hijacking_localhost", (Object)true);
    }

    protected void setupDownloadsFolder(FirefoxOptions firefoxOptions, @Nullable File browserDownloadsFolder) {
        if (browserDownloadsFolder != null) {
            firefoxOptions.addPreference("browser.download.dir", (Object)browserDownloadsFolder.getAbsolutePath());
        }
        firefoxOptions.addPreference("browser.helperApps.neverAsk.saveToDisk", (Object)this.popularContentTypes());
        firefoxOptions.addPreference("pdfjs.disabled", (Object)true);
        firefoxOptions.addPreference("browser.download.folderList", (Object)2);
    }

    @CheckReturnValue
    @Nonnull
    protected String popularContentTypes() {
        try {
            return String.join((CharSequence)";", IOUtils.readLines((InputStream)this.getClass().getResourceAsStream("/content-types.properties"), (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            return "text/plain;text/csv;application/zip;application/pdf;application/octet-stream;application/msword;application/vnd.ms-excel;text/css;text/html";
        }
    }

    @CheckReturnValue
    @Nonnull
    protected Map<String, String> collectFirefoxProfileFromSystemProperties() {
        String prefix = "firefoxprofile.";
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            result.put(capability, value);
        }
        return result;
    }

    @Nonnull
    @CheckReturnValue
    protected Optional<FirefoxProfile> transferFirefoxProfileFromSystemProperties(FirefoxOptions firefoxOptions) {
        Map<String, String> ffProfile = this.collectFirefoxProfileFromSystemProperties();
        if (ffProfile.isEmpty()) {
            return Optional.empty();
        }
        FirefoxProfile profile = Optional.ofNullable(firefoxOptions.getProfile()).orElseGet(FirefoxProfile::new);
        for (Map.Entry<String, String> entry : ffProfile.entrySet()) {
            String capability = entry.getKey();
            String value = entry.getValue();
            log.debug("Use {}={}", (Object)capability, (Object)value);
            this.setCapability(profile, capability, value);
        }
        return Optional.of(profile);
    }

    protected void setCapability(FirefoxProfile profile, String capability, String value) {
        if (this.isBoolean(value)) {
            profile.setPreference(capability, (Object)Boolean.parseBoolean(value));
        } else if (this.isInteger(value)) {
            profile.setPreference(capability, (Object)Integer.parseInt(value));
        } else {
            profile.setPreference(capability, (Object)value);
        }
    }

    private void injectFirefoxPrefs(FirefoxOptions options) {
        Map mozOptions;
        if (options.getCapability("moz:firefoxOptions") != null && (mozOptions = (Map)this.cast(options.getCapability("moz:firefoxOptions"))).containsKey("prefs")) {
            for (Map.Entry pref : ((Map)mozOptions.get("prefs")).entrySet()) {
                options.addPreference((String)pref.getKey(), pref.getValue());
            }
        }
    }
}

