/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.SelenideDriver;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import com.codeborne.selenide.webdriver.BrowserResizer;
import com.codeborne.selenide.webdriver.ChromeDriverFactory;
import com.codeborne.selenide.webdriver.DefaultDriverFactory;
import com.codeborne.selenide.webdriver.DriverFactory;
import com.codeborne.selenide.webdriver.EdgeDriverFactory;
import com.codeborne.selenide.webdriver.FirefoxDriverFactory;
import com.codeborne.selenide.webdriver.InternetExplorerDriverFactory;
import com.codeborne.selenide.webdriver.RemoteDriverFactory;
import com.codeborne.selenide.webdriver.SafariDriverFactory;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(WebDriverFactory.class);
    private final Map<String, Class<? extends AbstractDriverFactory>> factories = this.factories();
    private final RemoteDriverFactory remoteDriverFactory = new RemoteDriverFactory();
    private final BrowserResizer browserResizer = new BrowserResizer();

    @CheckReturnValue
    @Nonnull
    private Map<String, Class<? extends AbstractDriverFactory>> factories() {
        HashMap<String, Class<? extends AbstractDriverFactory>> result = new HashMap<String, Class<? extends AbstractDriverFactory>>();
        result.put("chrome", ChromeDriverFactory.class);
        result.put("firefox", FirefoxDriverFactory.class);
        result.put("edge", EdgeDriverFactory.class);
        result.put("internet explorer", InternetExplorerDriverFactory.class);
        result.put("ie", InternetExplorerDriverFactory.class);
        result.put("safari", SafariDriverFactory.class);
        return result;
    }

    @CheckReturnValue
    @Nonnull
    public WebDriver createWebDriver(Config config, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        Browser browser;
        WebDriver webdriver;
        log.debug("browser={}", (Object)config.browser());
        log.debug("browser.version={}", (Object)config.browserVersion());
        log.debug("remote={}", (Object)config.remote());
        log.debug("browserSize={}", (Object)config.browserSize());
        if (browserDownloadsFolder != null) {
            log.debug("downloadsFolder={}", (Object)browserDownloadsFolder.getAbsolutePath());
        }
        if (this.needBrowserResize(webdriver = this.createWebDriverInstance(config, browser = new Browser(config.browser(), config.headless()), proxy, browserDownloadsFolder))) {
            this.browserResizer.adjustBrowserSize(config, webdriver);
        }
        this.browserResizer.adjustBrowserPosition(config, webdriver);
        this.setLoadTimeout(config, webdriver);
        this.logBrowserVersion(webdriver);
        log.info("Selenide v. {}", (Object)SelenideDriver.class.getPackage().getImplementationVersion());
        this.logSeleniumInfo();
        return webdriver;
    }

    private boolean needBrowserResize(WebDriver webdriver) {
        Browser browser;
        String browserName = "";
        if (webdriver instanceof HasCapabilities) {
            HasCapabilities hasCapabilities = (HasCapabilities)webdriver;
            Capabilities capabilities = hasCapabilities.getCapabilities();
            browserName = capabilities.getBrowserName();
        }
        return !(browser = new Browser(browserName, false)).isChromium();
    }

    private void setLoadTimeout(Config config, WebDriver webdriver) {
        if (config.pageLoadTimeout() < 0L) {
            return;
        }
        try {
            webdriver.manage().timeouts().pageLoadTimeout(Duration.ofMillis(config.pageLoadTimeout()));
        }
        catch (UnsupportedCommandException e) {
            log.info("Failed to set page load timeout to {} ms: {}", (Object)config.pageLoadTimeout(), (Object)e.toString());
        }
        catch (RuntimeException e) {
            log.error("Failed to set page load timeout to {} ms", (Object)config.pageLoadTimeout(), (Object)e);
        }
    }

    @CheckReturnValue
    @Nonnull
    private WebDriver createWebDriverInstance(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        DriverFactory webdriverFactory = this.findFactory(browser);
        if (config.remote() != null) {
            MutableCapabilities capabilities = webdriverFactory.createCapabilities(config, browser, proxy, browserDownloadsFolder);
            return this.remoteDriverFactory.create(config, capabilities);
        }
        if (config.driverManagerEnabled()) {
            webdriverFactory.setupWebdriverBinary();
        }
        System.setProperty("webdriver.http.factory", "selenide-netty-client-factory");
        return webdriverFactory.create(config, browser, proxy, browserDownloadsFolder);
    }

    @CheckReturnValue
    @Nonnull
    private DriverFactory findFactory(Browser browser) {
        Class<DefaultDriverFactory> factoryClass = this.factories.getOrDefault(browser.name.toLowerCase(Locale.ROOT), DefaultDriverFactory.class);
        try {
            return (DriverFactory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to initialize " + factoryClass.getName(), e);
        }
    }

    private void logSeleniumInfo() {
        BuildInfo seleniumInfo = new BuildInfo();
        log.info("Selenium WebDriver v. {} build revision: {}", (Object)seleniumInfo.getReleaseLabel(), (Object)seleniumInfo.getBuildRevision());
    }

    private void logBrowserVersion(WebDriver webdriver) {
        if (webdriver instanceof HasCapabilities) {
            HasCapabilities hasCapabilities = (HasCapabilities)webdriver;
            Capabilities capabilities = hasCapabilities.getCapabilities();
            log.info("BrowserName={} Version={} Platform={}", new Object[]{capabilities.getBrowserName(), capabilities.getBrowserVersion(), capabilities.getPlatformName()});
        } else {
            log.info("BrowserName={}", (Object)webdriver.getClass().getName());
        }
    }
}

