/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.user.FollowResult;
import weixin.popular.bean.user.GetblacklistResult;
import weixin.popular.bean.user.Group;
import weixin.popular.bean.user.TagsCreatResult;
import weixin.popular.bean.user.TagsGetResult;
import weixin.popular.bean.user.TagsGetidlistResult;
import weixin.popular.bean.user.User;
import weixin.popular.bean.user.UserInfoList;
import weixin.popular.bean.user.UserTagGetResult;
import weixin.popular.client.LocalHttpClient;
import weixin.popular.util.EmojiUtil;
import weixin.popular.util.JsonUtil;

public class UserAPI
extends BaseAPI {
    public static User userInfo(String access_token, String openid, int emoji) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://api.weixin.qq.com/cgi-bin/user/info").addParameter(UserAPI.getATPN(), access_token).addParameter("openid", openid).addParameter("lang", "zh_CN").build();
        User user = LocalHttpClient.executeJsonResult(httpUriRequest, User.class);
        if (emoji != 0 && user != null && user.getNickname() != null) {
            user.setNickname_emoji(EmojiUtil.parse(user.getNickname(), emoji));
        }
        return user;
    }

    public static User userInfo(String access_token, String openid) {
        return UserAPI.userInfo(access_token, openid, 0);
    }

    public static FollowResult userGet(String access_token, String next_openid) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://api.weixin.qq.com/cgi-bin/user/get").addParameter(UserAPI.getATPN(), access_token).addParameter("next_openid", next_openid == null ? "" : next_openid).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, FollowResult.class);
    }

    public static UserInfoList userInfoBatchget(String access_token, String lang, List<String> openids, int emoji) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"user_list\": [");
        for (int i = 0; i < openids.size(); ++i) {
            sb.append("{").append("\"openid\": \"").append(openids.get(i)).append("\",").append("\"lang\": \"").append(lang).append("\"").append("}").append(i == openids.size() - 1 ? "" : ",");
        }
        sb.append("]}");
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/user/info/batchget").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(sb.toString(), Charset.forName("utf-8"))).build();
        UserInfoList userInfoList = LocalHttpClient.executeJsonResult(httpUriRequest, UserInfoList.class);
        if (emoji != 0 && userInfoList != null && userInfoList.getUser_info_list() != null) {
            for (User user : userInfoList.getUser_info_list()) {
                if (user.getNickname() == null) continue;
                user.setNickname_emoji(EmojiUtil.parse(user.getNickname(), emoji));
            }
        }
        return userInfoList;
    }

    public static UserInfoList userInfoBatchget(String access_token, String lang, List<String> openids) {
        return UserAPI.userInfoBatchget(access_token, lang, openids, 0);
    }

    public static BaseResult userInfoUpdateremark(String access_token, String openid, String remark) {
        String postJson = String.format("{\"openid\":\"%1$s\",\"remark\":\"%2$s\"}", openid, remark);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/user/info/updateremark").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static Group groupsCreate(String access_token, String name) {
        String groupJson = String.format("{\"group\":{\"name\":\"%1$s\"}}", name);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/groups/create").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(groupJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, Group.class);
    }

    public static Group groupsGet(String access_token) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/cgi-bin/groups/get").addParameter(UserAPI.getATPN(), access_token).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, Group.class);
    }

    public static Group groupsGetid(String access_token, String openid) {
        String groupJson = String.format("{\"openid\":\"%1$s\"}", openid);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/groups/getid").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(groupJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, Group.class);
    }

    public static BaseResult groupsUpdate(String access_token, String id, String name) {
        String groupJson = "{\"group\":{\"id\":" + id + ",\"name\":\"" + name + "\"}}";
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/groups/update").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(groupJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult groupsMembersUpdate(String access_token, String openid, String to_groupid) {
        String groupJson = "{\"openid\":\"" + openid + "\",\"to_groupid\":" + to_groupid + "}";
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/groups/members/update").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(groupJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult groupsMembersBatchUpdate(String access_token, List<String> openid_list, String to_groupid) {
        String openidListStr = JsonUtil.toJSONString(openid_list);
        String groupJson = "{\"openid_list\":" + openidListStr + ",\"to_groupid\":" + to_groupid + "}";
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/groups/members/batchupdate").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(groupJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult groupsDelete(String access_token, String id) {
        String groupJson = String.format("{\"group\":{\"id\":%1$s}}", id);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/groups/delete").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(groupJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static TagsCreatResult tagsCreate(String access_token, String name) {
        String json = String.format("{\"tag\":{\"name\":\"%s\"}}", name);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/tags/create").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, TagsCreatResult.class);
    }

    public static TagsGetResult tagsGet(String access_token) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://api.weixin.qq.com/cgi-bin/tags/get").addParameter(UserAPI.getATPN(), access_token).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, TagsGetResult.class);
    }

    public static BaseResult tagsUpdate(String access_token, Integer id, String name) {
        String json = String.format("{\"tag\":{\"id\":%d,\"name\":\"%s\"}}", id, name);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/tags/update").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult tagsDelete(String access_token, Integer id) {
        String json = String.format("{\"tag\":{\"id\":%d}}", id);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/tags/delete").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static UserTagGetResult userTagGet(String access_token, Integer tagid, String next_openid) {
        String json = String.format("{\"tagid\":%d,\"next_openid\":\"%s\"}", tagid, next_openid == null ? "" : next_openid);
        HttpUriRequest httpUriRequest = RequestBuilder.get().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/user/tag/get").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, UserTagGetResult.class);
    }

    public static BaseResult tagsMembersBatchtagging(String access_token, Integer tagid, String[] openids) {
        String json = String.format("{\"tagid\":%d,\"openid_list\":%s}", tagid, JsonUtil.toJSONString(openids));
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/tags/members/batchtagging").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult tagsMembersBatchuntagging(String access_token, Integer tagid, String[] openids) {
        String json = String.format("{\"tagid\":%d,\"openid_list\":%s}", tagid, JsonUtil.toJSONString(openids));
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/tags/members/batchtagging").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static TagsGetidlistResult tagsGetidlist(String access_token, String openid) {
        String json = String.format("{\"openid\":\"%s\"}", openid);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/tags/getidlist").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, TagsGetidlistResult.class);
    }

    public static GetblacklistResult tagsMembersGetblacklist(String access_token, String begin_openid) {
        String json = String.format("{\"begin_openid\":\"%s\"}", begin_openid == null ? "" : begin_openid);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/tags/members/getblacklist").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, GetblacklistResult.class);
    }

    public static BaseResult tagsMembersBatchblacklist(String access_token, String[] openid_list) {
        String json = String.format("{\"openid_list\":%s}", JsonUtil.toJSONString(openid_list));
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/tags/members/batchblacklist").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult tagsMembersBatchunblacklist(String access_token, String[] openid_list) {
        String json = String.format("{\"openid_list\":%s}", JsonUtil.toJSONString(openid_list));
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/tags/members/batchunblacklist").addParameter(UserAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }
}

