/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.util;

import java.util.Arrays;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import weixin.popular.bean.pay.PayFeedback;
import weixin.popular.bean.pay.PayNativeInput;
import weixin.popular.bean.pay.PayNotify;
import weixin.popular.bean.pay.PayWarn;
import weixin.popular.bean.paymch.MchPayNotify;
import weixin.popular.bean.paymch.PapayEntrustwebNotify;
import weixin.popular.util.MapUtil;
import weixin.popular.util.StringUtils;

public class SignatureUtil {
    public static String generatePackage(Map<String, String> map, String paternerKey) {
        String sign = SignatureUtil.generateSign(map, paternerKey);
        Map<String, String> tmap = MapUtil.order(map);
        String s2 = MapUtil.mapJoin(tmap, false, true);
        return s2 + "&sign=" + sign;
    }

    public static String generateSign(Map<String, String> map, String paternerKey) {
        return SignatureUtil.generateSign(map, null, paternerKey);
    }

    public static String generateSign(Map<String, String> map, String sign_type, String paternerKey) {
        Map<String, String> tmap = MapUtil.order(map);
        if (tmap.containsKey("sign")) {
            tmap.remove("sign");
        }
        String str = MapUtil.mapJoin(tmap, false, false);
        if (sign_type == null) {
            sign_type = tmap.get("sign_type");
        }
        if ("HMAC-SHA256".equalsIgnoreCase(sign_type)) {
            try {
                Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
                SecretKeySpec secret_key = new SecretKeySpec(paternerKey.getBytes("UTF-8"), "HmacSHA256");
                sha256_HMAC.init(secret_key);
                return Hex.encodeHexString((byte[])sha256_HMAC.doFinal((str + "&key=" + paternerKey).getBytes("UTF-8"))).toUpperCase();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return DigestUtils.md5Hex((String)(str + "&key=" + paternerKey)).toUpperCase();
    }

    public static String generatePaySign(Map<String, String> map, String paySignKey) {
        if (paySignKey != null) {
            map.put("appkey", paySignKey);
        }
        Map<String, String> tmap = MapUtil.order(map);
        String str = MapUtil.mapJoin(tmap, true, false);
        return DigestUtils.shaHex((String)str);
    }

    public static String generateEventMessageSignature(String token, String timestamp, String nonce) {
        Object[] array = new String[]{token, timestamp, nonce};
        Arrays.sort(array);
        String s = StringUtils.arrayToDelimitedString(array, "");
        return DigestUtils.shaHex((String)s);
    }

    public static boolean validateAppSignature(PayFeedback payFeedback, String paySignKey) {
        Map<String, String> map = MapUtil.objectToMap(payFeedback, "msgtype", "appsignature", "signmethod", "feedbackid", "transid", "reason", "solution", "extinfo", "picInfo");
        return payFeedback.getAppsignature().equals(SignatureUtil.generatePaySign(map, paySignKey));
    }

    public static boolean validateAppSignature(PayNativeInput payNativeInput, String paySignKey) {
        Map<String, String> map = MapUtil.objectToMap(payNativeInput, "appsignature", "signmethod");
        return payNativeInput.getAppsignature().equals(SignatureUtil.generatePaySign(map, paySignKey));
    }

    public static boolean validateAppSignature(PayNotify payNotify, String paySignKey) {
        Map<String, String> map = MapUtil.objectToMap(payNotify, "appsignature", "signmethod");
        return payNotify.getAppsignature().equals(SignatureUtil.generatePaySign(map, paySignKey));
    }

    public static boolean validateAppSignature(PayWarn payWarn, String paySignKey) {
        Map<String, String> map = MapUtil.objectToMap(payWarn, "appsignature", "signmethod");
        return payWarn.getAppsignature().equals(SignatureUtil.generatePaySign(map, paySignKey));
    }

    @Deprecated
    public static boolean validateAppSignature(MchPayNotify mchPayNotify, String key) {
        Map<String, String> map = MapUtil.objectToMap(mchPayNotify, new String[0]);
        return mchPayNotify.getSign().equals(SignatureUtil.generateSign(map, key));
    }

    @Deprecated
    public static boolean validateAppSignature(PapayEntrustwebNotify papayEntrustwebNotify, String key) {
        Map<String, String> map = MapUtil.objectToMap(papayEntrustwebNotify, new String[0]);
        return papayEntrustwebNotify.getSign().equals(SignatureUtil.generateSign(map, key));
    }

    public static boolean validateSign(Map<String, String> map, String key) {
        return map.get("sign").equals(SignatureUtil.generateSign(map, key));
    }

    public static boolean validateSign(Map<String, String> map, String sign_type, String key) {
        return map.get("sign").equals(SignatureUtil.generateSign(map, sign_type, key));
    }
}

