/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.plugin;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.DynamicParameter;
import com.github.xiaoymin.knife4j.annotations.DynamicParameters;
import com.github.xiaoymin.knife4j.core.util.CommonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483638)
public class DynamicParameterBuilderPlugin
implements ParameterBuilderPlugin {
    private final Map<String, String> cacheGenModelMaps = new HashMap<String, String>();

    public void apply(ParameterContext parameterContext) {
        ResolvedMethodParameter resolvedMethodParameter = parameterContext.resolvedMethodParameter();
        if (resolvedMethodParameter != null && resolvedMethodParameter.getParameterType() != null && resolvedMethodParameter.getParameterType().getErasedType() != null && (Map.class.isAssignableFrom(resolvedMethodParameter.getParameterType().getErasedType()) || resolvedMethodParameter.getParameterType().getErasedType().getName() == "com.google.gson.JsonObject")) {
            Optional supportOptional = parameterContext.getOperationContext().findAnnotation(ApiOperationSupport.class);
            Optional dynamicParametersOptional = parameterContext.getOperationContext().findAnnotation(DynamicParameters.class);
            if (dynamicParametersOptional.isPresent()) {
                this.changeDynamicParameterType((DynamicParameters)dynamicParametersOptional.get(), parameterContext);
            } else if (supportOptional.isPresent()) {
                ApiOperationSupport support = (ApiOperationSupport)supportOptional.get();
                this.changeDynamicParameterType(support.params(), parameterContext);
            }
        }
    }

    private void changeDynamicParameterType(DynamicParameters dynamicParameters, ParameterContext parameterContext) {
        if (dynamicParameters != null) {
            String name = dynamicParameters.name();
            if (name == null || "".equals(name)) {
                name = this.genClassName(parameterContext);
            }
            if (this.cacheGenModelMaps.containsKey(name)) {
                name = this.genClassName(parameterContext);
            }
            name = name.replaceAll("[_-]", "");
            DynamicParameter[] dynamics = dynamicParameters.properties();
            if (dynamics != null && dynamics.length > 0) {
                this.cacheGenModelMaps.put(name, name);
                parameterContext.parameterBuilder().parameterType("body").modelRef((ModelReference)new ModelRef(name)).name(name);
            }
        }
    }

    public String genClassName(ParameterContext parameterContext) {
        String name = parameterContext.getOperationContext().getName();
        return CommonUtils.genSupperName((String)name);
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

