/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.google.common.primitives.Ints;
import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.cache.CacheDescriptor;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.config.CacheConfig;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.monitoring.ClientEventHandler;
import com.orbitz.consul.option.QueryOptions;
import java.util.function.Function;

public class NodesCatalogCache
extends ConsulCache<String, Node> {
    private NodesCatalogCache(Function<Node, String> keyConversion, ConsulCache.CallbackConsumer<Node> callbackConsumer, CacheConfig cacheConfig, ClientEventHandler eventHandler) {
        super(keyConversion, callbackConsumer, cacheConfig, eventHandler, new CacheDescriptor("catalog.nodes"));
    }

    public static NodesCatalogCache newCache(CatalogClient catalogClient, QueryOptions queryOptions, int watchSeconds) {
        ConsulCache.CallbackConsumer<Node> callbackConsumer = (index, callback) -> catalogClient.getNodes(NodesCatalogCache.watchParams(index, watchSeconds, queryOptions), callback);
        return new NodesCatalogCache(Node::getNode, callbackConsumer, catalogClient.getConfig().getCacheConfig(), catalogClient.getEventHandler());
    }

    public static NodesCatalogCache newCache(CatalogClient catalogClient) {
        CacheConfig cacheConfig = catalogClient.getConfig().getCacheConfig();
        int watchSeconds = Ints.checkedCast((long)cacheConfig.getWatchDuration().getSeconds());
        return NodesCatalogCache.newCache(catalogClient, QueryOptions.BLANK, watchSeconds);
    }
}

