/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.agent.Check;
import com.orbitz.consul.model.catalog.CatalogRegistration;
import com.orbitz.consul.model.catalog.TaggedAddresses;
import com.orbitz.consul.model.catalog.WriteRequest;
import com.orbitz.consul.model.health.Service;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableCatalogRegistration
extends CatalogRegistration {
    @Nullable
    private final String datacenter;
    private final String node;
    private final String address;
    @Nullable
    private final TaggedAddresses taggedAddresses;
    @Nullable
    private final Service service;
    @Nullable
    private final Check check;
    @Nullable
    private final WriteRequest writeRequest;

    private ImmutableCatalogRegistration(@Nullable String datacenter, String node, String address, @Nullable TaggedAddresses taggedAddresses, @Nullable Service service, @Nullable Check check, @Nullable WriteRequest writeRequest) {
        this.datacenter = datacenter;
        this.node = node;
        this.address = address;
        this.taggedAddresses = taggedAddresses;
        this.service = service;
        this.check = check;
        this.writeRequest = writeRequest;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public Optional<String> datacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    @JsonProperty(value="Node")
    public String node() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Address")
    public String address() {
        return this.address;
    }

    @Override
    @JsonProperty(value="TaggedAddresses")
    public Optional<TaggedAddresses> taggedAddresses() {
        return Optional.ofNullable(this.taggedAddresses);
    }

    @Override
    @JsonProperty(value="Service")
    public Optional<Service> service() {
        return Optional.ofNullable(this.service);
    }

    @Override
    @JsonProperty(value="Check")
    public Optional<Check> check() {
        return Optional.ofNullable(this.check);
    }

    @Override
    @JsonProperty(value="WriteRequest")
    public Optional<WriteRequest> writeRequest() {
        return Optional.ofNullable(this.writeRequest);
    }

    public final ImmutableCatalogRegistration withDatacenter(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableCatalogRegistration(newValue, this.node, this.address, this.taggedAddresses, this.service, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableCatalogRegistration(value, this.node, this.address, this.taggedAddresses, this.service, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withNode(String value) {
        if (this.node.equals(value)) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, (String)Preconditions.checkNotNull((Object)value, (Object)"node"), this.address, this.taggedAddresses, this.service, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withAddress(String value) {
        if (this.address.equals(value)) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, (String)Preconditions.checkNotNull((Object)value, (Object)"address"), this.taggedAddresses, this.service, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withTaggedAddresses(TaggedAddresses value) {
        TaggedAddresses newValue = (TaggedAddresses)Preconditions.checkNotNull((Object)value, (Object)"taggedAddresses");
        if (this.taggedAddresses == newValue) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, newValue, this.service, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withTaggedAddresses(Optional<TaggedAddresses> optional) {
        TaggedAddresses value = optional.orElse(null);
        if (this.taggedAddresses == value) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, value, this.service, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withService(Service value) {
        Service newValue = (Service)Preconditions.checkNotNull((Object)value, (Object)"service");
        if (this.service == newValue) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, newValue, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withService(Optional<Service> optional) {
        Service value = optional.orElse(null);
        if (this.service == value) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, value, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withCheck(Check value) {
        Check newValue = (Check)Preconditions.checkNotNull((Object)value, (Object)"check");
        if (this.check == newValue) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, this.service, newValue, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withCheck(Optional<Check> optional) {
        Check value = optional.orElse(null);
        if (this.check == value) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, this.service, value, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withWriteRequest(WriteRequest value) {
        WriteRequest newValue = (WriteRequest)Preconditions.checkNotNull((Object)value, (Object)"writeRequest");
        if (this.writeRequest == newValue) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, this.service, this.check, newValue);
    }

    public final ImmutableCatalogRegistration withWriteRequest(Optional<WriteRequest> optional) {
        WriteRequest value = optional.orElse(null);
        if (this.writeRequest == value) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, this.service, this.check, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogRegistration && this.equalTo((ImmutableCatalogRegistration)another);
    }

    private boolean equalTo(ImmutableCatalogRegistration another) {
        return Objects.equals(this.datacenter, another.datacenter) && this.node.equals(another.node) && this.address.equals(another.address) && Objects.equals(this.taggedAddresses, another.taggedAddresses) && Objects.equals(this.service, another.service) && Objects.equals(this.check, another.check) && Objects.equals(this.writeRequest, another.writeRequest);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.datacenter});
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.address.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.taggedAddresses});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.service});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.check});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.writeRequest});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CatalogRegistration").omitNullValues().add("datacenter", (Object)this.datacenter).add("node", (Object)this.node).add("address", (Object)this.address).add("taggedAddresses", (Object)this.taggedAddresses).add("service", (Object)this.service).add("check", (Object)this.check).add("writeRequest", (Object)this.writeRequest).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableCatalogRegistration fromJson(Json json) {
        Builder builder = ImmutableCatalogRegistration.builder();
        if (json.datacenter != null) {
            builder.datacenter(json.datacenter);
        }
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.taggedAddresses != null) {
            builder.taggedAddresses(json.taggedAddresses);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.check != null) {
            builder.check(json.check);
        }
        if (json.writeRequest != null) {
            builder.writeRequest(json.writeRequest);
        }
        return builder.build();
    }

    public static ImmutableCatalogRegistration copyOf(CatalogRegistration instance) {
        if (instance instanceof ImmutableCatalogRegistration) {
            return (ImmutableCatalogRegistration)instance;
        }
        return ImmutableCatalogRegistration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_ADDRESS = 2L;
        private long initBits = 3L;
        @Nullable
        private String datacenter;
        @Nullable
        private String node;
        @Nullable
        private String address;
        @Nullable
        private TaggedAddresses taggedAddresses;
        @Nullable
        private Service service;
        @Nullable
        private Check check;
        @Nullable
        private WriteRequest writeRequest;

        private Builder() {
        }

        public final Builder from(CatalogRegistration instance) {
            Optional<WriteRequest> writeRequestOptional;
            Optional<Check> checkOptional;
            Optional<Service> serviceOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> datacenterOptional = instance.datacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            this.node(instance.node());
            this.address(instance.address());
            Optional<TaggedAddresses> taggedAddressesOptional = instance.taggedAddresses();
            if (taggedAddressesOptional.isPresent()) {
                this.taggedAddresses(taggedAddressesOptional);
            }
            if ((serviceOptional = instance.service()).isPresent()) {
                this.service(serviceOptional);
            }
            if ((checkOptional = instance.check()).isPresent()) {
                this.check(checkOptional);
            }
            if ((writeRequestOptional = instance.writeRequest()).isPresent()) {
                this.writeRequest(writeRequestOptional);
            }
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = (String)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        public final Builder node(String node) {
            this.node = (String)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder address(String address) {
            this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder taggedAddresses(TaggedAddresses taggedAddresses) {
            this.taggedAddresses = (TaggedAddresses)Preconditions.checkNotNull((Object)taggedAddresses, (Object)"taggedAddresses");
            return this;
        }

        public final Builder taggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses.orElse(null);
            return this;
        }

        public final Builder service(Service service) {
            this.service = (Service)Preconditions.checkNotNull((Object)service, (Object)"service");
            return this;
        }

        public final Builder service(Optional<Service> service) {
            this.service = service.orElse(null);
            return this;
        }

        public final Builder check(Check check) {
            this.check = (Check)Preconditions.checkNotNull((Object)check, (Object)"check");
            return this;
        }

        public final Builder check(Optional<Check> check) {
            this.check = check.orElse(null);
            return this;
        }

        public final Builder writeRequest(WriteRequest writeRequest) {
            this.writeRequest = (WriteRequest)Preconditions.checkNotNull((Object)writeRequest, (Object)"writeRequest");
            return this;
        }

        public final Builder writeRequest(Optional<WriteRequest> writeRequest) {
            this.writeRequest = writeRequest.orElse(null);
            return this;
        }

        public ImmutableCatalogRegistration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, this.service, this.check, this.writeRequest);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("address");
            }
            return "Cannot build CatalogRegistration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends CatalogRegistration {
        Optional<String> datacenter = Optional.empty();
        @Nullable
        String node;
        @Nullable
        String address;
        Optional<TaggedAddresses> taggedAddresses = Optional.empty();
        Optional<Service> service = Optional.empty();
        Optional<Check> check = Optional.empty();
        Optional<WriteRequest> writeRequest = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(Optional<String> datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="TaggedAddresses")
        public void setTaggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses;
        }

        @JsonProperty(value="Service")
        public void setService(Optional<Service> service) {
            this.service = service;
        }

        @JsonProperty(value="Check")
        public void setCheck(Optional<Check> check) {
            this.check = check;
        }

        @JsonProperty(value="WriteRequest")
        public void setWriteRequest(Optional<WriteRequest> writeRequest) {
            this.writeRequest = writeRequest;
        }

        @Override
        public Optional<String> datacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String node() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String address() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TaggedAddresses> taggedAddresses() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Service> service() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Check> check() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<WriteRequest> writeRequest() {
            throw new UnsupportedOperationException();
        }
    }
}

