/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.catalog.WriteRequest;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableWriteRequest
extends WriteRequest {
    private final String token;

    private ImmutableWriteRequest(String token) {
        this.token = token;
    }

    @Override
    @JsonProperty(value="Token")
    public String token() {
        return this.token;
    }

    public final ImmutableWriteRequest withToken(String value) {
        if (this.token.equals(value)) {
            return this;
        }
        return new ImmutableWriteRequest((String)Preconditions.checkNotNull((Object)value, (Object)"token"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWriteRequest && this.equalTo((ImmutableWriteRequest)another);
    }

    private boolean equalTo(ImmutableWriteRequest another) {
        return this.token.equals(another.token);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.token.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WriteRequest").omitNullValues().add("token", (Object)this.token).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableWriteRequest fromJson(Json json) {
        Builder builder = ImmutableWriteRequest.builder();
        if (json.token != null) {
            builder.token(json.token);
        }
        return builder.build();
    }

    public static ImmutableWriteRequest copyOf(WriteRequest instance) {
        if (instance instanceof ImmutableWriteRequest) {
            return (ImmutableWriteRequest)instance;
        }
        return ImmutableWriteRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private long initBits = 1L;
        @Nullable
        private String token;

        private Builder() {
        }

        public final Builder from(WriteRequest instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.token(instance.token());
            return this;
        }

        public final Builder token(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableWriteRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWriteRequest(this.token);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            return "Cannot build WriteRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends WriteRequest {
        @Nullable
        String token;

        Json() {
        }

        @JsonProperty(value="Token")
        public void setToken(String token) {
            this.token = token;
        }

        @Override
        public String token() {
            throw new UnsupportedOperationException();
        }
    }
}

