/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.coordinate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.coordinate.Coordinate;
import com.orbitz.consul.model.coordinate.Datacenter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableDatacenter
extends Datacenter {
    private final String datacenter;
    private final ImmutableList<Coordinate> coordinates;

    private ImmutableDatacenter(String datacenter, ImmutableList<Coordinate> coordinates) {
        this.datacenter = datacenter;
        this.coordinates = coordinates;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public String getDatacenter() {
        return this.datacenter;
    }

    @JsonProperty(value="Coordinates")
    public ImmutableList<Coordinate> getCoordinates() {
        return this.coordinates;
    }

    public final ImmutableDatacenter withDatacenter(String value) {
        if (this.datacenter.equals(value)) {
            return this;
        }
        return new ImmutableDatacenter((String)Preconditions.checkNotNull((Object)value, (Object)"datacenter"), this.coordinates);
    }

    public final ImmutableDatacenter withCoordinates(Coordinate ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDatacenter(this.datacenter, (ImmutableList<Coordinate>)newValue);
    }

    public final ImmutableDatacenter withCoordinates(Iterable<? extends Coordinate> elements) {
        if (this.coordinates == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDatacenter(this.datacenter, (ImmutableList<Coordinate>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDatacenter && this.equalTo((ImmutableDatacenter)another);
    }

    private boolean equalTo(ImmutableDatacenter another) {
        return this.datacenter.equals(another.datacenter) && this.coordinates.equals(another.coordinates);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.datacenter.hashCode();
        h = h * 17 + this.coordinates.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Datacenter").omitNullValues().add("datacenter", (Object)this.datacenter).add("coordinates", this.coordinates).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableDatacenter fromJson(Json json) {
        Builder builder = ImmutableDatacenter.builder();
        if (json.datacenter != null) {
            builder.datacenter(json.datacenter);
        }
        if (json.coordinates != null) {
            builder.addAllCoordinates(json.coordinates);
        }
        return builder.build();
    }

    public static ImmutableDatacenter copyOf(Datacenter instance) {
        if (instance instanceof ImmutableDatacenter) {
            return (ImmutableDatacenter)instance;
        }
        return ImmutableDatacenter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATACENTER = 1L;
        private long initBits = 1L;
        @Nullable
        private String datacenter;
        private ImmutableList.Builder<Coordinate> coordinatesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(Datacenter instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.datacenter(instance.getDatacenter());
            this.addAllCoordinates(instance.getCoordinates());
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = (String)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addCoordinates(Coordinate element) {
            this.coordinatesBuilder.add((Object)element);
            return this;
        }

        public final Builder addCoordinates(Coordinate ... elements) {
            this.coordinatesBuilder.add((Object[])elements);
            return this;
        }

        public final Builder coordinates(Iterable<? extends Coordinate> elements) {
            this.coordinatesBuilder = ImmutableList.builder();
            return this.addAllCoordinates(elements);
        }

        public final Builder addAllCoordinates(Iterable<? extends Coordinate> elements) {
            this.coordinatesBuilder.addAll(elements);
            return this;
        }

        public ImmutableDatacenter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDatacenter(this.datacenter, this.coordinatesBuilder.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("datacenter");
            }
            return "Cannot build Datacenter, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Datacenter {
        @Nullable
        String datacenter;
        List<Coordinate> coordinates = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(String datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="Coordinates")
        public void setCoordinates(List<Coordinate> coordinates) {
            this.coordinates = coordinates;
        }

        @Override
        public String getDatacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Coordinate> getCoordinates() {
            throw new UnsupportedOperationException();
        }
    }
}

