/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.operator.RaftConfiguration;
import com.orbitz.consul.model.operator.RaftServer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableRaftConfiguration
extends RaftConfiguration {
    private final ImmutableList<RaftServer> servers;
    private final BigInteger index;

    private ImmutableRaftConfiguration(ImmutableList<RaftServer> servers, BigInteger index) {
        this.servers = servers;
        this.index = index;
    }

    @JsonProperty(value="Servers")
    public ImmutableList<RaftServer> servers() {
        return this.servers;
    }

    @Override
    @JsonProperty(value="Index")
    public BigInteger index() {
        return this.index;
    }

    public final ImmutableRaftConfiguration withServers(RaftServer ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRaftConfiguration((ImmutableList<RaftServer>)newValue, this.index);
    }

    public final ImmutableRaftConfiguration withServers(Iterable<? extends RaftServer> elements) {
        if (this.servers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRaftConfiguration((ImmutableList<RaftServer>)newValue, this.index);
    }

    public final ImmutableRaftConfiguration withIndex(BigInteger value) {
        if (this.index == value) {
            return this;
        }
        return new ImmutableRaftConfiguration(this.servers, (BigInteger)Preconditions.checkNotNull((Object)value, (Object)"index"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRaftConfiguration && this.equalTo((ImmutableRaftConfiguration)another);
    }

    private boolean equalTo(ImmutableRaftConfiguration another) {
        return this.servers.equals(another.servers) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.servers.hashCode();
        h = h * 17 + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RaftConfiguration").omitNullValues().add("servers", this.servers).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableRaftConfiguration fromJson(Json json) {
        Builder builder = ImmutableRaftConfiguration.builder();
        if (json.servers != null) {
            builder.addAllServers(json.servers);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableRaftConfiguration copyOf(RaftConfiguration instance) {
        if (instance instanceof ImmutableRaftConfiguration) {
            return (ImmutableRaftConfiguration)instance;
        }
        return ImmutableRaftConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INDEX = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<RaftServer> serversBuilder = ImmutableList.builder();
        @Nullable
        private BigInteger index;

        private Builder() {
        }

        public final Builder from(RaftConfiguration instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllServers(instance.servers());
            this.index(instance.index());
            return this;
        }

        public final Builder addServers(RaftServer element) {
            this.serversBuilder.add((Object)element);
            return this;
        }

        public final Builder addServers(RaftServer ... elements) {
            this.serversBuilder.add((Object[])elements);
            return this;
        }

        public final Builder servers(Iterable<? extends RaftServer> elements) {
            this.serversBuilder = ImmutableList.builder();
            return this.addAllServers(elements);
        }

        public final Builder addAllServers(Iterable<? extends RaftServer> elements) {
            this.serversBuilder.addAll(elements);
            return this;
        }

        public final Builder index(BigInteger index) {
            this.index = (BigInteger)Preconditions.checkNotNull((Object)index, (Object)"index");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRaftConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRaftConfiguration(this.serversBuilder.build(), this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build RaftConfiguration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends RaftConfiguration {
        List<RaftServer> servers = ImmutableList.of();
        @Nullable
        BigInteger index;

        Json() {
        }

        @JsonProperty(value="Servers")
        public void setServers(List<RaftServer> servers) {
            this.servers = servers;
        }

        @JsonProperty(value="Index")
        public void setIndex(BigInteger index) {
            this.index = index;
        }

        @Override
        public List<RaftServer> servers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger index() {
            throw new UnsupportedOperationException();
        }
    }
}

