/*
 * Decompiled with CFR 0.152.
 */
package com.xkcoding.json.support.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.xkcoding.json.config.JsonConfig;
import com.xkcoding.json.exception.SimpleJsonException;
import com.xkcoding.json.support.AbstractJsonAdapter;
import com.xkcoding.json.util.StringUtil;
import java.lang.reflect.Type;
import java.util.Date;

public class GsonJsonAdapter
extends AbstractJsonAdapter {
    private static Gson gson;

    public GsonJsonAdapter() {
        this(new JsonConfig());
    }

    public GsonJsonAdapter(JsonConfig jsonConfig) {
        super(jsonConfig);
        this.configureGson(jsonConfig);
    }

    @Override
    public void setJsonConfig(JsonConfig jsonConfig) {
        super.setJsonConfig(jsonConfig);
        this.configureGson(jsonConfig);
    }

    private void configureGson(JsonConfig jsonConfig) {
        GsonBuilder gb = new GsonBuilder();
        if (StringUtil.isEmpty(jsonConfig.getDateFormat())) {
            gb.registerTypeAdapter(Date.class, (Object)new GsonDateSerializer()).setDateFormat(1);
            gb.registerTypeAdapter(Date.class, (Object)new GsonDateDeserializer()).setDateFormat(1);
        } else {
            gb.setDateFormat(jsonConfig.getDateFormat());
        }
        gson = gb.create();
    }

    @Override
    public String serialize(Object obj) throws SimpleJsonException {
        return gson.toJson(obj);
    }

    @Override
    public <T> T deserialize(String jsonStr, Class<T> clazz) throws SimpleJsonException {
        return (T)gson.fromJson(jsonStr, clazz);
    }

    private static class GsonDateDeserializer
    implements JsonDeserializer<Date> {
        private GsonDateDeserializer() {
        }

        public Date deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return new Date(json.getAsJsonPrimitive().getAsLong());
        }
    }

    private static class GsonDateSerializer
    implements JsonSerializer<Date> {
        private GsonDateSerializer() {
        }

        public JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)date.getTime());
        }
    }
}

