/*
 * Decompiled with CFR 0.152.
 */
package io.github.gitflowincrementalbuilder;

import io.github.gitflowincrementalbuilder.ChangedProjects;
import io.github.gitflowincrementalbuilder.Maven38DefaultDependencyGraph;
import io.github.gitflowincrementalbuilder.config.Configuration;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.graph.DefaultProjectDependencyGraph;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.ModelBase;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
class DownstreamCalculator {
    private static final String PCKG_POM = "pom";
    private static final String SCOPE_TEST = "test";
    private static final String TEST_JAR = "test-jar";
    private static final String TEST_JAR_DEFAULT_CLASSIFIER = "tests";
    private final Map<String, Set<MavenProject>> downstreamCache = new HashMap<String, Set<MavenProject>>();
    private final Map<String, Set<String>> testJarClassifiersCache = new HashMap<String, Set<String>>();
    private ProjectDependencyGraph graph;
    private Logger logger = LoggerFactory.getLogger(DownstreamCalculator.class);

    DownstreamCalculator() {
    }

    public Stream<MavenProject> streamProjectWithDownstreamProjects(MavenProject project, Configuration config) {
        if (this.graph == null) {
            List allProjects = config.mavenSession.getAllProjects();
            if (config.mavenSession.getProjects().size() != allProjects.size()) {
                try {
                    try {
                        this.graph = new DefaultProjectDependencyGraph((Collection)allProjects);
                    }
                    catch (NoClassDefFoundError err) {
                        this.graph = new Maven38DefaultDependencyGraph(allProjects);
                    }
                }
                catch (DuplicateProjectException | CycleDetectedException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                this.graph = config.mavenSession.getProjectDependencyGraph();
            }
        }
        boolean testOnly = Boolean.TRUE.equals(project.getContextValue(ChangedProjects.CTX_TEST_ONLY));
        return this.streamProjectWithDownstreamProjects(project, testOnly, config);
    }

    private Stream<MavenProject> streamProjectWithDownstreamProjects(MavenProject project, boolean testOnly, Configuration config) {
        String cacheKey = project.hashCode() + "_" + testOnly;
        Set<MavenProject> downstream = this.downstreamCache.get(cacheKey);
        if (downstream != null) {
            return downstream.stream();
        }
        downstream = new LinkedHashSet<MavenProject>();
        downstream.add(project);
        List unfilteredDownstream = this.graph.getDownstreamProjects(project, false);
        if (!unfilteredDownstream.isEmpty()) {
            for (MavenProject downstreamProj : unfilteredDownstream) {
                ActualDependentState state = this.getActualDependentState(downstreamProj, project, testOnly);
                this.logger.debug("{} -> {} :: {} [testOnly={}]", new Object[]{downstreamProj.getArtifactId(), project.getArtifactId(), state, testOnly});
                if (state == ActualDependentState.NONE) continue;
                this.streamProjectWithDownstreamProjects(downstreamProj, state == ActualDependentState.TEST, config).filter(proj -> this.isDownstreamModuleNotExcluded((MavenProject)proj, config)).forEach(downstream::add);
            }
        }
        if (PCKG_POM.equals(project.getPackaging())) {
            downstream.addAll(this.findBOMDownstreamProjects(project, downstream, config));
        }
        this.downstreamCache.put(cacheKey, downstream);
        return downstream.stream();
    }

    public void clearCache() {
        this.graph = null;
        this.downstreamCache.clear();
        this.testJarClassifiersCache.clear();
    }

    private ActualDependentState getActualDependentState(MavenProject downstreamProject, MavenProject upstreamProject, boolean upstreamTestOnly) {
        if (PCKG_POM.equals(upstreamProject.getPackaging()) && upstreamProject.equals((Object)downstreamProject.getParent())) {
            return ActualDependentState.MAIN;
        }
        Map depsByClassifier = downstreamProject.getDependencies().stream().filter(dep -> dep.getArtifactId().equals(upstreamProject.getArtifactId()) && dep.getGroupId().equals(upstreamProject.getGroupId()) && dep.getVersion().equals(upstreamProject.getVersion())).collect(Collectors.toMap(this::getClassifier, Function.identity(), (a, b) -> a));
        if (depsByClassifier.isEmpty()) {
            this.logger.debug("Could not find dependency to {} in {}", (Object)upstreamProject.getId(), (Object)downstreamProject.getId());
            return ActualDependentState.MAIN;
        }
        if (upstreamTestOnly) {
            Set<String> upstreamTestJarClassifiers = this.findTestJarClassifiers(upstreamProject);
            Map<String, List<Dependency>> testJarDepsByScope = depsByClassifier.entrySet().stream().filter(e -> upstreamTestJarClassifiers.contains(e.getKey())).map(Map.Entry::getValue).collect(Collectors.groupingBy(this::getScopeOrCompile));
            if (testJarDepsByScope.isEmpty()) {
                return ActualDependentState.NONE;
            }
            if (testJarDepsByScope.size() == 1 && testJarDepsByScope.containsKey(SCOPE_TEST) && testJarDepsByScope.get(SCOPE_TEST).stream().noneMatch(this::isMinimalDependency)) {
                return ActualDependentState.TEST;
            }
            return ActualDependentState.MAIN;
        }
        return depsByClassifier.values().stream().allMatch(d -> SCOPE_TEST.equals(d.getScope()) && !this.isMinimalDependency((Dependency)d)) ? ActualDependentState.TEST : ActualDependentState.MAIN;
    }

    private boolean isMinimalDependency(Dependency dependency) {
        List exclusions = dependency.getExclusions();
        if (exclusions.size() != 1) {
            return false;
        }
        Exclusion excl = (Exclusion)exclusions.get(0);
        return "*".equals(excl.getGroupId()) && "*".equals(excl.getArtifactId()) && PCKG_POM.equals(dependency.getType()) && SCOPE_TEST.equals(dependency.getScope());
    }

    private String getClassifier(Dependency dep) {
        String classifier = dep.getClassifier();
        if (classifier == null) {
            classifier = TEST_JAR.equals(dep.getType()) ? TEST_JAR_DEFAULT_CLASSIFIER : "";
        }
        return classifier;
    }

    private String getScopeOrCompile(Dependency dep) {
        String scope = dep.getScope();
        return scope != null ? scope : "compile";
    }

    private Set<String> findTestJarClassifiers(MavenProject project) {
        return this.testJarClassifiersCache.computeIfAbsent(String.valueOf(project.hashCode()), ignored -> project.getBuildPlugins().stream().filter(p -> "maven-jar-plugin".equals(p.getArtifactId())).flatMap(p -> p.getExecutions().stream().filter(e -> e.getGoals().contains(TEST_JAR))).map(e -> Xpp3DomWrapper.build(e.getConfiguration(), this.logger)).map(d -> Optional.ofNullable(d).map(xpp3Dom -> xpp3Dom.getChild("classifier")).map(Xpp3DomWrapper::getValue).orElse(TEST_JAR_DEFAULT_CLASSIFIER)).collect(Collectors.toUnmodifiableSet()));
    }

    private boolean isDownstreamModuleNotExcluded(MavenProject proj, Configuration config) {
        return !config.excludeDownstreamModulesPackagedAs.contains(proj.getPackaging());
    }

    private Set<MavenProject> findBOMDownstreamProjects(MavenProject potentialBOMProject, Set<MavenProject> downstream, Configuration config) {
        return config.mavenSession.getAllProjects().stream().filter(proj -> !downstream.contains(proj)).filter(proj -> this.isDownstreamModuleNotExcluded((MavenProject)proj, config)).filter(proj -> this.importsBOM((MavenProject)proj, potentialBOMProject, config)).flatMap(proj -> this.streamProjectWithDownstreamProjects((MavenProject)proj, false, config)).filter(config.mavenSession.getProjects()::contains).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Boolean importsBOM(MavenProject project, MavenProject potentialBOMProject, Configuration config) {
        return Optional.ofNullable(project.getOriginalModel()).map(ModelBase::getDependencyManagement).map(depMgtm -> depMgtm.getDependencies().stream().anyMatch(dep -> this.isBOMImport((Dependency)dep, potentialBOMProject, project, config))).orElse(false);
    }

    private boolean isBOMImport(Dependency dependency, MavenProject potentialBOMProject, MavenProject depDefiningProject, Configuration config) {
        LazyExpressionEvaluator evaluator = new LazyExpressionEvaluator(config.mavenSession, depDefiningProject);
        return Objects.equals(evaluator.evaluate(dependency.getType()), PCKG_POM) && Objects.equals(evaluator.evaluate(dependency.getScope()), "import") && Objects.equals(evaluator.evaluate(dependency.getArtifactId()), potentialBOMProject.getArtifactId()) && Objects.equals(evaluator.evaluate(dependency.getGroupId()), potentialBOMProject.getGroupId()) && Objects.equals(evaluator.evaluate(dependency.getVersion()), potentialBOMProject.getVersion());
    }

    private static enum ActualDependentState {
        MAIN,
        TEST,
        NONE;

    }

    private static class LazyExpressionEvaluator {
        private static final Logger LOGGER = LoggerFactory.getLogger(LazyExpressionEvaluator.class);
        private final MavenSession session;
        private final MavenProject project;
        private TypeAwareExpressionEvaluator evaluator;

        public LazyExpressionEvaluator(MavenSession session, MavenProject project) {
            this.session = session;
            this.project = project;
        }

        public String evaluate(String expression) {
            if (expression == null || !expression.contains("${")) {
                return expression;
            }
            if (this.evaluator == null) {
                MavenSession clonedSession = this.session.clone();
                clonedSession.setCurrentProject(this.project);
                this.evaluator = new PluginParameterExpressionEvaluator(clonedSession, new MojoExecution(new MojoDescriptor()));
            }
            try {
                return this.evaluator.evaluate(expression, String.class).toString();
            }
            catch (ExpressionEvaluationException e) {
                LOGGER.warn("Failed to evaluate: " + expression, (Throwable)e);
                return expression;
            }
        }
    }

    static interface Xpp3DomWrapper {
        public Xpp3DomWrapper getChild(String var1);

        public String getValue();

        public static Xpp3DomWrapper build(Object xpp3Dom, Logger logger) {
            if (xpp3Dom == null) {
                return null;
            }
            try {
                return new Direct((Xpp3Dom)xpp3Dom);
            }
            catch (ClassCastException e) {
                logger.info("Trying to access org.codehaus.plexus.util.xml.Xpp3Dom via reflection to work around an issue related to MNG-6965 and Maven 3.8.7 (or earlier); https://lists.apache.org/thread/wcbz8nsrrrdx8s8byoqpj99ksv73scqy\nConsider upgrading to Maven 3.8.8 or higher and setting <classLoadingStrategy>plugin</classLoadingStrategy> in extensions.xml (see its xsd for more details).");
                logger.debug("Full exception:", (Throwable)e);
                return new Reflective(xpp3Dom, logger);
            }
        }

        public static class Direct
        implements Xpp3DomWrapper {
            private final Xpp3Dom dom;

            Direct(Xpp3Dom dom) {
                this.dom = dom;
            }

            @Override
            public Xpp3DomWrapper getChild(String name) {
                Xpp3Dom child = this.dom.getChild(name);
                return child != null ? new Direct(child) : null;
            }

            @Override
            public String getValue() {
                return this.dom.getValue();
            }
        }

        public static class Reflective
        implements Xpp3DomWrapper {
            private static Method getChild;
            private static Method getValue;
            private final Object dom;
            private final Logger logger;

            Reflective(Object dom, Logger logger) {
                this.dom = dom;
                this.logger = logger;
            }

            @Override
            public Xpp3DomWrapper getChild(String name) {
                try {
                    Object child;
                    if (getChild == null) {
                        getChild = this.dom.getClass().getMethod("getChild", String.class);
                    }
                    return (child = getChild.invoke(this.dom, name)) != null ? new Reflective(child, this.logger) : null;
                }
                catch (ReflectiveOperationException | SecurityException e) {
                    this.logger.warn("Unable to apply reflection workaround for Xpp3Dom: {}", (Object)e.toString());
                    this.logger.debug("Full exception:", (Throwable)e);
                    return null;
                }
            }

            @Override
            public String getValue() {
                try {
                    Object value;
                    if (getValue == null) {
                        getValue = this.dom.getClass().getMethod("getValue", new Class[0]);
                    }
                    return (value = getValue.invoke(this.dom, new Object[0])) != null ? value.toString() : null;
                }
                catch (ReflectiveOperationException | SecurityException e) {
                    this.logger.warn("Unable to apply reflection workaround for Xpp3Dom: {}", (Object)e.toString());
                    this.logger.debug("Full exception:", (Throwable)e);
                    return null;
                }
            }
        }
    }
}

