/*
 * Decompiled with CFR 0.152.
 */
package io.github.gitflowincrementalbuilder;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectSorter;
import org.codehaus.plexus.util.dag.CycleDetectedException;

@SuppressFBWarnings(justification="Taken 1:1 from Maven")
class Maven38DefaultDependencyGraph
implements ProjectDependencyGraph {
    private final ProjectSorter sorter;
    private final List<MavenProject> allProjects;
    private final Map<MavenProject, Integer> order;
    private final Map<String, MavenProject> projects;

    public Maven38DefaultDependencyGraph(Collection<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        this.allProjects = Collections.unmodifiableList(new ArrayList<MavenProject>(projects));
        this.sorter = new ProjectSorter(projects);
        List sorted = this.sorter.getSortedProjects();
        this.order = new HashMap<MavenProject, Integer>(sorted.size());
        this.projects = new HashMap<String, MavenProject>(sorted.size());
        int index = 0;
        for (MavenProject project : sorted) {
            String id = ProjectSorter.getId((MavenProject)project);
            this.projects.put(id, project);
            this.order.put(project, index++);
        }
    }

    public Maven38DefaultDependencyGraph(List<MavenProject> allProjects, Collection<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        this.allProjects = Collections.unmodifiableList(new ArrayList<MavenProject>(allProjects));
        this.sorter = new ProjectSorter(projects);
        List sorted = this.sorter.getSortedProjects();
        this.order = new HashMap<MavenProject, Integer>(sorted.size());
        this.projects = new HashMap<String, MavenProject>(sorted.size());
        int index = 0;
        for (MavenProject project : sorted) {
            String id = ProjectSorter.getId((MavenProject)project);
            this.projects.put(id, project);
            this.order.put(project, index++);
        }
    }

    public List<MavenProject> getAllProjects() {
        return this.allProjects;
    }

    public List<MavenProject> getSortedProjects() {
        return new ArrayList<MavenProject>(this.sorter.getSortedProjects());
    }

    public List<MavenProject> getDownstreamProjects(MavenProject project, boolean transitive) {
        Objects.requireNonNull(project, "project cannot be null");
        HashSet<String> projectIds = new HashSet<String>();
        this.getDownstreamProjects(ProjectSorter.getId((MavenProject)project), projectIds, transitive);
        return this.getSortedProjects(projectIds);
    }

    private void getDownstreamProjects(String projectId, Set<String> projectIds, boolean transitive) {
        for (String id : this.sorter.getDependents(projectId)) {
            if (!projectIds.add(id) || !transitive) continue;
            this.getDownstreamProjects(id, projectIds, transitive);
        }
    }

    public List<MavenProject> getUpstreamProjects(MavenProject project, boolean transitive) {
        Objects.requireNonNull(project, "project cannot be null");
        HashSet<String> projectIds = new HashSet<String>();
        this.getUpstreamProjects(ProjectSorter.getId((MavenProject)project), projectIds, transitive);
        return this.getSortedProjects(projectIds);
    }

    private void getUpstreamProjects(String projectId, Collection<String> projectIds, boolean transitive) {
        for (String id : this.sorter.getDependencies(projectId)) {
            if (!projectIds.add(id) || !transitive) continue;
            this.getUpstreamProjects(id, projectIds, transitive);
        }
    }

    private List<MavenProject> getSortedProjects(Set<String> projectIds) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>(projectIds.size());
        for (String projectId : projectIds) {
            result.add(this.projects.get(projectId));
        }
        Collections.sort(result, new MavenProjectComparator());
        return result;
    }

    public String toString() {
        return this.sorter.getSortedProjects().toString();
    }

    private class MavenProjectComparator
    implements Comparator<MavenProject> {
        private MavenProjectComparator() {
        }

        @Override
        public int compare(MavenProject o1, MavenProject o2) {
            return Maven38DefaultDependencyGraph.this.order.get(o1) - Maven38DefaultDependencyGraph.this.order.get(o2);
        }
    }
}

