/*
 * Decompiled with CFR 0.152.
 */
package io.github.gitflowincrementalbuilder.jgit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.gitflowincrementalbuilder.SkipExecutionException;
import io.github.gitflowincrementalbuilder.config.Configuration;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class GitProvider {
    private static final String UNSUPPORTED_WORKTREE = "JGit unsupported separate worktree checkout detected from current git dir path: ";
    private Logger logger = LoggerFactory.getLogger(GitProvider.class);
    private Git git;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Makes no sense to wrap 'git', it's only for internal use anyway.")
    Git get(Configuration config) {
        if (this.git == null) {
            try {
                this.git = this.setupGit(config);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.git;
    }

    public Path getProjectRoot(Configuration config) {
        return this.get(config).getRepository().getDirectory().toPath().getParent();
    }

    public String getCurrentBranch(Configuration config) {
        try {
            return this.get(config).getRepository().getBranch();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void close() {
        if (this.git != null) {
            this.git.close();
            this.git.getRepository().close();
        }
    }

    private Git setupGit(Configuration config) throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        File pomDir = config.currentProject.getBasedir();
        builder.findGitDir(pomDir);
        if (builder.getGitDir() == null) {
            String gitDirNotFoundMessage = "Git repository root directory not found ascending from current working directory:'" + pomDir + "'.";
            this.logger.warn(gitDirNotFoundMessage + " Next step is determined by failOnMissingGitDir property.");
            if (config.failOnMissingGitDir) {
                throw new IllegalArgumentException(gitDirNotFoundMessage);
            }
            throw new SkipExecutionException(gitDirNotFoundMessage);
        }
        if (GitProvider.isWorktree(builder)) {
            throw new SkipExecutionException(UNSUPPORTED_WORKTREE + builder.getGitDir());
        }
        return Git.wrap((Repository)builder.build());
    }

    private static boolean isWorktree(FileRepositoryBuilder builder) {
        return Optional.ofNullable(builder.getGitDir().toPath().getParent()).filter(parent -> parent.getFileName().toString().equals("worktrees")).map(Path::getParent).filter(Objects::nonNull).map(parentParent -> parentParent.getFileName().toString().equals(".git")).orElse(false);
    }
}

