/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import io.netty.buffer.ByteBuf;
import io.rsocket.internal.jctools.queues.MpscUnboundedArrayQueue;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

public final class UnboundedProcessor
extends FluxProcessor<ByteBuf, ByteBuf>
implements Fuseable.QueueSubscription<ByteBuf>,
Fuseable {
    final Queue<ByteBuf> queue = new MpscUnboundedArrayQueue<ByteBuf>(Queues.SMALL_BUFFER_SIZE);
    final Queue<ByteBuf> priorityQueue = new MpscUnboundedArrayQueue<ByteBuf>(Queues.SMALL_BUFFER_SIZE);
    boolean done;
    Throwable error;
    CoreSubscriber<? super ByteBuf> actual;
    static final long STATE_TERMINATED = Long.MIN_VALUE;
    static final long FLAG_CANCELLED = 0x4000000000000000L;
    static final long FLAG_SUBSCRIBED_ONCE = 0x2000000000000000L;
    static final long MAX_VALUE = 0x1FFFFFFFFFFFFFFFL;
    volatile long state;
    static final AtomicLongFieldUpdater<UnboundedProcessor> STATE = AtomicLongFieldUpdater.newUpdater(UnboundedProcessor.class, "state");
    volatile int discardGuard;
    static final AtomicIntegerFieldUpdater<UnboundedProcessor> DISCARD_GUARD = AtomicIntegerFieldUpdater.newUpdater(UnboundedProcessor.class, "discardGuard");
    volatile long requested;
    static final AtomicLongFieldUpdater<UnboundedProcessor> REQUESTED = AtomicLongFieldUpdater.newUpdater(UnboundedProcessor.class, "requested");
    boolean outputFused;

    public int getBufferSize() {
        return Integer.MAX_VALUE;
    }

    public Object scanUnsafe(Scannable.Attr key) {
        if (Scannable.Attr.BUFFERED == key) {
            return this.queue.size();
        }
        if (Scannable.Attr.PREFETCH == key) {
            return Integer.MAX_VALUE;
        }
        return super.scanUnsafe(key);
    }

    public void onNextPrioritized(ByteBuf t) {
        if (this.done) {
            UnboundedProcessor.release(t);
            return;
        }
        if (!this.priorityQueue.offer(t)) {
            Throwable ex = Operators.onOperatorError(null, (Throwable)Exceptions.failWithOverflow(), (Object)t, (Context)this.currentContext());
            this.onError(Operators.onOperatorError(null, (Throwable)ex, (Object)t, (Context)this.currentContext()));
            UnboundedProcessor.release(t);
            return;
        }
        this.drain();
    }

    public void onNext(ByteBuf t) {
        if (this.done) {
            UnboundedProcessor.release(t);
            return;
        }
        if (!this.queue.offer(t)) {
            Throwable ex = Operators.onOperatorError(null, (Throwable)Exceptions.failWithOverflow(), (Object)t, (Context)this.currentContext());
            this.onError(Operators.onOperatorError(null, (Throwable)ex, (Object)t, (Context)this.currentContext()));
            UnboundedProcessor.release(t);
            return;
        }
        this.drain();
    }

    public void onError(Throwable t) {
        if (this.done) {
            Operators.onErrorDropped((Throwable)t, (Context)this.currentContext());
            return;
        }
        this.error = t;
        this.done = true;
        this.drain();
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.drain();
    }

    public void subscribe(CoreSubscriber<? super ByteBuf> actual) {
        Objects.requireNonNull(actual, "subscribe");
        if (UnboundedProcessor.markSubscribedOnce(this)) {
            this.actual = actual;
            actual.onSubscribe((Subscription)this);
            this.drain();
        } else {
            Operators.error(actual, (Throwable)new IllegalStateException("UnboundedProcessor allows only a single Subscriber"));
        }
    }

    void drain() {
        long previousState = UnboundedProcessor.wipIncrement(this);
        if (UnboundedProcessor.isTerminated(previousState)) {
            this.clearSafely();
            return;
        }
        if (UnboundedProcessor.isWorkInProgress(previousState)) {
            return;
        }
        boolean outputFused = this.outputFused;
        if (UnboundedProcessor.isCancelled(previousState) && !outputFused) {
            UnboundedProcessor.clearAndTerminate(this);
            return;
        }
        long expectedState = previousState + 1L;
        do {
            CoreSubscriber<? super ByteBuf> a;
            if ((a = this.actual) != null) {
                if (outputFused) {
                    this.drainFused(expectedState, (Subscriber<? super ByteBuf>)a);
                } else {
                    this.drainRegular(expectedState, (Subscriber<? super ByteBuf>)a);
                }
                return;
            }
            if (!UnboundedProcessor.isCancelled(expectedState = UnboundedProcessor.wipRemoveMissing(this, expectedState))) continue;
            UnboundedProcessor.clearAndTerminate(this);
            return;
        } while (UnboundedProcessor.isWorkInProgress(expectedState));
    }

    void drainRegular(long expectedState, Subscriber<? super ByteBuf> a) {
        Queue<ByteBuf> q = this.queue;
        Queue<ByteBuf> pq = this.priorityQueue;
        do {
            long e;
            long r = this.requested;
            for (e = 0L; r != e; ++e) {
                boolean empty;
                ByteBuf t;
                if (!pq.isEmpty()) {
                    t = pq.poll();
                    empty = false;
                } else {
                    t = q.poll();
                    boolean bl = empty = t == null;
                }
                if (this.checkTerminated(empty, a)) {
                    return;
                }
                if (empty) break;
                a.onNext((Object)t);
            }
            if (r == e && this.checkTerminated(q.isEmpty() && pq.isEmpty(), a)) {
                return;
            }
            if (e != 0L && r != Long.MAX_VALUE) {
                REQUESTED.addAndGet(this, -e);
            }
            if (!UnboundedProcessor.isCancelled(expectedState = UnboundedProcessor.wipRemoveMissing(this, expectedState))) continue;
            UnboundedProcessor.clearAndTerminate(this);
            return;
        } while (UnboundedProcessor.isWorkInProgress(expectedState));
    }

    void drainFused(long expectedState, Subscriber<? super ByteBuf> a) {
        do {
            boolean d = this.done;
            a.onNext(null);
            if (d) {
                Throwable ex = this.error;
                if (ex != null) {
                    a.onError(ex);
                } else {
                    a.onComplete();
                }
                return;
            }
            if (!UnboundedProcessor.isCancelled(expectedState = UnboundedProcessor.wipRemoveMissing(this, expectedState))) continue;
            return;
        } while (UnboundedProcessor.isWorkInProgress(expectedState));
    }

    boolean checkTerminated(boolean empty, Subscriber<? super ByteBuf> a) {
        long state = this.state;
        if (UnboundedProcessor.isCancelled(state)) {
            UnboundedProcessor.clearAndTerminate(this);
            return true;
        }
        if (this.done && empty) {
            Throwable e = this.error;
            if (e != null) {
                a.onError(e);
            } else {
                a.onComplete();
            }
            UnboundedProcessor.clearAndTerminate(this);
            return true;
        }
        return false;
    }

    public void onSubscribe(Subscription s) {
        long state = this.state;
        if (this.done || UnboundedProcessor.isTerminated(state) || UnboundedProcessor.isCancelled(state)) {
            s.cancel();
        } else {
            s.request(Long.MAX_VALUE);
        }
    }

    public int getPrefetch() {
        return Integer.MAX_VALUE;
    }

    public Context currentContext() {
        long state = this.state;
        if (UnboundedProcessor.isSubscribedOnce(state) || UnboundedProcessor.isTerminated(state)) {
            CoreSubscriber<? super ByteBuf> actual = this.actual;
            return actual != null ? actual.currentContext() : Context.empty();
        }
        return Context.empty();
    }

    public void request(long n) {
        if (Operators.validate((long)n)) {
            Operators.addCap(REQUESTED, (Object)((Object)this), (long)n);
            this.drain();
        }
    }

    public void cancel() {
        if (!UnboundedProcessor.markCancelled(this)) {
            return;
        }
        if (this.outputFused) {
            return;
        }
        long state = UnboundedProcessor.wipIncrement(this);
        if (UnboundedProcessor.isWorkInProgress(state)) {
            return;
        }
        UnboundedProcessor.clearAndTerminate(this);
    }

    @Nullable
    public ByteBuf poll() {
        Queue<ByteBuf> pq = this.priorityQueue;
        if (!pq.isEmpty()) {
            return pq.poll();
        }
        return this.queue.poll();
    }

    public void clear() {
        UnboundedProcessor.clearAndTerminate(this);
    }

    void clearSafely() {
        if (DISCARD_GUARD.getAndIncrement(this) != 0) {
            return;
        }
        int missed = 1;
        do {
            this.clearUnsafely();
        } while ((missed = DISCARD_GUARD.addAndGet(this, -missed)) != 0);
    }

    void clearUnsafely() {
        ByteBuf byteBuf;
        Queue<ByteBuf> queue = this.queue;
        Queue<ByteBuf> priorityQueue = this.priorityQueue;
        while ((byteBuf = queue.poll()) != null) {
            UnboundedProcessor.release(byteBuf);
        }
        while ((byteBuf = priorityQueue.poll()) != null) {
            UnboundedProcessor.release(byteBuf);
        }
    }

    public int size() {
        return this.priorityQueue.size() + this.queue.size();
    }

    public boolean isEmpty() {
        return this.priorityQueue.isEmpty() && this.queue.isEmpty();
    }

    public int requestFusion(int requestedMode) {
        if ((requestedMode & 2) != 0) {
            this.outputFused = true;
            return 2;
        }
        return 0;
    }

    public void dispose() {
        this.cancel();
    }

    public boolean isDisposed() {
        long state = this.state;
        return UnboundedProcessor.isTerminated(state) || UnboundedProcessor.isCancelled(state) || this.done;
    }

    public boolean isTerminated() {
        long state = this.state;
        return UnboundedProcessor.isTerminated(state) || this.done;
    }

    @Nullable
    public Throwable getError() {
        long state = this.state;
        if (UnboundedProcessor.isTerminated(state) || this.done) {
            return this.error;
        }
        return null;
    }

    public long downstreamCount() {
        return this.hasDownstreams() ? 1L : 0L;
    }

    public boolean hasDownstreams() {
        return (this.state & 0x2000000000000000L) == 0x2000000000000000L && this.actual != null;
    }

    static void release(ByteBuf byteBuf) {
        if (byteBuf.refCnt() > 0) {
            try {
                byteBuf.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static boolean markSubscribedOnce(UnboundedProcessor instance) {
        long state;
        do {
            if ((state = instance.state) == Long.MIN_VALUE) {
                return false;
            }
            if ((state & 0x2000000000000000L) != 0x2000000000000000L && (state & 0x4000000000000000L) != 0x4000000000000000L) continue;
            return false;
        } while (!STATE.compareAndSet(instance, state, state | 0x2000000000000000L));
        return true;
    }

    static boolean markCancelled(UnboundedProcessor instance) {
        long state;
        do {
            if ((state = instance.state) == Long.MIN_VALUE) {
                return false;
            }
            if ((state & 0x4000000000000000L) != 0x4000000000000000L) continue;
            return false;
        } while (!STATE.compareAndSet(instance, state, state | 0x4000000000000000L));
        return true;
    }

    static long wipIncrement(UnboundedProcessor instance) {
        long nextState;
        long state;
        do {
            if ((state = instance.state) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            nextState = state + 1L;
            if ((nextState & 0x1FFFFFFFFFFFFFFFL) != 0L) continue;
            return state;
        } while (!STATE.compareAndSet(instance, state, nextState));
        return state;
    }

    static long wipRemoveMissing(UnboundedProcessor instance, long previousState) {
        long nextState;
        long state;
        long missed = previousState & 0x1FFFFFFFFFFFFFFFL;
        boolean outputFused = instance.outputFused;
        do {
            if ((state = instance.state) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (outputFused || (state & 0x4000000000000000L) != 0x4000000000000000L) continue;
            return state;
        } while (!STATE.compareAndSet(instance, state, nextState = state - missed));
        return nextState;
    }

    static void clearAndTerminate(UnboundedProcessor instance) {
        long state;
        do {
            state = instance.state;
            if (instance.outputFused) {
                instance.clearSafely();
            } else {
                instance.clearUnsafely();
            }
            if (state != Long.MIN_VALUE) continue;
            return;
        } while (!STATE.compareAndSet(instance, state, Long.MIN_VALUE));
    }

    static boolean isCancelled(long state) {
        return (state & 0x4000000000000000L) == 0x4000000000000000L;
    }

    static boolean isWorkInProgress(long state) {
        return (state & 0x1FFFFFFFFFFFFFFFL) != 0L;
    }

    static boolean isTerminated(long state) {
        return state == Long.MIN_VALUE;
    }

    static boolean isSubscribedOnce(long state) {
        return (state & 0x2000000000000000L) == 0x2000000000000000L;
    }
}

