/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import io.rsocket.RSocket;
import io.rsocket.loadbalance.LoadbalanceStrategy;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class RoundRobinLoadbalanceStrategy
implements LoadbalanceStrategy {
    volatile int nextIndex;
    static final AtomicIntegerFieldUpdater<RoundRobinLoadbalanceStrategy> NEXT_INDEX = AtomicIntegerFieldUpdater.newUpdater(RoundRobinLoadbalanceStrategy.class, "nextIndex");

    @Override
    public RSocket select(List<RSocket> sockets) {
        int length = sockets.size();
        int indexToUse = Math.abs(NEXT_INDEX.getAndIncrement(this) % length);
        return sockets.get(indexToUse);
    }
}

