/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.metadata;

import io.netty.buffer.ByteBuf;
import io.rsocket.metadata.CompositeMetadataCodec;
import io.rsocket.metadata.WellKnownMimeType;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import reactor.util.annotation.Nullable;

public final class CompositeMetadata
implements Iterable<Entry> {
    private final boolean retainSlices;
    private final ByteBuf source;

    public CompositeMetadata(ByteBuf source, boolean retainSlices) {
        this.source = source;
        this.retainSlices = retainSlices;
    }

    public Stream<Entry> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 273), false);
    }

    @Override
    public Iterator<Entry> iterator() {
        return new Iterator<Entry>(){
            private int entryIndex = 0;

            @Override
            public boolean hasNext() {
                return CompositeMetadataCodec.hasEntry(CompositeMetadata.this.source, this.entryIndex);
            }

            @Override
            public Entry next() {
                ByteBuf[] headerAndData = CompositeMetadataCodec.decodeMimeAndContentBuffersSlices(CompositeMetadata.this.source, this.entryIndex, CompositeMetadata.this.retainSlices);
                ByteBuf header = headerAndData[0];
                ByteBuf data = headerAndData[1];
                this.entryIndex = CompositeMetadataCodec.computeNextEntryIndex(this.entryIndex, header, data);
                if (!CompositeMetadataCodec.isWellKnownMimeType(header)) {
                    CharSequence typeString = CompositeMetadataCodec.decodeMimeTypeFromMimeBuffer(header);
                    if (typeString == null) {
                        throw new IllegalStateException("MIME type cannot be null");
                    }
                    return new ExplicitMimeTimeEntry(data, typeString.toString());
                }
                byte id = CompositeMetadataCodec.decodeMimeIdFromMimeBuffer(header);
                WellKnownMimeType type = WellKnownMimeType.fromIdentifier(id);
                if (WellKnownMimeType.UNKNOWN_RESERVED_MIME_TYPE == type) {
                    return new ReservedMimeTypeEntry(data, id);
                }
                return new WellKnownMimeTypeEntry(data, type);
            }
        };
    }

    public static final class WellKnownMimeTypeEntry
    implements Entry {
        private final ByteBuf content;
        private final WellKnownMimeType type;

        public WellKnownMimeTypeEntry(ByteBuf content, WellKnownMimeType type) {
            this.content = content;
            this.type = type;
        }

        @Override
        public ByteBuf getContent() {
            return this.content;
        }

        @Override
        public String getMimeType() {
            return this.type.getString();
        }

        public WellKnownMimeType getType() {
            return this.type;
        }
    }

    public static final class ReservedMimeTypeEntry
    implements Entry {
        private final ByteBuf content;
        private final int type;

        public ReservedMimeTypeEntry(ByteBuf content, int type) {
            this.content = content;
            this.type = type;
        }

        @Override
        public ByteBuf getContent() {
            return this.content;
        }

        @Override
        public String getMimeType() {
            return null;
        }

        public int getType() {
            return this.type;
        }
    }

    public static final class ExplicitMimeTimeEntry
    implements Entry {
        private final ByteBuf content;
        private final String type;

        public ExplicitMimeTimeEntry(ByteBuf content, String type) {
            this.content = content;
            this.type = type;
        }

        @Override
        public ByteBuf getContent() {
            return this.content;
        }

        @Override
        public String getMimeType() {
            return this.type;
        }
    }

    public static interface Entry {
        public ByteBuf getContent();

        @Nullable
        public String getMimeType();
    }
}

