/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.GlobalAuthUtils;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthQqRequest
extends AuthDefaultRequest {
    public AuthQqRequest(AuthConfig config) {
        super(config, AuthDefaultSource.QQ);
    }

    public AuthQqRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.QQ, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        String response = this.doGetAuthorizationCode(authCallback.getCode());
        return this.getAuthToken(response);
    }

    @Override
    public AuthResponse refresh(AuthToken authToken) {
        String response = new HttpUtils(this.config.getHttpConfig()).get(this.refreshTokenUrl(authToken.getRefreshToken()));
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getAuthToken(response)).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String openId = this.getOpenId(authToken);
        String response = this.doGetUserInfo(authToken);
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.getIntValue("ret") != 0) {
            throw new AuthException(object.getString("msg"));
        }
        String avatar = object.getString("figureurl_qq_2");
        if (StringUtils.isEmpty(avatar)) {
            avatar = object.getString("figureurl_qq_1");
        }
        String location = String.format("%s-%s", object.getString("province"), object.getString("city"));
        return AuthUser.builder().rawUserInfo(object).username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(avatar).location(location).uuid(openId).gender(AuthUserGender.getRealGender(object.getString("gender"))).token(authToken).source(this.source.toString()).build();
    }

    private String getOpenId(AuthToken authToken) {
        String response = new HttpUtils(this.config.getHttpConfig()).get(UrlBuilder.fromBaseUrl("https://graph.qq.com/oauth2.0/me").queryParam("access_token", authToken.getAccessToken()).queryParam("unionid", this.config.isUnionId() ? 1 : 0).build());
        String removePrefix = response.replace("callback(", "");
        String removeSuffix = removePrefix.replace(");", "");
        String openId = removeSuffix.trim();
        JSONObject object = JSONObject.parseObject((String)openId);
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.get((Object)"error") + ":" + object.get((Object)"error_description"));
        }
        authToken.setOpenId(object.getString("openid"));
        if (object.containsKey((Object)"unionid")) {
            authToken.setUnionId(object.getString("unionid"));
        }
        return StringUtils.isEmpty(authToken.getUnionId()) ? authToken.getOpenId() : authToken.getUnionId();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("oauth_consumer_key", this.config.getClientId()).queryParam("openid", authToken.getOpenId()).build();
    }

    private AuthToken getAuthToken(String response) {
        Map<String, String> accessTokenObject = GlobalAuthUtils.parseStringToMap(response);
        if (!accessTokenObject.containsKey("access_token") || accessTokenObject.containsKey("code")) {
            throw new AuthException(accessTokenObject.get("msg"));
        }
        return AuthToken.builder().accessToken(accessTokenObject.get("access_token")).expireIn(Integer.valueOf(accessTokenObject.get("expires_in"))).refreshToken(accessTokenObject.get("refresh_token")).build();
    }
}

