/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.util.ArrayList;
import java.util.Hashtable;
import org.javacc.jjtree.ASTGrammar;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeGlobals;
import org.javacc.jjtree.JJTreeIOException;
import org.javacc.jjtree.JJTreeOptions;
import org.javacc.jjtree.JJTreeParser;
import org.javacc.jjtree.JJTreeState;
import org.javacc.jjtree.NodeFiles;
import org.javacc.jjtree.ParseException;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.Main;

public class JJTree {
    private IO io;

    private void p(String string) {
        this.io.getMsg().println(string);
    }

    private void help_message() {
        this.p("Usage:");
        this.p("    jjtree option-settings inputfile");
        this.p("");
        this.p("\"option-settings\" is a sequence of settings separated by spaces.");
        this.p("Each option setting must be of one of the following forms:");
        this.p("");
        this.p("    -optionname=value (e.g., -STATIC=false)");
        this.p("    -optionname:value (e.g., -STATIC:false)");
        this.p("    -optionname       (equivalent to -optionname=true.  e.g., -STATIC)");
        this.p("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOSTATIC)");
        this.p("");
        this.p("Option settings are not case-sensitive, so one can say \"-nOsTaTiC\" instead");
        this.p("of \"-NOSTATIC\".  Option values must be appropriate for the corresponding");
        this.p("option, and must be either an integer or a string value.");
        this.p("");
        this.p("The boolean valued options are:");
        this.p("");
        this.p("    STATIC                   (default true)");
        this.p("    MULTI                    (default false)");
        this.p("    NODE_DEFAULT_VOID        (default false)");
        this.p("    NODE_SCOPE_HOOK          (default false)");
        this.p("    NODE_USES_PARSER         (default false)");
        this.p("    BUILD_NODE_FILES         (default true)");
        this.p("    TRACK_TOKENS             (default false)");
        this.p("    VISITOR                  (default false)");
        this.p("");
        this.p("The string valued options are:");
        this.p("");
        this.p("    JDK_VERSION              (default \"1.5\")");
        this.p("    NODE_CLASS               (default \"\")");
        this.p("    NODE_PREFIX              (default \"AST\")");
        this.p("    NODE_PACKAGE             (default \"\")");
        this.p("    NODE_EXTENDS             (default \"\")");
        this.p("    NODE_FACTORY             (default \"\")");
        this.p("    OUTPUT_FILE              (default remove input file suffix, add .jj)");
        this.p("    OUTPUT_DIRECTORY         (default \"\")");
        this.p("    JJTREE_OUTPUT_DIRECTORY  (default value of OUTPUT_DIRECTORY option)");
        this.p("    VISITOR_DATA_TYPE        (default \"\")");
        this.p("    VISITOR_RETURN_TYPE      (default \"Object\")");
        this.p("    VISITOR_EXCEPTION        (default \"\")");
        this.p("");
        this.p("JJTree also accepts JavaCC options, which it inserts into the generated file.");
        this.p("");
        this.p("EXAMPLES:");
        this.p("    jjtree -STATIC=false mygrammar.jjt");
        this.p("");
        this.p("ABOUT JJTree:");
        this.p("    JJTree is a preprocessor for JavaCC that inserts actions into a");
        this.p("    JavaCC grammar to build parse trees for the input.");
        this.p("");
        this.p("    For more information, see the online JJTree documentation at ");
        this.p("    https://javacc.dev.java.net/doc/JJTree.html ");
        this.p("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int main(String[] stringArray) {
        ASTNodeDescriptor.nodeIds = new ArrayList();
        ASTNodeDescriptor.nodeNames = new ArrayList();
        ASTNodeDescriptor.nodeSeen = new Hashtable();
        Main.reInitAll();
        JavaCCGlobals.bannerLine("Tree Builder", "");
        this.io = new IO();
        try {
            this.initializeOptions();
            if (stringArray.length == 0) {
                this.p("");
                this.help_message();
                int n = 1;
                return n;
            }
            this.p("(type \"jjtree\" with no arguments for help)");
            String string = stringArray[stringArray.length - 1];
            if (JJTreeOptions.isOption(string)) {
                this.p("Last argument \"" + string + "\" is not a filename");
                int n = 1;
                return n;
            }
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (!JJTreeOptions.isOption(stringArray[i])) {
                    this.p("Argument \"" + stringArray[i] + "\" must be an option setting.");
                    int n = 1;
                    return n;
                }
                JJTreeOptions.setCmdLineOption(stringArray[i]);
            }
            JJTreeOptions.validate();
            try {
                this.io.setInput(string);
            }
            catch (JJTreeIOException jJTreeIOException) {
                this.p("Error setting input: " + jJTreeIOException.getMessage());
                int n = 1;
                this.io.closeAll();
                return n;
            }
            this.p("Reading from file " + this.io.getInputFileName() + " . . .");
            JJTreeGlobals.toolList = JavaCCGlobals.getToolNames(string);
            JJTreeGlobals.toolList.add("JJTree");
            JJTreeParser jJTreeParser = new JJTreeParser(this.io.getIn());
            jJTreeParser.javacc_input();
            ASTGrammar aSTGrammar = (ASTGrammar)jJTreeParser.jjtree.rootNode();
            if (Boolean.getBoolean("jjtree-dump")) {
                aSTGrammar.dump(" ");
            }
            try {
                this.io.setOutput();
            }
            catch (JJTreeIOException jJTreeIOException) {
                this.p("Error setting output: " + jJTreeIOException.getMessage());
                int n = 1;
                this.io.closeAll();
                return n;
            }
            try {
                aSTGrammar.generate(this.io);
                this.io.getOut().close();
                NodeFiles.generateTreeConstants_java();
                NodeFiles.generateVisitor_java();
                JJTreeState.generateTreeState_java();
                this.p("Annotated grammar generated successfully in " + this.io.getOutputFileName());
            }
            catch (ParseException parseException) {
                this.p("Error parsing input: " + parseException.toString());
                int n = 1;
                this.io.closeAll();
                return n;
            }
            catch (Exception exception) {
                this.p("Error parsing input: " + exception.toString());
                exception.printStackTrace(this.io.getMsg());
                int n = 1;
                this.io.closeAll();
                return n;
            }
            int n = 0;
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.io.closeAll();
        }
    }

    private void initializeOptions() {
        JJTreeOptions.init();
        JJTreeGlobals.initialize();
    }
}

