/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.types;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.utils.ConverterUtil;

public abstract class Union {
    protected Object localObject;

    public Object getObject() {
        return this.localObject;
    }

    public abstract void setObject(Object var1);

    public String toString() {
        return this.localObject.toString();
    }

    public void setObject(XMLStreamReader xmlStreamReader, String namespaceURI, String type) throws URI.MalformedURIException, XMLStreamException {
        String value = xmlStreamReader.getElementText();
        if ("string".equals(type)) {
            this.setObject(value);
        } else if ("int".equals(type) || "integer".equals(type)) {
            this.setObject(new Integer(value));
        } else if ("boolean".equals(type)) {
            this.setObject(new Boolean(value));
        } else if ("anyURI".equals(type)) {
            this.setObject(new URI(value));
        } else if ("date".equals(type)) {
            this.setObject(ConverterUtil.convertToDate(value));
        } else if ("QName".equals(type)) {
            if (value.indexOf(":") > 0) {
                String prefix = value.substring(0, value.indexOf(":"));
                String localPart = value.substring(value.indexOf(":") + 1);
                String namespace = xmlStreamReader.getNamespaceURI(prefix);
                this.setObject(new QName(namespace, localPart, prefix));
            } else {
                this.setObject(new QName(value));
            }
        } else if ("datetime".equals(type)) {
            this.setObject(ConverterUtil.convertToDateTime(value));
        } else if ("time".equals(type)) {
            this.setObject(ConverterUtil.convertToTime(value));
        } else if ("float".equals(type)) {
            this.setObject(new Float(value));
        } else if ("long".equals(type)) {
            this.setObject(new Long(value));
        } else if ("dobule".equals(type)) {
            this.setObject(new Double(value));
        } else {
            throw new RuntimeException("Object not found");
        }
    }
}

