/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.scram;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.security.auth.callback.CallbackHandler;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramFormatter;
import org.apache.kafka.common.security.scram.ScramMechanism;
import org.apache.kafka.common.security.scram.ScramSaslServer;
import org.apache.kafka.common.security.scram.ScramServerCallbackHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScramSaslServerTest {
    private static final String USER_A = "userA";
    private static final String USER_B = "userB";
    private ScramMechanism mechanism;
    private ScramFormatter formatter;
    private ScramSaslServer saslServer;

    @Before
    public void setUp() throws Exception {
        this.mechanism = ScramMechanism.SCRAM_SHA_256;
        this.formatter = new ScramFormatter(this.mechanism);
        CredentialCache.Cache credentialCache = new CredentialCache().createCache(this.mechanism.mechanismName(), ScramCredential.class);
        credentialCache.put(USER_A, (Object)this.formatter.generateCredential("passwordA", 4096));
        credentialCache.put(USER_B, (Object)this.formatter.generateCredential("passwordB", 4096));
        ScramServerCallbackHandler callbackHandler = new ScramServerCallbackHandler(credentialCache);
        this.saslServer = new ScramSaslServer(this.mechanism, new HashMap(), (CallbackHandler)callbackHandler);
    }

    @Test
    public void noAuthorizationIdSpecified() throws Exception {
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.clientFirstMessage(USER_A, null));
        Assert.assertTrue((String)"Next challenge is empty", (nextChallenge.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void authorizatonIdEqualsAuthenticationId() throws Exception {
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.clientFirstMessage(USER_A, USER_A));
        Assert.assertTrue((String)"Next challenge is empty", (nextChallenge.length > 0 ? 1 : 0) != 0);
    }

    @Test(expected=SaslAuthenticationException.class)
    public void authorizatonIdNotEqualsAuthenticationId() throws Exception {
        this.saslServer.evaluateResponse(this.clientFirstMessage(USER_A, USER_B));
    }

    private byte[] clientFirstMessage(String userName, String authorizationId) {
        String nonce = this.formatter.secureRandomString();
        String authorizationField = authorizationId != null ? "a=" + authorizationId : "";
        String firstMessage = String.format("n,%s,n=%s,r=%s", authorizationField, userName, nonce);
        return firstMessage.getBytes(StandardCharsets.UTF_8);
    }
}

