/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.Task;

public abstract class AbstractTask
implements Task {
    private Task.State state = Task.State.CREATED;
    protected Set<TopicPartition> inputPartitions;
    protected ProcessorTopology topology;
    protected final TaskId id;
    protected final StateDirectory stateDirectory;
    protected final ProcessorStateManager stateMgr;

    AbstractTask(TaskId id, ProcessorTopology topology, StateDirectory stateDirectory, ProcessorStateManager stateMgr, Set<TopicPartition> inputPartitions) {
        this.id = id;
        this.stateMgr = stateMgr;
        this.topology = topology;
        this.inputPartitions = inputPartitions;
        this.stateDirectory = stateDirectory;
    }

    @Override
    public TaskId id() {
        return this.id;
    }

    @Override
    public Set<TopicPartition> inputPartitions() {
        return this.inputPartitions;
    }

    @Override
    public Collection<TopicPartition> changelogPartitions() {
        return this.stateMgr.changelogPartitions();
    }

    @Override
    public void markChangelogAsCorrupted(Collection<TopicPartition> partitions) {
        this.stateMgr.markChangelogAsCorrupted(partitions);
    }

    @Override
    public StateStore getStore(String name) {
        return this.stateMgr.getStore(name);
    }

    @Override
    public boolean isClosed() {
        return this.state() == Task.State.CLOSED;
    }

    @Override
    public final Task.State state() {
        return this.state;
    }

    @Override
    public void revive() {
        if (this.state != Task.State.CLOSED) {
            throw new IllegalStateException("Illegal state " + (Object)((Object)this.state()) + " while reviving task " + this.id);
        }
        this.transitionTo(Task.State.CREATED);
    }

    final void transitionTo(Task.State newState) {
        Task.State oldState = this.state();
        if (!oldState.isValidTransition(newState)) {
            throw new IllegalStateException("Invalid transition from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState));
        }
        this.state = newState;
    }

    @Override
    public void update(Set<TopicPartition> topicPartitions, Map<String, List<String>> nodeToSourceTopics) {
        this.inputPartitions = topicPartitions;
        this.topology.updateSourceTopics(nodeToSourceTopics);
    }
}

