/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.nio.ByteBuffer;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionStateManagerTest$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.Log;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.utils.MockScheduler;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\tUh\u0001B\u0001\u0003\u0001%\u00111\u0004\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:UKN$(BA\u0002\u0005\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005\u00151\u0011aC2p_J$\u0017N\\1u_JT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAqA\u0006\u0001C\u0002\u0013\u0005q#A\u0006qCJ$\u0018\u000e^5p]&#W#\u0001\r\u0011\u0005-I\u0012B\u0001\u000e\r\u0005\rIe\u000e\u001e\u0005\u00079\u0001\u0001\u000b\u0011\u0002\r\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\t\u000fy\u0001!\u0019!C\u0001/\u0005ia.^7QCJ$\u0018\u000e^5p]NDa\u0001\t\u0001!\u0002\u0013A\u0012A\u00048v[B\u000b'\u000f^5uS>t7\u000f\t\u0005\bE\u0001\u0011\r\u0011\"\u0001\u0018\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\"1A\u0005\u0001Q\u0001\na\tQ\u0003\u001e:b]N\f7\r^5p]RKW.Z8vi6\u001b\b\u0005C\u0004'\u0001\t\u0007I\u0011A\u0014\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t\u0001\u0006\u0005\u0002*c5\t!F\u0003\u0002,Y\u000511m\\7n_:T!aB\u0017\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0005\u0003e)\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u00045\u0001\u0001\u0006I\u0001K\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA!9a\u0007\u0001b\u0001\n\u00039\u0012\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011\u0019A\u0004\u0001)A\u00051\u0005\t2m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0011\t\u000fi\u0002!\u0019!C\u0001w\u0005QA\u000f\u001f8SK\u000e|'\u000fZ:\u0016\u0003q\u00022!\u0010\"E\u001b\u0005q$BA A\u0003\u001diW\u000f^1cY\u0016T!!\u0011\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002D}\tY\u0011I\u001d:bs\n+hMZ3s!\t)\u0005*D\u0001G\u0015\t9%&\u0001\u0004sK\u000e|'\u000fZ\u0005\u0003\u0013\u001a\u0013AbU5na2,'+Z2pe\u0012Daa\u0013\u0001!\u0002\u0013a\u0014a\u0003;y]J+7m\u001c:eg\u0002Bq!\u0014\u0001C\u0002\u0013\u0005a*\u0001\u0003uS6,W#A(\u0011\u0005A\u001bV\"A)\u000b\u0005IS\u0013!B;uS2\u001c\u0018B\u0001+R\u0005!iunY6US6,\u0007B\u0002,\u0001A\u0003%q*A\u0003uS6,\u0007\u0005C\u0004Y\u0001\t\u0007I\u0011A-\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u0001.\u0011\u0005mkV\"\u0001/\u000b\u0005I3\u0011B\u00010]\u00055iunY6TG\",G-\u001e7fe\"1\u0001\r\u0001Q\u0001\ni\u000b!b]2iK\u0012,H.\u001a:!\u0011\u001d\u0011\u0007A1A\u0005\u0002\r\fqA_6Vi&d7/F\u0001e!\tYV-\u0003\u0002g9\n9!l[+uS2\u001c\bB\u00025\u0001A\u0003%A-\u0001\u0005{WV#\u0018\u000e\\:!\u0011\u001dQ\u0007A1A\u0005\u0002-\faB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001m!\ti\u0007/D\u0001o\u0015\tyg!\u0001\u0004tKJ4XM]\u0005\u0003c:\u0014aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u0004t\u0001\u0001\u0006I\u0001\\\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!9Q\u000f\u0001b\u0001\n\u00031\u0018!\u0003;y]\u000e{gNZ5h+\u00059\bC\u0001\u000by\u0013\tI(AA\tUe\u0006t7/Y2uS>t7i\u001c8gS\u001eDaa\u001f\u0001!\u0002\u00139\u0018A\u0003;y]\u000e{gNZ5hA!9Q\u0010\u0001b\u0001\n\u0003q\u0018A\u0005;sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ,\u0012a \t\u0004)\u0005\u0005\u0011bAA\u0002\u0005\t9BK]1og\u0006\u001cG/[8o'R\fG/Z'b]\u0006<WM\u001d\u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003\u0000\u0003M!(/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:!\u0011%\tY\u0001\u0001b\u0001\n\u0003\ti!\u0001\tue\u0006t7/Y2uS>t\u0017\r\\%ecU\u0011\u0011q\u0002\t\u0005\u0003#\t9BD\u0002\f\u0003'I1!!\u0006\r\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011DA\u000e\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0003\u0007\t\u0011\u0005}\u0001\u0001)A\u0005\u0003\u001f\t\u0011\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u0019!\u0011%\t\u0019\u0003\u0001b\u0001\n\u0003\ti!\u0001\tue\u0006t7/Y2uS>t\u0017\r\\%ee!A\u0011q\u0005\u0001!\u0002\u0013\ty!A\tue\u0006t7/Y2uS>t\u0017\r\\%ee\u0001B\u0011\"a\u000b\u0001\u0005\u0004%\t!!\f\u0002'QDh.T3tg\u0006<WmS3z\u0005f$Xm]\u0019\u0016\u0005\u0005=\u0002#B\u0006\u00022\u0005U\u0012bAA\u001a\u0019\t)\u0011I\u001d:bsB\u00191\"a\u000e\n\u0007\u0005eBB\u0001\u0003CsR,\u0007\u0002CA\u001f\u0001\u0001\u0006I!a\f\u0002)QDh.T3tg\u0006<WmS3z\u0005f$Xm]\u0019!\u0011%\t\t\u0005\u0001b\u0001\n\u0003\ti#A\nuq:lUm]:bO\u0016\\U-\u001f\"zi\u0016\u001c(\u0007\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u0018\u0003Q!\bP\\'fgN\fw-Z&fs\nKH/Z:3A!I\u0011\u0011\n\u0001C\u0002\u0013\u0005\u00111J\u0001\faJ|G-^2fe&#7/\u0006\u0002\u0002NAA\u0011qJA)\u0003\u001f\t)&D\u0001A\u0013\r\t\u0019\u0006\u0011\u0002\u0004\u001b\u0006\u0004\bcA\u0006\u0002X%\u0019\u0011\u0011\f\u0007\u0003\t1{gn\u001a\u0005\t\u0003;\u0002\u0001\u0015!\u0003\u0002N\u0005a\u0001O]8ek\u000e,'/\u00133tA!I\u0011\u0011\r\u0001A\u0002\u0013\u0005\u00111M\u0001\ribtW*\u001a;bI\u0006$\u0018-M\u000b\u0003\u0003K\u00022\u0001FA4\u0013\r\tIG\u0001\u0002\u0014)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u0005\n\u0003[\u0002\u0001\u0019!C\u0001\u0003_\n\u0001\u0003\u001e=o\u001b\u0016$\u0018\rZ1uCFzF%Z9\u0015\t\u0005E\u0014q\u000f\t\u0004\u0017\u0005M\u0014bAA;\u0019\t!QK\\5u\u0011)\tI(a\u001b\u0002\u0002\u0003\u0007\u0011QM\u0001\u0004q\u0012\n\u0004\u0002CA?\u0001\u0001\u0006K!!\u001a\u0002\u001bQDh.T3uC\u0012\fG/Y\u0019!\u0011%\t\t\t\u0001a\u0001\n\u0003\t\u0019'\u0001\u0007uq:lU\r^1eCR\f'\u0007C\u0005\u0002\u0006\u0002\u0001\r\u0011\"\u0001\u0002\b\u0006\u0001B\u000f\u001f8NKR\fG-\u0019;be}#S-\u001d\u000b\u0005\u0003c\nI\t\u0003\u0006\u0002z\u0005\r\u0015\u0011!a\u0001\u0003KB\u0001\"!$\u0001A\u0003&\u0011QM\u0001\u000eibtW*\u001a;bI\u0006$\u0018M\r\u0011\t\u0013\u0005E\u0005\u00011A\u0005\u0002\u0005M\u0015!D3ya\u0016\u001cG/\u001a3FeJ|'/\u0006\u0002\u0002\u0016B!\u0011qSAO\u001b\t\tIJC\u0002\u0002\u001c*\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003?\u000bIJ\u0001\u0004FeJ|'o\u001d\u0005\n\u0003G\u0003\u0001\u0019!C\u0001\u0003K\u000b\u0011#\u001a=qK\u000e$X\rZ#se>\u0014x\fJ3r)\u0011\t\t(a*\t\u0015\u0005e\u0014\u0011UA\u0001\u0002\u0004\t)\n\u0003\u0005\u0002,\u0002\u0001\u000b\u0015BAK\u00039)\u0007\u0010]3di\u0016$WI\u001d:pe\u0002Bq!a,\u0001\t\u0003\t\t,A\u0003tKR,\u0006\u000f\u0006\u0002\u0002r!\"\u0011QVA[!\u0011\t9,!0\u000e\u0005\u0005e&bAA^_\u0005)!.\u001e8ji&!\u0011qXA]\u0005\u0019\u0011UMZ8sK\"9\u00111\u0019\u0001\u0005\u0002\u0005E\u0016\u0001\u0003;fCJ$un\u001e8)\t\u0005\u0005\u0017q\u0019\t\u0005\u0003o\u000bI-\u0003\u0003\u0002L\u0006e&!B!gi\u0016\u0014\bbBAh\u0001\u0011\u0005\u0011\u0011W\u0001\u001fi\u0016\u001cHOV1mS\u0012\fG/\u001a+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRDC!!4\u0002TB!\u0011qWAk\u0013\u0011\t9.!/\u0003\tQ+7\u000f\u001e\u0005\b\u00037\u0004A\u0011AAY\u00039!Xm\u001d;BI\u0012<U\r\u001e)jINDC!!7\u0002T\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005E\u0016!\u000b;fgRdu.\u00193B]\u0012\u0014V-\\8wKR\u0013\u0018M\\:bGRLwN\\:G_J\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0003\u0002`\u0006M\u0007bBAt\u0001\u0011\u0005\u0011\u0011W\u0001*i\u0016\u001cHoQ8na2,G/\u001a+sC:\u001c\u0018\u000e^5p]^CWM\\!qa\u0016tGmU;dG\u0016,G-\u001a3)\t\u0005\u0015\u00181\u001b\u0005\b\u0003[\u0004A\u0011AAY\u00031\"Xm\u001d;BaB,g\u000e\u001a$bS2$vnQ8pe\u0012Lg.\u0019;pe:{G/\u0011<bS2\f'\r\\3FeJ|'\u000f\u000b\u0003\u0002l\u0006M\u0007bBAz\u0001\u0011\u0005\u0011\u0011W\u0001$i\u0016\u001cH/\u00119qK:$g)Y5m)>tu\u000e^\"p_J$\u0017N\\1u_J,%O]8sQ\u0011\t\t0a5\t\u000f\u0005e\b\u0001\"\u0001\u00022\u00069C/Z:u\u0003B\u0004XM\u001c3GC&dGk\\\"p_J$\u0017N\\1u_Jdu.\u00193j]\u001e,%O]8sQ\u0011\t90a5\t\u000f\u0005}\b\u0001\"\u0001\u00022\u0006aB/Z:u\u0003B\u0004XM\u001c3GC&dGk\\+oW:|wO\\#se>\u0014\b\u0006BA\u007f\u0003'DqA!\u0002\u0001\t\u0003\t\t,A\u0013uKN$\b+\u001a8eS:<7\u000b^1uK:{GOU3tKR|eNU3uef\f\u0005\u000f]3oI\"\"!1AAj\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003c\u000bQ\u0006^3ti\u0006\u0003\b/\u001a8e)J\fgn]1di&|g\u000eV8M_\u001e<\u0006.\u001b7f!J|G-^2fe\u001a+gnY3eQ\u0011\u0011I!a5\t\u000f\tE\u0001\u0001\"\u0001\u00022\u0006\u0011D/Z:u\u0003B\u0004XM\u001c3Ue\u0006t7/Y2uS>tGk\u001c'pO^C\u0017\u000e\\3QK:$\u0017N\\4Ti\u0006$Xm\u00115b]\u001e,G\r\u000b\u0005\u0003\u0010\u0005M'Q\u0003B\f\u0003!)\u0007\u0010]3di\u0016$7E\u0001B\r!\u0011\u0011YB!\n\u000e\u0005\tu!\u0002\u0002B\u0010\u0005C\tA\u0001\\1oO*\u0011!1E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003(\tu!!F%mY\u0016<\u0017\r\\*uCR,W\t_2faRLwN\u001c\u0005\b\u0005W\u0001A\u0011AAY\u0003}\u001a\bn\\;mIJ+G/\u001e:o\u001d>$8i\\8sS\u0012t\u0017\r^8s\u000bJ\u0014xN]%g)J\fgn]1di&|g.\u00133QCJ$\u0018\u000e^5p]:{GoT<oK\u0012DCA!\u000b\u0002T\"9!\u0011\u0007\u0001\u0005\u0002\u0005E\u0016AN:i_VdGm\u00148ms\u000e{gn]5eKJ$&/\u00198tC\u000e$\u0018n\u001c8t\u0013:$\u0006.Z(oO>LgnZ*uCR,Gk\\!c_J$\b\u0006\u0002B\u0018\u0003'DqAa\u000e\u0001\t\u0003\t\t,\u0001\u001dtQ>,H\u000eZ,sSR,G\u000b\u001f8NCJ\\WM]:G_J$&/\u00198tC\u000e$\u0018n\u001c8J]B\u0013X\r]1sK\u0012\u001cu.\\7jiN#\u0018\r^3)\t\tU\u00121\u001b\u0005\b\u0005{\u0001A\u0011AAY\u0003]\u001a\bn\\;mI^\u0013\u0018\u000e^3Uq:l\u0015M]6feN4uN\u001d+sC:\u001c\u0018m\u0019;j_:Le\u000e\u0015:fa\u0006\u0014X\rZ!c_J$8\u000b^1uK\"\"!1HAj\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0003c\u000b!g\u001d5pk2$'+Z7pm\u0016\u001cu.\u001c9mKR,7i\\7n[&$X\t\u001f9je\u0016$GK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0005\u0005\u0003\n\u0019\u000eC\u0004\u0003J\u0001!\t!!-\u0002aMDw.\u001e7e%\u0016lwN^3D_6\u0004H.\u001a;f\u0003\n|'\u000f^#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\u0011\u00119%a5\t\u000f\t=\u0003\u0001\"\u0001\u00022\u0006A3\u000f[8vY\u0012\u0014V-\\8wK\u0016k\u0007\u000f^=FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%eg\"\"!QJAj\u0011\u001d\u0011)\u0006\u0001C\u0001\u0003c\u000bag\u001d5pk2$gj\u001c;SK6|g/Z#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133t\u0013\u001adunZ!qa\u0016tGMR1jYNDCAa\u0015\u0002T\"9!1\f\u0001\u0005\u0002\u0005E\u0016AJ:i_VdGMT8u%\u0016lwN^3P]\u001e|\u0017N\\4Ue\u0006t7/Y2uS>t\u0017\r\\%eg\"\"!\u0011LAj\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0003c\u000b1f\u001d5pk2$gj\u001c;SK6|g/\u001a)sKB\f'/Z!c_J$HK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0005\u0005?\n\u0019\u000eC\u0004\u0003h\u0001!\t!!-\u0002YMDw.\u001e7e\u001d>$(+Z7pm\u0016\u0004&/\u001a9be\u0016\u001cu.\\7jiR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\b\u0006\u0002B3\u0003'DqA!\u001c\u0001\t\u0013\u0011y'A\fwKJLg-_'fi\u0006$\u0017\r^1E_\u0016\u001cX\t_5tiR!\u0011\u0011\u000fB9\u0011!\u0011\u0019Ha\u001bA\u0002\u0005=\u0011a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\t\u000f\t]\u0004\u0001\"\u0003\u0003z\u0005Ib/\u001a:jMflU\r^1eCR\fGi\\3t]R,\u00050[:u)\u0011\t\tHa\u001f\t\u0011\tM$Q\u000fa\u0001\u0003\u001fAqAa \u0001\t\u0013\u0011\t)\u0001\u0013tKR,\b/\u00118e%VtGK]1og\u0006\u001cG/[8oC2LE-\u0012=qSJ\fG/[8o)\u0019\t\tHa!\u0003\b\"A!Q\u0011B?\u0001\u0004\t)*A\u0003feJ|'\u000f\u0003\u0005\u0003\n\nu\u0004\u0019\u0001BF\u0003!!\bP\\*uCR,\u0007c\u0001\u000b\u0003\u000e&\u0019!q\u0012\u0002\u0003!Q\u0013\u0018M\\:bGRLwN\\*uCR,\u0007b\u0002BJ\u0001\u0011%!QS\u0001%m\u0016\u0014\u0018NZ=Xe&$Xm\u001d+y]6\u000b'o[3sg&s\u0007K]3qCJ,7\u000b^1uKR!\u0011\u0011\u000fBL\u0011!\u0011IJ!%A\u0002\t-\u0015!B:uCR,\u0007b\u0002BO\u0001\u0011%!qT\u0001\u000fCN\u001cXM\u001d;DC2d'-Y2l)\u0011\t\tH!)\t\u0011\t\u0015%1\u0014a\u0001\u0003+CqA!*\u0001\t\u0013\u00119+A\nue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\u0006\u0006\u0002f\t%&1\u0016BX\u0005cC\u0001Ba\u001d\u0003$\u0002\u0007\u0011q\u0002\u0005\t\u0005[\u0013\u0019\u000b1\u0001\u0002V\u0005Q\u0001O]8ek\u000e,'/\u00133\t\u0015\te%1\u0015I\u0001\u0002\u0004\u0011Y\tC\u0005\u00034\n\r\u0006\u0013!a\u00011\u0005QA\u000f\u001f8US6,w.\u001e;\t\u000f\t]\u0006\u0001\"\u0003\u0003:\u0006i\u0001O]3qCJ,G\u000b\u001f8M_\u001e$\u0002\"!\u001d\u0003<\nu&\u0011\u0019\u0005\u0007M\tU\u0006\u0019\u0001\u0015\t\u0011\t}&Q\u0017a\u0001\u0003+\n1b\u001d;beR|eMZ:fi\"A!1\u0019B[\u0001\u0004\u0011)-A\u0004sK\u000e|'\u000fZ:\u0011\u0007\u0015\u00139-C\u0002\u0003J\u001a\u0013Q\"T3n_JL(+Z2pe\u0012\u001c\bb\u0002Bg\u0001\u0011%!qZ\u0001\u001baJ,\u0007/\u0019:f\r>\u0014H\u000b\u001f8NKN\u001c\u0018mZ3BaB,g\u000e\u001a\u000b\u0005\u0003c\u0012\t\u000e\u0003\u0005\u0003\u0006\n-\u0007\u0019AAK\u0011%\u0011)\u000eAI\u0001\n\u0013\u00119.A\u000fue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011IN\u000b\u0003\u0003\f\nm7F\u0001Bo!\u0011\u0011yN!;\u000e\u0005\t\u0005(\u0002\u0002Br\u0005K\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001dH\"\u0001\u0006b]:|G/\u0019;j_:LAAa;\u0003b\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t=\b!%A\u0005\n\tE\u0018!\b;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\fG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tM(f\u0001\r\u0003\\\u0002")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @Before
    public void setUp() {
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId1()));
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.zkUtils(), this.replicaManager()});
        this.transactionManager().shutdown();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    @Test
    public void testAddGetPids() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata2()));
    }

    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records2);
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Errors err) {
                Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Option<CoordinatorEpochAndTxnMetadata> x$1) {
                return TestUtils$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId1()).append((Object)"'s transaction state is already in the cache").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Errors err) {
                Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Option<CoordinatorEpochAndTxnMetadata> x$2) {
                return TestUtils$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId2()).append((Object)"'s transaction state is already in the cache").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String x$3, int x$4, TransactionResult x$5, TransactionMetadata x$6, TxnTransitMetadata x$7) {
            }
        });
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Errors err) {
                return TestUtils$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId1()).append((Object)"'s transaction state access returns error ").append((Object)err).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final CoordinatorEpochAndTxnMetadata apply(Option<CoordinatorEpochAndTxnMetadata> entry) {
                return (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testLoadAndRemoveTransactionsForPartition$7 $outer;

                    public final Nothing$ apply() {
                        return TestUtils$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$$outer().transactionalId1()).append((Object)"'s transaction state was not loaded into the cache").toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TransactionStateManagerTest kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Errors err) {
                return TestUtils$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId1()).append((Object)"'s transaction state access returns error ").append((Object)err).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final CoordinatorEpochAndTxnMetadata apply(Option<CoordinatorEpochAndTxnMetadata> entry) {
                return (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final Nothing$ apply() {
                        return TestUtils$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$$outer().transactionalId1()).append((Object)"'s transaction state was not loaded into the cache").toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TransactionStateManagerTest kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Errors err) {
                return TestUtils$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId2()).append((Object)"'s transaction state access returns error ").append((Object)err).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final CoordinatorEpochAndTxnMetadata apply(Option<CoordinatorEpochAndTxnMetadata> entry) {
                return (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final Nothing$ apply() {
                        return TestUtils$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$$outer().transactionalId2()).append((Object)"'s transaction state was not loaded into the cache").toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TransactionStateManagerTest kafka$coordinator$transaction$TransactionStateManagerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assert.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Errors err) {
                Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Option<CoordinatorEpochAndTxnMetadata> x$8) {
                return TestUtils$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId1()).append((Object)"'s transaction state is still in the cache").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Errors err) {
                Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Option<CoordinatorEpochAndTxnMetadata> x$9) {
                return TestUtils$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId2()).append((Object)"'s transaction state is still in the cache").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), this.coordinatorEpoch(), newMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToNotCoordinatorError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_FOR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToUnknownError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN_SERVER_ERROR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Errors x$10) {
                return true;
            }
        });
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test(expected=IllegalStateException.class)
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(error);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned() {
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Errors err) {
                Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final Nothing$ apply(Option<CoordinatorEpochAndTxnMetadata> x$11) {
                return TestUtils$.MODULE$.fail(new StringBuilder().append((Object)this.$outer.transactionalId1()).append((Object)"'s transaction state is already in the cache").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int partitionId) {
                this.$outer.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.transactionManager().putTransactionStateIfNotExists("ongoing", this.transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("not-expiring", this.transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists("prepare-commit", this.transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("prepare-abort", this.transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("complete-commit", this.transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("complete-abort", this.transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransactionalIdAndProducerIdEpoch[]{new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0)})), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommmitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExist(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExist(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExist(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExist(this.transactionalId1());
        this.verifyMetadataDoesExist(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExist(this.transactionalId1());
        this.verifyMetadataDoesExist(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExist(this.transactionalId1());
        this.verifyMetadataDoesExist(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExist(this.transactionalId1());
        this.verifyMetadataDoesExist(this.transactionalId2());
    }

    private void verifyMetadataDoesExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw TestUtils$.MODULE$.fail("shouldn't have been any errors");
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.b();
            if (None$.MODULE$.equals(option2)) {
                throw TestUtils$.MODULE$.fail("metadata should have been removed");
            }
        }
        if (bl && (option = (Option)right.b()) instanceof Some) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new MatchError((Object)either);
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw TestUtils$.MODULE$.fail("shouldn't have been any errors");
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.b();
            if (option2 instanceof Some) {
                throw TestUtils$.MODULE$.fail("metadata should have been removed");
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)right.b())) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new MatchError((Object)either);
    }

    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        BoxedUnit boxedUnit;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int partitionId) {
                this.$outer.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Capture capturedArgument = EasyMock.newCapture();
        TopicPartition partition = new TopicPartition("__transaction_state", this.transactionManager().partitionFor(this.transactionalId1()));
        Map recordsByPartition = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds() + (long)this.txnConfig().removeExpiredTransactionalIdsIntervalMs(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null)}))}));
        TransactionState transactionState = txnState;
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
        if (bl) {
            this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.eq((short)((short)-1)), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.eq((Object)recordsByPartition), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
            boxedUnit = EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, error, capturedArgument, partition){
                private final Errors error$2;
                private final Capture capturedArgument$1;
                private final TopicPartition partition$1;

                public void answer() {
                    ((Function1)this.capturedArgument$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition$1), (Object)new ProduceResponse.PartitionResponse(this.error$2, 0L, -1L, 0L))})));
                }
                {
                    this.error$2 = error$2;
                    this.capturedArgument$1 = capturedArgument$1;
                    this.partition$1 = partition$1;
                }
            });
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId2(), this.txnMetadata2());
        this.transactionManager().enableTransactionalIdExpiration();
        this.time().sleep((long)this.txnConfig().removeExpiredTransactionalIdsIntervalMs());
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        this.txnMetadata1().state_$eq(state);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 0L;
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records2);
        ObjectRef txnId = ObjectRef.create(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5)new Serializable(this, txnId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionStateManagerTest $outer;
            private final ObjectRef txnId$1;

            public final void apply(String transactionalId, int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata) {
                this.$outer.kafka$coordinator$transaction$TransactionStateManagerTest$$rememberTxnMarkers$1(transactionalId, coordinatorEpoch, command, metadata, newMetadata, this.txnId$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.txnId$1 = txnId$1;
            }
        });
        this.scheduler().tick();
        Assert.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    public void kafka$coordinator$transaction$TransactionStateManagerTest$$assertCallback(Errors error) {
        Assert.assertEquals((Object)this.expectedError(), (Object)error);
    }

    private TransactionMetadata transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, (short)0, txnTimeout, state, this.time().milliseconds());
    }

    private TransactionState transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    private int transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records2) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Log logMock = (Log)EasyMock.mock(Log.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        long endOffset = startOffset + (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size();
        EasyMock.expect((Object)this.replicaManager().getLog(topicPartition)).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(topicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (Option)EasyMock.eq((Object)None$.MODULE$), EasyMock.eq((boolean)true), (IsolationLevel)EasyMock.eq((Object)IsolationLevel.READ_UNCOMMITTED))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)fileRecordsMock.readInto((ByteBuffer)EasyMock.anyObject(ByteBuffer.class), EasyMock.anyInt())).andReturn((Object)records2.buffer());
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
    }

    private void prepareForTxnMessageAppend(Errors error) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, error, capturedArgument){
            private final /* synthetic */ TransactionStateManagerTest $outer;
            private final Errors error$1;
            private final Capture capturedArgument$2;

            public void answer() {
                ((Function1)this.capturedArgument$2.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__transaction_state", this.$outer.partitionId())), (Object)new ProduceResponse.PartitionResponse(this.error$1, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.error$1 = error$1;
                this.capturedArgument$2 = capturedArgument$2;
            }
        });
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
    }

    public final void kafka$coordinator$transaction$TransactionStateManagerTest$$rememberTxnMarkers$1(String transactionalId, int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = transactionalId;
    }

    public TransactionStateManagerTest() {
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        EasyMock.expect((Object)this.zkUtils().getTopicPartitionCount("__transaction_state")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions()))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkUtils()});
        this.txnConfig = new TransactionConfig(TransactionConfig$.MODULE$.apply$default$1(), TransactionConfig$.MODULE$.apply$default$2(), TransactionConfig$.MODULE$.apply$default$3(), TransactionConfig$.MODULE$.apply$default$4(), TransactionConfig$.MODULE$.apply$default$5(), TransactionConfig$.MODULE$.apply$default$6(), TransactionConfig$.MODULE$.apply$default$7(), TransactionConfig$.MODULE$.apply$default$8(), TransactionConfig$.MODULE$.apply$default$9(), TransactionConfig$.MODULE$.apply$default$10());
        this.transactionManager = new TransactionStateManager(0, this.zkUtils(), (Scheduler)this.scheduler(), this.replicaManager(), this.txnConfig(), (Time)this.time());
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        this.producerIds = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId1()), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId2()), (Object)BoxesRunTime.boxToLong((long)2L))}));
        this.txnMetadata1 = this.transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.txnMetadata2 = this.transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.expectedError = Errors.NONE;
    }
}

