/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.List;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.cluster.Replica;
import kafka.controller.KafkaController;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.Log;
import kafka.log.TimestampOffset;
import kafka.network.RequestChannel;
import kafka.security.auth.Authorizer;
import kafka.server.AdminManager;
import kafka.server.BrokerTopicStats;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.easymock.IExpectationSetters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\ruc\u0001B\u0001\u0003\u0001%\u0011QbS1gW\u0006\f\u0005/[:UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\u0011QAB\u0001\u0006W\u000647.\u0019\u0006\u0002\u000f\u0005!QO\\5u\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g\u0011\u0015\t\u0002\u0001\"\u0001\u0013\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u0015\u00015\t!\u0001C\u0004\u0017\u0001\t\u0007I\u0011B\f\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYV\t\u0001\u0004\u0005\u0002\u001a;5\t!D\u0003\u0002\u001c9\u00059a.\u001a;x_J\\'\"A\u0003\n\u0005yQ\"A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0005\u0007A\u0001\u0001\u000b\u0011\u0002\r\u0002\u001fI,\u0017/^3ti\u000eC\u0017M\u001c8fY\u0002BqA\t\u0001C\u0002\u0013%1%A\u000bsKF,Xm\u001d;DQ\u0006tg.\u001a7NKR\u0014\u0018nY:\u0016\u0003\u0011\u0002\"!\n\u0015\u000f\u0005e1\u0013BA\u0014\u001b\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2L!!\u000b\u0016\u0003\u000f5+GO]5dg*\u0011qE\u0007\u0005\u0007Y\u0001\u0001\u000b\u0011\u0002\u0013\u0002-I,\u0017/^3ti\u000eC\u0017M\u001c8fY6+GO]5dg\u0002BqA\f\u0001C\u0002\u0013%q&\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0003A\u0002\"!M\u001a\u000e\u0003IR!a\u0001\u000f\n\u0005Q\u0012$A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\u0007m\u0001\u0001\u000b\u0011\u0002\u0019\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002Bq\u0001\u000f\u0001C\u0002\u0013%\u0011(\u0001\the>,\boQ8pe\u0012Lg.\u0019;peV\t!\b\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005)qM]8va*\u0011q\bH\u0001\fG>|'\u000fZ5oCR|'/\u0003\u0002By\t\u0001rI]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0005\u0007\u0007\u0002\u0001\u000b\u0011\u0002\u001e\u0002#\u001d\u0014x.\u001e9D_>\u0014H-\u001b8bi>\u0014\b\u0005C\u0004F\u0001\t\u0007I\u0011\u0002$\u0002\u0019\u0005$W.\u001b8NC:\fw-\u001a:\u0016\u0003\u001d\u0003\"!\r%\n\u0005%\u0013$\u0001D!e[&tW*\u00198bO\u0016\u0014\bBB&\u0001A\u0003%q)A\u0007bI6Lg.T1oC\u001e,'\u000f\t\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003O\u00039!\bP\\\"p_J$\u0017N\\1u_J,\u0012a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0003%z\n1\u0002\u001e:b]N\f7\r^5p]&\u0011A+\u0015\u0002\u0017)J\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe\"1a\u000b\u0001Q\u0001\n=\u000bq\u0002\u001e=o\u0007>|'\u000fZ5oCR|'\u000f\t\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0003)\u0019wN\u001c;s_2dWM]\u000b\u00025B\u00111,X\u0007\u00029*\u0011\u0001\fH\u0005\u0003=r\u0013qbS1gW\u0006\u001cuN\u001c;s_2dWM\u001d\u0005\u0007A\u0002\u0001\u000b\u0011\u0002.\u0002\u0017\r|g\u000e\u001e:pY2,'\u000f\t\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0003\u001dQ8.\u0016;jYN,\u0012\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003Or\tQ!\u001e;jYNL!!\u001b4\u0003\u000fi[W\u000b^5mg\"11\u000e\u0001Q\u0001\n\u0011\f\u0001B_6Vi&d7\u000f\t\u0005\b[\u0002\u0011\r\u0011\"\u0003o\u00035iW\r^1eCR\f7)Y2iKV\tq\u000e\u0005\u00022a&\u0011\u0011O\r\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\t\rM\u0004\u0001\u0015!\u0003p\u00039iW\r^1eCR\f7)Y2iK\u0002Bq!\u001e\u0001C\u0002\u0013%a/A\u0004nKR\u0014\u0018nY:\u0016\u0003]\u00042\u0001_A\u0002\u001b\u0005I(BA;{\u0015\tYH0\u0001\u0004d_6lwN\u001c\u0006\u0003\u000buT!A`@\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\t!A\u0002pe\u001eL!!K=\t\u000f\u0005\u001d\u0001\u0001)A\u0005o\u0006AQ.\u001a;sS\u000e\u001c\b\u0005C\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u0002\u000e\u0005A!M]8lKJLE-\u0006\u0002\u0002\u0010A\u00191\"!\u0005\n\u0007\u0005MABA\u0002J]RD\u0001\"a\u0006\u0001A\u0003%\u0011qB\u0001\nEJ|7.\u001a:JI\u0002B\u0011\"a\u0007\u0001\u0005\u0004%I!!\b\u0002\u0015\u0005,H\u000f[8sSj,'/\u0006\u0002\u0002 A)1\"!\t\u0002&%\u0019\u00111\u0005\u0007\u0003\r=\u0003H/[8o!\u0011\t9#!\r\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\tA!Y;uQ*\u0019\u0011q\u0006\u000f\u0002\u0011M,7-\u001e:jifLA!a\r\u0002*\tQ\u0011)\u001e;i_JL'0\u001a:\t\u0011\u0005]\u0002\u0001)A\u0005\u0003?\t1\"Y;uQ>\u0014\u0018N_3sA!I\u00111\b\u0001C\u0002\u0013%\u0011QH\u0001\u0013G2LWM\u001c;Rk>$\u0018-T1oC\u001e,'/\u0006\u0002\u0002@A\u0019\u0011'!\u0011\n\u0007\u0005\r#G\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\b\u0002CA$\u0001\u0001\u0006I!a\u0010\u0002'\rd\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d\u0011\t\u0013\u0005-\u0003A1A\u0005\n\u00055\u0013!G2mS\u0016tGOU3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJ,\"!a\u0014\u0011\u0007E\n\t&C\u0002\u0002TI\u0012\u0011d\u00117jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4fe\"A\u0011q\u000b\u0001!\u0002\u0013\ty%\u0001\u000edY&,g\u000e\u001e*fcV,7\u000f^)v_R\fW*\u00198bO\u0016\u0014\b\u0005C\u0005\u0002\\\u0001\u0011\r\u0011\"\u0003\u0002^\u0005\u0019\"/\u001a9mS\u000e\f\u0017+^8uC6\u000bg.Y4feV\u0011\u0011q\f\t\u0004c\u0005\u0005\u0014bAA2e\t9\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM\u001d\u0005\t\u0003O\u0002\u0001\u0015!\u0003\u0002`\u0005!\"/\u001a9mS\u000e\f\u0017+^8uC6\u000bg.Y4fe\u0002B\u0011\"a\u001b\u0001\u0005\u0004%I!!\u001c\u0002\rE,x\u000e^1t+\t\ty\u0007\u0005\u0003\u0002r\u0005\u0015e\u0002BA:\u0003\u0003sA!!\u001e\u0002\u00009!\u0011qOA?\u001b\t\tIHC\u0002\u0002|!\ta\u0001\u0010:p_Rt\u0014\"A\u0003\n\u0005\ra\u0012bAABe\u0005a\u0011+^8uC\u001a\u000b7\r^8ss&!\u0011qQAE\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0019\u00111\u0011\u001a\t\u0011\u00055\u0005\u0001)A\u0005\u0003_\nq!];pi\u0006\u001c\b\u0005C\u0005\u0002\u0012\u0002\u0011\r\u0011\"\u0003\u0002\u0014\u0006\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0003\u0003+\u00032!MAL\u0013\r\tIJ\r\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biND\u0001\"!(\u0001A\u0003%\u0011QS\u0001\u0012EJ|7.\u001a:U_BL7m\u0015;biN\u0004\u0003\"CAQ\u0001\t\u0007I\u0011BAR\u0003%\u0019G.^:uKJLE-\u0006\u0002\u0002&B!\u0011qUAY\u001b\t\tIK\u0003\u0003\u0002,\u00065\u0016\u0001\u00027b]\u001eT!!a,\u0002\t)\fg/Y\u0005\u0005\u0003g\u000bIK\u0001\u0004TiJLgn\u001a\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u0002&\u0006Q1\r\\;ti\u0016\u0014\u0018\n\u001a\u0011\t\u0013\u0005m\u0006A1A\u0005\n\u0005u\u0016\u0001\u0002;j[\u0016,\"!a0\u0011\u0007\u0015\f\t-C\u0002\u0002D\u001a\u0014\u0001\"T8dWRKW.\u001a\u0005\t\u0003\u000f\u0004\u0001\u0015!\u0003\u0002@\u0006)A/[7fA!9\u00111\u001a\u0001\u0005\u0002\u00055\u0017\u0001\u0003;fCJ$un\u001e8\u0015\u0005\u0005=\u0007cA\u0006\u0002R&\u0019\u00111\u001b\u0007\u0003\tUs\u0017\u000e\u001e\u0015\u0005\u0003\u0013\f9\u000e\u0005\u0003\u0002Z\u0006}WBAAn\u0015\r\tin`\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003C\fYNA\u0003BMR,'\u000fC\u0004\u0002f\u0002!\t!a:\u0002\u001f\r\u0014X-\u0019;f\u0017\u000647.Y!qSN$B!!;\u0002pB\u0019\u0011'a;\n\u0007\u00055(GA\u0005LC\u001a\\\u0017-\u00119jg\"Q\u0011\u0011_Ar!\u0003\u0005\r!a=\u00025%tG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\u0011\t\u0005U\u00181`\u0007\u0003\u0003oT1!!?\u001d\u0003\r\t\u0007/[\u0005\u0005\u0003{\f9P\u0001\u0006Ba&4VM]:j_:DqA!\u0001\u0001\t\u0003\ti-\u00014tQ>,H\u000e\u001a+ie><XK\\:vaB|'\u000f^3e-\u0016\u00148/[8o\u000bb\u001cW\r\u001d;j_:|e\u000eS1oI2,\u0017\t\u001a3PM\u001a\u001cX\r\u001e+p)bt'+Z9vKN$x\u000b[3o\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c(piN+\b\u000f]8si\u0016$\u0007\u0006CA\u0000\u0005\u000b\u0011YA!\u0004\u0011\t\u0005e'qA\u0005\u0005\u0005\u0013\tYN\u0001\u0003UKN$\u0018\u0001C3ya\u0016\u001cG/\u001a3$\u0005\t=\u0001\u0003\u0002B\t\u0005/i!Aa\u0005\u000b\u0007\tU!0\u0001\u0004feJ|'o]\u0005\u0005\u00053\u0011\u0019BA\u000eV]N,\b\u000f]8si\u0016$g+\u001a:tS>tW\t_2faRLwN\u001c\u0005\b\u0005;\u0001A\u0011AAg\u0003)\u001c\bn\\;mIRC'o\\<V]N,\b\u000f]8si\u0016$g+\u001a:tS>tW\t_2faRLwN\\(o\u0011\u0006tG\r\\3BI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+p)bt'+Z9vKN$x\u000b[3o\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c(piN+\b\u000f]8si\u0016$\u0007\u0006\u0003B\u000e\u0005\u000b\u0011YA!\u0004\t\u000f\t\r\u0002\u0001\"\u0001\u0002N\u000697\u000f[8vY\u0012$\u0006N]8x+:\u001cX\u000f\u001d9peR,GMV3sg&|g.\u0012=dKB$\u0018n\u001c8P]\"\u000bg\u000e\u001a7f)btwJ\u001a4tKR\u001cu.\\7jiJ+\u0017/^3ti^CWM\\%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dgj\u001c;TkB\u0004xN\u001d;fI\"B!\u0011\u0005B\u0003\u0005\u0017\u0011i\u0001C\u0004\u0003*\u0001!\t!!4\u0002=NDw.\u001e7e)\"\u0014xn^+ogV\u0004\bo\u001c:uK\u00124VM]:j_:,\u0005pY3qi&|gn\u00148IC:$G.Z#oIRChNU3rk\u0016\u001cHo\u00165f]&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0005\u0003(\t\u0015!1\u0002B\u0007\u0011\u001d\u0011y\u0003\u0001C\u0001\u0003\u001b\fqm\u001d5pk2$G\u000b\u001b:poVs7/\u001e9q_J$X\r\u001a,feNLwN\\#yG\u0016\u0004H/[8o\u001f:D\u0015M\u001c3mK^\u0013\u0018\u000e^3Uq:l\u0015M]6feN\u0014V-];fgR<\u0006.\u001a8J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|GNT8u'V\u0004\bo\u001c:uK\u0012D\u0003B!\f\u0003\u0006\t-!Q\u0002\u0005\b\u0005k\u0001A\u0011AAg\u0003u\u001b\bn\\;mIJ+7\u000f]8oI^KG\u000f[+ogV\u0004\bo\u001c:uK\u00124uN]'fgN\fw-\u001a$pe6\fGo\u00148IC:$G.Z,sSR,G\u000b\u001f8NCJ\\WM]:XQ\u0016tW*Y4jG2{w/\u001a:UQ\u0006t'+Z9vSJ,G\r\u000b\u0003\u00034\t\u0015\u0001b\u0002B\u001e\u0001\u0011\u0005\u0011QZ\u00016g\"|W\u000f\u001c3SKN\u0004xN\u001c3XSRDWK\\6o_^tGk\u001c9jG^CWM\u001c)beRLG/[8o\u0013Ntu\u000e\u001e%pgR,G\r\u000b\u0003\u0003:\t\u0015\u0001b\u0002B!\u0001\u0011\u0005\u0011QZ\u0001Tg\"|W\u000f\u001c3SKN\u0004xN\u001c3XSRDWK\\:vaB|'\u000f^3e\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;G_J\u0014\u0015\r\u001a)beRLG/[8o\u0003:$gj\\#se>\u00148OR8s\u000f>|G\rU1si&$\u0018n\u001c8)\t\t}\"Q\u0001\u0005\b\u0005\u000f\u0002A\u0011AAg\u0003I\u001b\bn\\;mIJ+7\u000f]8oI^KG\u000f[+oW:|wO\u001c+pa&\u001cwJ\u001d)beRLG/[8o\r>\u0014()\u00193QCJ$\u0018\u000e^5p]\u0006sGMT8FeJ|'o\u001d$pe\u001e{w\u000e\u001a)beRLG/[8oQ\u0011\u0011)E!\u0002\t\u000f\t5\u0003\u0001\"\u0001\u0002N\u0006I4\u000f[8vY\u0012\f\u0005\u000f]3oIR{Gj\\4P]^\u0013\u0018\u000e^3Uq:l\u0015M]6feN<\u0006.\u001a8D_J\u0014Xm\u0019;NC\u001eL7MV3sg&|g\u000e\u000b\u0003\u0003L\t\u0015\u0001b\u0002B*\u0001\u0011\u0005\u0011QZ\u0001<i\u0016\u001cHOU3bIVs7m\\7nSR$X\rZ\"p]N,X.\u001a:MSN$xJ\u001a4tKRd\u0015.\\5uK\u0012\fE\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007\u0006\u0002B)\u0005\u000bAqA!\u0017\u0001\t\u0003\ti-\u0001\u001fuKN$(+Z1e\u0007>lW.\u001b;uK\u0012\u001cuN\\:v[\u0016\u0014H*[:u\u001f\u001a47/\u001a;MS6LG/\u001a3Bi2\u000b7\u000f^*uC\ndWm\u00144gg\u0016$\b\u0006\u0002B,\u0005\u000bAqAa\u0018\u0001\t\u0013\u0011\t'A\u000euKN$8i\u001c8tk6,'\u000fT5ti>3gm]3u\u0019&l\u0017\u000e\u001e\u000b\u0005\u0003\u001f\u0014\u0019\u0007\u0003\u0005\u0003f\tu\u0003\u0019\u0001B4\u00039I7o\u001c7bi&|g\u000eT3wK2\u0004BA!\u001b\u0003p5\u0011!1\u000e\u0006\u0004\u0005[R\u0018\u0001\u0003:fcV,7\u000f^:\n\t\tE$1\u000e\u0002\u000f\u0013N|G.\u0019;j_:dUM^3m\u0011\u001d\u0011)\b\u0001C\u0001\u0003\u001b\fa\t^3tiJ+\u0017\rZ+oG>lW.\u001b;uK\u0012\u001cuN\\:v[\u0016\u0014H*[:u\u001f\u001a47/\u001a;FCJd\u0017.Z:u\u001f\u001a47/\u001a;FcV\fGn\u001d%jO\"<\u0016\r^3s[\u0006\u00148\u000e\u000b\u0003\u0003t\t\u0015\u0001b\u0002B>\u0001\u0011\u0005\u0011QZ\u0001Hi\u0016\u001cHOU3bI\u000e{W.\\5ui\u0016$7i\u001c8tk6,'\u000fT5ti>3gm]3u\u000b\u0006\u0014H.[3ti>3gm]3u\u000bF,\u0018\r\\:MCN$8\u000b^1cY\u0016|eMZ:fi\"\"!\u0011\u0010B\u0003\u0011\u001d\u0011\t\t\u0001C\u0005\u0005\u0007\u000bq\u0006^3ti\u000e{gn];nKJd\u0015n\u001d;PM\u001a\u001cX\r^#be2LWm\u001d;PM\u001a\u001cX\r^#rk\u0006d7\u000fT5nSR$B!a4\u0003\u0006\"A!Q\rB@\u0001\u0004\u00119\u0007C\u0004\u0003\n\u0002!\t!!4\u0002WQ,7\u000f\u001e*fC\u0012,fnY8n[&$H/\u001a3D_:\u001cX/\\3s\u0019&\u001cHo\u00144gg\u0016$H*\u0019;fgRDCAa\"\u0003\u0006!9!q\u0012\u0001\u0005\u0002\u00055\u0017!\u000b;fgR\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\u000e{gn];nKJd\u0015n\u001d;PM\u001a\u001cX\r\u001e'bi\u0016\u001cH\u000f\u000b\u0003\u0003\u000e\n\u0015\u0001b\u0002BK\u0001\u0011%!qS\u0001\u001di\u0016\u001cHoQ8ogVlWM\u001d'jgR|eMZ:fi2\u000bG/Z:u)\u0011\tyM!'\t\u0011\t\u0015$1\u0013a\u0001\u0005OBqA!(\u0001\t\u0013\u0011y*\u0001\u000fde\u0016\fG/Z,sSR,G\u000b\u001f8NCJ\\WM]:SKF,Xm\u001d;\u0015\t\t\u0005&1\u0017\t\b\u0017\t\r&q\u0015BW\u0013\r\u0011)\u000b\u0004\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\t%$\u0011V\u0005\u0005\u0005W\u0013YG\u0001\fXe&$X\r\u0016=o\u001b\u0006\u00148.\u001a:t%\u0016\fX/Z:u!\r)#qV\u0005\u0004\u0005cS#a\u0002*fcV,7\u000f\u001e\u0005\t\u0005k\u0013Y\n1\u0001\u00038\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\r\te&q\u0018Bb\u001b\t\u0011YL\u0003\u0003\u0003>\u00065\u0016\u0001B;uS2LAA!1\u0003<\n!A*[:u!\u0011\u0011)Ma2\u000e\u0003iL1A!3{\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DqA!4\u0001\t\u0013\u0011y-\u0001\u0007ck&dGMU3rk\u0016\u001cH/\u0006\u0003\u0003R\neG\u0003\u0002Bj\u0005W\u0004ra\u0003BR\u0005+\u0014i\u000b\u0005\u0003\u0003X\neG\u0002\u0001\u0003\t\u00057\u0014YM1\u0001\u0003^\n\tA+\u0005\u0003\u0003`\n\u0015\bcA\u0006\u0003b&\u0019!1\u001d\u0007\u0003\u000f9{G\u000f[5oOB!!\u0011\u000eBt\u0013\u0011\u0011IOa\u001b\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRD\u0001B!<\u0003L\u0002\u0007!q^\u0001\bEVLG\u000eZ3s!\u0019\u0011\tPa>\u0003V:!!\u0011\u000eBz\u0013\u0011\u0011)Pa\u001b\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRLAA!?\u0003|\n9!)^5mI\u0016\u0014(\u0002\u0002B{\u0005WBqAa@\u0001\t\u0013\u0019\t!\u0001\u0007sK\u0006$'+Z:q_:\u001cX\r\u0006\u0005\u0004\u0004\r%1qCB\u000e!\u0011\u0011Ig!\u0002\n\t\r\u001d!1\u000e\u0002\u0011\u0003\n\u001cHO]1diJ+7\u000f]8og\u0016D\u0001\"!?\u0003~\u0002\u000711\u0002\t\u0005\u0007\u001b\u0019\u0019\"\u0004\u0002\u0004\u0010)\u00191\u0011\u0003>\u0002\u0011A\u0014x\u000e^8d_2LAa!\u0006\u0004\u0010\t9\u0011\t]5LKf\u001c\b\u0002CB\r\u0005{\u0004\rA!:\u0002\u000fI,\u0017/^3ti\"A1Q\u0004B\u007f\u0001\u0004\u0019y\"\u0001\tdCB$XO]3e%\u0016\u001c\bo\u001c8tKB11\u0011EB\u0014\u0007Wi!aa\t\u000b\u0007\r\u0015r0\u0001\u0005fCNLXn\\2l\u0013\u0011\u0019Ica\t\u0003\u000f\r\u000b\u0007\u000f^;sKB\u0019Qe!\f\n\u0007\r=\"F\u0001\u0005SKN\u0004xN\\:f\u0011\u001d\u0019\u0019\u0004\u0001C\u0005\u0007k\tq$\u001a=qK\u000e$H\u000b\u001b:piRdWmQ1mY\n\f7m[!oI&sgo\\6f)\u0011\tyma\u000e\t\u0011\re2\u0011\u0007a\u0001\u0007w\t\u0001dY1qiV\u0014X\r\u001a+ie>$H\u000f\\3DC2d'-Y2l!\u0019\u0019\tca\n\u0004>A91ba\u0010\u0002\u0010\u0005=\u0017bAB!\u0019\tIa)\u001e8di&|g.\r\u0005\n\u0007\u000b\u0002\u0011\u0013!C\u0001\u0007\u000f\n\u0011d\u0019:fCR,7*\u00194lC\u0006\u0003\u0018n\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u00111\u0011\n\u0016\u0005\u0003g\u001cYe\u000b\u0002\u0004NA!1qJB-\u001b\t\u0019\tF\u0003\u0003\u0004T\rU\u0013!C;oG\",7m[3e\u0015\r\u00199\u0006D\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB.\u0007#\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class KafkaApisTest {
    private final RequestChannel requestChannel = (RequestChannel)EasyMock.createNiceMock(RequestChannel.class);
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)EasyMock.createNiceMock(GroupCoordinator.class);
    private final AdminManager adminManager = (AdminManager)EasyMock.createNiceMock(AdminManager.class);
    private final TransactionCoordinator txnCoordinator = (TransactionCoordinator)EasyMock.createNiceMock(TransactionCoordinator.class);
    private final KafkaController controller = (KafkaController)EasyMock.createNiceMock(KafkaController.class);
    private final ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
    private final MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private final Option<Authorizer> authorizer = None$.MODULE$;
    private final ClientQuotaManager clientQuotaManager = (ClientQuotaManager)EasyMock.createNiceMock(ClientQuotaManager.class);
    private final ClientRequestQuotaManager clientRequestQuotaManager = (ClientRequestQuotaManager)EasyMock.createNiceMock(ClientRequestQuotaManager.class);
    private final ReplicationQuotaManager replicaQuotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
    private final QuotaFactory.QuotaManagers quotas = new QuotaFactory.QuotaManagers(this.clientQuotaManager(), this.clientQuotaManager(), this.clientRequestQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager());
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final String clusterId;
    private final MockTime time = new MockTime();

    private RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private AdminManager adminManager() {
        return this.adminManager;
    }

    private TransactionCoordinator txnCoordinator() {
        return this.txnCoordinator;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    private ClientQuotaManager clientQuotaManager() {
        return this.clientQuotaManager;
    }

    private ClientRequestQuotaManager clientRequestQuotaManager() {
        return this.clientRequestQuotaManager;
    }

    private ReplicationQuotaManager replicaQuotaManager() {
        return this.replicaQuotaManager;
    }

    private QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    private String clusterId() {
        return this.clusterId;
    }

    private MockTime time() {
        return this.time;
    }

    @After
    public void tearDown() {
        this.quotas().shutdown();
        this.metrics().close();
    }

    public KafkaApis createKafkaApis(ApiVersion interBrokerProtocolVersion) {
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        properties.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), interBrokerProtocolVersion.toString());
        properties.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), interBrokerProtocolVersion.toString());
        return new KafkaApis(this.requestChannel(), this.replicaManager(), this.adminManager(), this.groupCoordinator(), this.txnCoordinator(), this.controller(), this.zkUtils(), this.brokerId(), new KafkaConfig((java.util.Map)properties), this.metadataCache(), this.metrics(), this.authorizer(), this.quotas(), this.brokerTopicStats(), this.clusterId(), (Time)this.time());
    }

    public ApiVersion createKafkaApis$default$1() {
        return ApiVersion$.MODULE$.latestVersion();
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleAddOffsetToTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddOffsetsToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleAddPartitionsToTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddPartitionToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleTxnOffsetCommitRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddPartitionToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleEndTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleEndTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleWriteTxnMarkersRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleWriteTxnMarkersRequest(null);
    }

    @Test
    public void shouldRespondWithUnsupportedForMessageFormatOnHandleWriteTxnMarkersWhenMagicLowerThanRequired() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{topicPartition}));
        if (tuple2 != null) {
            Tuple2 tuple22;
            WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
            RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
            WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
            RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
            java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT)}))).asJava();
            Capture capturedResponse = EasyMock.newCapture();
            EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
            this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
            EasyMock.expect((Object)BoxedUnit.UNIT);
            EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
            this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
            WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
            Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void shouldRespondWithUnknownTopicWhenPartitionIsNotHosted() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{topicPartition}));
        if (tuple2 != null) {
            Tuple2 tuple22;
            WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
            RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
            WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
            RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
            java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))).asJava();
            Capture capturedResponse = EasyMock.newCapture();
            EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)None$.MODULE$);
            this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
            EasyMock.expect((Object)BoxedUnit.UNIT);
            EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
            this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
            WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
            Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void shouldRespondWithUnsupportedMessageFormatForBadPartitionAndNoErrorsForGoodPartition() {
        TopicPartition tp1 = new TopicPartition("t", 0);
        TopicPartition tp2 = new TopicPartition("t1", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{tp1, tp2}));
        if (tuple2 != null) {
            Tuple2 tuple22;
            WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
            RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
            WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
            RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
            java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Errors.NONE)}))).asJava();
            Capture capturedResponse = EasyMock.newCapture();
            Capture responseCallback = EasyMock.newCapture();
            EasyMock.expect((Object)this.replicaManager().getMagic(tp1)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
            EasyMock.expect((Object)this.replicaManager().getMagic(tp2)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
            this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
            EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, tp2, responseCallback){
                private final TopicPartition tp2$1;
                private final Capture responseCallback$1;

                public void answer() {
                    ((Function1)this.responseCallback$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2$1), (Object)new ProduceResponse.PartitionResponse(Errors.NONE))})));
                }
                {
                    this.tp2$1 = tp2$1;
                    this.responseCallback$1 = responseCallback$1;
                }
            });
            this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
            EasyMock.expect((Object)BoxedUnit.UNIT);
            EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
            this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
            WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
            Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
            EasyMock.verify((Object[])new Object[]{this.replicaManager()});
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void shouldRespondWithUnknownTopicOrPartitionForBadPartitionAndNoErrorsForGoodPartition() {
        TopicPartition tp1 = new TopicPartition("t", 0);
        TopicPartition tp2 = new TopicPartition("t1", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{tp1, tp2}));
        if (tuple2 != null) {
            Tuple2 tuple22;
            WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
            RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
            WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
            RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
            java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Errors.NONE)}))).asJava();
            Capture capturedResponse = EasyMock.newCapture();
            Capture responseCallback = EasyMock.newCapture();
            EasyMock.expect((Object)this.replicaManager().getMagic(tp1)).andReturn((Object)None$.MODULE$);
            EasyMock.expect((Object)this.replicaManager().getMagic(tp2)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
            this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
            EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, tp2, responseCallback){
                private final TopicPartition tp2$2;
                private final Capture responseCallback$2;

                public void answer() {
                    ((Function1)this.responseCallback$2.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2$2), (Object)new ProduceResponse.PartitionResponse(Errors.NONE))})));
                }
                {
                    this.tp2$2 = tp2$2;
                    this.responseCallback$2 = responseCallback$2;
                }
            });
            this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
            EasyMock.expect((Object)BoxedUnit.UNIT);
            EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
            this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
            WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
            Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
            EasyMock.verify((Object[])new Object[]{this.replicaManager()});
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void shouldAppendToLogOnWriteTxnMarkersWhenCorrectMagicVersion() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        RequestChannel.Request request = (RequestChannel.Request)this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{topicPartition}))._2();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request);
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testReadUncommittedConsumerListOffsetLimitedAtHighWatermark() {
        this.testConsumerListOffsetLimit(IsolationLevel.READ_UNCOMMITTED);
    }

    @Test
    public void testReadCommittedConsumerListOffsetLimitedAtLastStableOffset() {
        this.testConsumerListOffsetLimit(IsolationLevel.READ_COMMITTED);
    }

    private void testConsumerListOffsetLimit(IsolationLevel isolationLevel) {
        TopicPartition tp = new TopicPartition("foo", 0);
        Long timestamp = Predef$.MODULE$.long2Long(this.time().milliseconds());
        long limitOffset = 15L;
        Capture capturedResponse = EasyMock.newCapture();
        Capture capturedThrottleCallback = EasyMock.newCapture();
        Replica replica = (Replica)EasyMock.mock(Replica.class);
        Log log2 = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLeaderReplicaIfLocal(tp)).andReturn((Object)replica);
        IsolationLevel isolationLevel2 = isolationLevel;
        IsolationLevel isolationLevel3 = IsolationLevel.READ_UNCOMMITTED;
        IExpectationSetters iExpectationSetters = !(isolationLevel2 != null ? !isolationLevel2.equals(isolationLevel3) : isolationLevel3 != null) ? EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata(limitOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())) : EasyMock.expect((Object)replica.lastStableOffset()).andReturn((Object)new LogOffsetMetadata(limitOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        EasyMock.expect((Object)this.replicaManager().getLog(tp)).andReturn((Object)new Some((Object)log2));
        EasyMock.expect((Object)log2.fetchOffsetsByTimestamp(Predef$.MODULE$.Long2long(timestamp))).andReturn((Object)new Some((Object)new TimestampOffset(Predef$.MODULE$.Long2long(timestamp), limitOffset)));
        this.expectThrottleCallbackAndInvoke((Capture<Function1<Object, BoxedUnit>>)capturedThrottleCallback);
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel(), replica, log2});
        ListOffsetRequest.Builder builder = ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)isolationLevel).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)timestamp)}))).asJava());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)builder);
        if (tuple2 != null) {
            Tuple2 tuple22;
            ListOffsetRequest listOffsetRequest = (ListOffsetRequest)tuple2._1();
            RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)listOffsetRequest, (Object)request);
            ListOffsetRequest listOffsetRequest2 = (ListOffsetRequest)tuple23._1();
            RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
            this.createKafkaApis(this.createKafkaApis$default$1()).handleListOffsetRequest(request2);
            ListOffsetResponse response = (ListOffsetResponse)this.readResponse(ApiKeys.LIST_OFFSETS, (AbstractRequest)listOffsetRequest2, (Capture<RequestChannel.Response>)capturedResponse);
            Assert.assertTrue((boolean)response.responseData().containsKey(tp));
            ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(tp);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.offset);
            Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.timestamp);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testReadUncommittedConsumerListOffsetEarliestOffsetEqualsHighWatermark() {
        this.testConsumerListOffsetEarliestOffsetEqualsLimit(IsolationLevel.READ_UNCOMMITTED);
    }

    @Test
    public void testReadCommittedConsumerListOffsetEarliestOffsetEqualsLastStableOffset() {
        this.testConsumerListOffsetEarliestOffsetEqualsLimit(IsolationLevel.READ_COMMITTED);
    }

    private void testConsumerListOffsetEarliestOffsetEqualsLimit(IsolationLevel isolationLevel) {
        TopicPartition tp = new TopicPartition("foo", 0);
        long limitOffset = 15L;
        Capture capturedResponse = EasyMock.newCapture();
        Capture capturedThrottleCallback = EasyMock.newCapture();
        Replica replica = (Replica)EasyMock.mock(Replica.class);
        Log log2 = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLeaderReplicaIfLocal(tp)).andReturn((Object)replica);
        IsolationLevel isolationLevel2 = isolationLevel;
        IsolationLevel isolationLevel3 = IsolationLevel.READ_UNCOMMITTED;
        IExpectationSetters iExpectationSetters = !(isolationLevel2 != null ? !isolationLevel2.equals(isolationLevel3) : isolationLevel3 != null) ? EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata(limitOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())) : EasyMock.expect((Object)replica.lastStableOffset()).andReturn((Object)new LogOffsetMetadata(limitOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        EasyMock.expect((Object)this.replicaManager().getLog(tp)).andReturn((Object)new Some((Object)log2));
        EasyMock.expect((Object)log2.fetchOffsetsByTimestamp(-2L)).andReturn((Object)new Some((Object)new TimestampOffset(-1L, limitOffset)));
        this.expectThrottleCallbackAndInvoke((Capture<Function1<Object, BoxedUnit>>)capturedThrottleCallback);
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel(), replica, log2});
        ListOffsetRequest.Builder builder = ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)isolationLevel).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Predef$.MODULE$.long2Long(-2L))}))).asJava());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)builder);
        if (tuple2 != null) {
            Tuple2 tuple22;
            ListOffsetRequest listOffsetRequest = (ListOffsetRequest)tuple2._1();
            RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)listOffsetRequest, (Object)request);
            ListOffsetRequest listOffsetRequest2 = (ListOffsetRequest)tuple23._1();
            RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
            this.createKafkaApis(this.createKafkaApis$default$1()).handleListOffsetRequest(request2);
            ListOffsetResponse response = (ListOffsetResponse)this.readResponse(ApiKeys.LIST_OFFSETS, (AbstractRequest)listOffsetRequest2, (Capture<RequestChannel.Response>)capturedResponse);
            Assert.assertTrue((boolean)response.responseData().containsKey(tp));
            ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(tp);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)limitOffset), (Object)partitionData.offset);
            Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.timestamp);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testReadUncommittedConsumerListOffsetLatest() {
        this.testConsumerListOffsetLatest(IsolationLevel.READ_UNCOMMITTED);
    }

    @Test
    public void testReadCommittedConsumerListOffsetLatest() {
        this.testConsumerListOffsetLatest(IsolationLevel.READ_COMMITTED);
    }

    private void testConsumerListOffsetLatest(IsolationLevel isolationLevel) {
        TopicPartition tp = new TopicPartition("foo", 0);
        long latestOffset = 15L;
        Capture capturedResponse = EasyMock.newCapture();
        Capture capturedThrottleCallback = EasyMock.newCapture();
        Replica replica = (Replica)EasyMock.mock(Replica.class);
        Log log2 = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLeaderReplicaIfLocal(tp)).andReturn((Object)replica);
        IsolationLevel isolationLevel2 = isolationLevel;
        IsolationLevel isolationLevel3 = IsolationLevel.READ_UNCOMMITTED;
        IExpectationSetters iExpectationSetters = !(isolationLevel2 != null ? !isolationLevel2.equals(isolationLevel3) : isolationLevel3 != null) ? EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata(latestOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())) : EasyMock.expect((Object)replica.lastStableOffset()).andReturn((Object)new LogOffsetMetadata(latestOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.expectThrottleCallbackAndInvoke((Capture<Function1<Object, BoxedUnit>>)capturedThrottleCallback);
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel(), replica, log2});
        ListOffsetRequest.Builder builder = ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)isolationLevel).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Predef$.MODULE$.long2Long(-1L))}))).asJava());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)builder);
        if (tuple2 != null) {
            Tuple2 tuple22;
            ListOffsetRequest listOffsetRequest = (ListOffsetRequest)tuple2._1();
            RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)listOffsetRequest, (Object)request);
            ListOffsetRequest listOffsetRequest2 = (ListOffsetRequest)tuple23._1();
            RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
            this.createKafkaApis(this.createKafkaApis$default$1()).handleListOffsetRequest(request2);
            ListOffsetResponse response = (ListOffsetResponse)this.readResponse(ApiKeys.LIST_OFFSETS, (AbstractRequest)listOffsetRequest2, (Capture<RequestChannel.Response>)capturedResponse);
            Assert.assertTrue((boolean)response.responseData().containsKey(tp));
            ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(tp);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)latestOffset), (Object)partitionData.offset);
            Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.timestamp);
            return;
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> createWriteTxnMarkersRequest(List<TopicPartition> partitions) {
        WriteTxnMarkersRequest.Builder requestBuilder = new WriteTxnMarkersRequest.Builder(Utils.mkList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(1L, (short)1, 0, TransactionResult.COMMIT, partitions)}));
        return this.buildRequest((AbstractRequest.Builder)requestBuilder);
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, new ListenerName(""), SecurityProtocol.PLAINTEXT);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, this.requestChannelMetrics()));
    }

    private AbstractResponse readResponse(ApiKeys api, AbstractRequest request, Capture<RequestChannel.Response> capturedResponse) {
        Send send2 = (Send)((RequestChannel.Response)capturedResponse.getValue()).responseSend().get();
        ByteBufferChannel channel = new ByteBufferChannel(send2.size());
        send2.writeTo((GatheringByteChannel)channel);
        channel.close();
        channel.buffer().getInt();
        ResponseHeader.parse((ByteBuffer)channel.buffer());
        Struct struct = api.responseSchema(request.version()).read(channel.buffer());
        return AbstractResponse.parseResponse((ApiKeys)api, (Struct)struct);
    }

    private void expectThrottleCallbackAndInvoke(Capture<Function1<Object, BoxedUnit>> capturedThrottleCallback) {
        this.clientRequestQuotaManager().maybeRecordAndThrottle((RequestChannel.Request)EasyMock.anyObject(), (Function1)EasyMock.capture(capturedThrottleCallback));
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, capturedThrottleCallback){
            private final Capture capturedThrottleCallback$1;

            public void answer() {
                Function1 callback = (Function1)this.capturedThrottleCallback$1.getValue();
                callback.apply$mcVI$sp(0);
            }
            {
                this.capturedThrottleCallback$1 = capturedThrottleCallback$1;
            }
        });
    }

    public KafkaApisTest() {
        this.brokerId = 1;
        this.clusterId = "clusterId";
    }
}

