/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import com.typesafe.scalalogging.Logger;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.server.KafkaServer;
import kafka.server.KafkaServerStartable;
import kafka.server.KafkaServerStartable$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.Java;
import org.apache.kafka.common.utils.LoggingSignalHandler;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class Kafka$
implements Logging {
    public static final Kafka$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new Kafka$();
    }

    private Logger logger$lzycompute() {
        Kafka$ kafka$ = this;
        synchronized (kafka$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Properties getPropsFromArgs(String[] args) {
        OptionParser optionParser = new OptionParser(false);
        ArgumentAcceptingOptionSpec overrideOpt = optionParser.accepts("override", "Optional property that should override values set in server.properties file").withRequiredArg().ofType(String.class);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(optionParser, new StringOps(Predef$.MODULE$.augmentString("USAGE: java [options] %s server.properties [--override property=value]*")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KafkaServer.class.getSimpleName()})));
        }
        Properties props = Utils.loadProps((String)args[0]);
        if (args.length > 1) {
            OptionSet options = optionParser.parse((String[])Predef$.MODULE$.refArrayOps((Object[])args).slice(1, args.length));
            if (options.nonOptionArguments().size() > 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(optionParser, new StringBuilder().append((Object)"Found non argument parameters: ").append((Object)Predef$.MODULE$.refArrayOps(options.nonOptionArguments().toArray()).mkString(",")).toString());
            }
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(options.valuesOf((OptionSpec)overrideOpt)).asScala()), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2()));
        }
        return props;
    }

    public void main(String[] args) {
        try {
            Properties serverProps = this.getPropsFromArgs(args);
            KafkaServerStartable kafkaServerStartable = KafkaServerStartable$.MODULE$.fromProps(serverProps);
            try {
                if (!OperatingSystem.IS_WINDOWS && !Java.isIbmJdk()) {
                    new LoggingSignalHandler().register();
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                this.warn((Function0<String>)new Serializable(reflectiveOperationException){
                    public static final long serialVersionUID = 0L;
                    private final ReflectiveOperationException e$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Failed to register optional signal handler that logs a message when the process is terminated ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"by a signal. Reason for registration failure is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1}))).toString();
                    }
                    {
                        this.e$1 = e$1;
                    }
                }, (Function0<Throwable>)new Serializable(reflectiveOperationException){
                    public static final long serialVersionUID = 0L;
                    private final ReflectiveOperationException e$1;

                    public final ReflectiveOperationException apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
            }
            Runtime.getRuntime().addShutdownHook(new Thread(kafkaServerStartable){
                private final KafkaServerStartable kafkaServerStartable$1;

                public void run() {
                    this.kafkaServerStartable$1.shutdown();
                }
                {
                    this.kafkaServerStartable$1 = kafkaServerStartable$1;
                    super("kafka-shutdown-hook");
                }
            });
            kafkaServerStartable.startup();
            kafkaServerStartable.awaitShutdown();
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exiting Kafka due to fatal exception";
                }
            }, (Function0<Throwable>)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
    }

    private Kafka$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

