/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.util.Collection;
import java.util.Properties;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignPartitionsCommand$Throttle$;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentInProgress$;
import kafka.admin.ReassignmentStatus;
import kafka.cluster.Broker;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class ReassignPartitionsCommand$
implements Logging {
    public static final ReassignPartitionsCommand$ MODULE$;
    private final ReassignPartitionsCommand.Throttle NoThrottle;
    private final String AnyLogDir;
    private final int EarliestVersion;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommand$ reassignPartitionsCommand$ = this;
        synchronized (reassignPartitionsCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ReassignPartitionsCommand.Throttle NoThrottle() {
        return this.NoThrottle;
    }

    public String AnyLogDir() {
        return this.AnyLogDir;
    }

    public int EarliestVersion() {
        return this.EarliestVersion;
    }

    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = this.validateAndParseArgs(args);
        String zkConnect = (String)opts.options().valueOf(opts.zkConnectOpt());
        Time time = Time.SYSTEM;
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnect, JaasUtils.isZkSecurityEnabled(), 30000, 30000, Integer.MAX_VALUE, time, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());
        Option<AdminClient> adminClientOpt = this.createAdminClient(opts);
        try {
            try {
                if (opts.options().has((OptionSpec)opts.verifyOpt())) {
                    this.verifyAssignment(zkClient, adminClientOpt, opts);
                } else if (opts.options().has((OptionSpec)opts.generateOpt())) {
                    this.generateAssignment(zkClient, opts);
                } else if (opts.options().has((OptionSpec)opts.executeOpt())) {
                    this.executeAssignment(zkClient, adminClientOpt, opts);
                }
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Partitions reassignment failed due to ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)throwable));
            }
        }
        finally {
            zkClient.close();
        }
    }

    private Option<AdminClient> createAdminClient(ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        None$ none$;
        if (opts.options().has(opts.bootstrapServerOpt())) {
            Properties props = new Properties();
            props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
            props.put("client.id", "reassign-partitions-tool");
            none$ = new Some((Object)AdminClient.create((Properties)props));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void verifyAssignment(KafkaZkClient zkClient, Option<AdminClient> adminClientOpt, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String jsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String jsonString = Utils.readFileAsString((String)jsonFile);
        this.verifyAssignment(zkClient, adminClientOpt, jsonString);
    }

    public void verifyAssignment(KafkaZkClient zkClient, Option<AdminClient> adminClientOpt, String jsonString) {
        Predef$.MODULE$.println((Object)"Status of partition reassignment: ");
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq partitionsToBeReassigned = (Seq)tuple2._1();
            Map replicaAssignment = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionsToBeReassigned, (Object)replicaAssignment);
            Seq partitionsToBeReassigned2 = (Seq)tuple23._1();
            Map replicaAssignment2 = (Map)tuple23._2();
            Map<TopicPartition, ReassignmentStatus> reassignedPartitionsStatus = this.checkIfPartitionReassignmentSucceeded(zkClient, (Map<TopicPartition, Seq<Object>>)partitionsToBeReassigned2.toMap(Predef$.MODULE$.$conforms()));
            Map<TopicPartitionReplica, ReassignmentStatus> replicasReassignmentStatus = this.checkIfReplicaReassignmentSucceeded(adminClientOpt, (Map<TopicPartitionReplica, String>)replicaAssignment2);
            reassignedPartitionsStatus.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<TopicPartition, ReassignmentStatus> x0$1) {
                    Tuple2<TopicPartition, ReassignmentStatus> tuple2;
                    block2: {
                        ReassignmentStatus reassignmentStatus;
                        block6: {
                            block4: {
                                TopicPartition topicPartition;
                                block5: {
                                    block3: {
                                        tuple2 = x0$1;
                                        if (tuple2 == null) break block2;
                                        topicPartition = (TopicPartition)tuple2._1();
                                        ReassignmentStatus status = (ReassignmentStatus)tuple2._2();
                                        reassignmentStatus = status;
                                        if (!ReassignmentCompleted$.MODULE$.equals(reassignmentStatus)) break block3;
                                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s completed successfully")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    if (!ReassignmentFailed$.MODULE$.equals(reassignmentStatus)) break block5;
                                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block4;
                                }
                                if (!ReassignmentInProgress$.MODULE$.equals(reassignmentStatus)) break block6;
                                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s is still in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)reassignmentStatus);
                    }
                    throw new MatchError(tuple2);
                }
            });
            replicasReassignmentStatus.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<TopicPartitionReplica, ReassignmentStatus> x0$2) {
                    Tuple2<TopicPartitionReplica, ReassignmentStatus> tuple2;
                    block2: {
                        ReassignmentStatus reassignmentStatus;
                        block6: {
                            block4: {
                                TopicPartitionReplica replica;
                                block5: {
                                    block3: {
                                        tuple2 = x0$2;
                                        if (tuple2 == null) break block2;
                                        replica = (TopicPartitionReplica)tuple2._1();
                                        ReassignmentStatus status = (ReassignmentStatus)tuple2._2();
                                        reassignmentStatus = status;
                                        if (!ReassignmentCompleted$.MODULE$.equals(reassignmentStatus)) break block3;
                                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of replica %s completed successfully")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica})));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    if (!ReassignmentFailed$.MODULE$.equals(reassignmentStatus)) break block5;
                                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of replica %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block4;
                                }
                                if (!ReassignmentInProgress$.MODULE$.equals(reassignmentStatus)) break block6;
                                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of replica %s is still in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)reassignmentStatus);
                    }
                    throw new MatchError(tuple2);
                }
            });
            this.removeThrottle(zkClient, reassignedPartitionsStatus, replicasReassignmentStatus, adminZkClient);
            return;
        }
        throw new MatchError(tuple2);
    }

    public void removeThrottle(KafkaZkClient zkClient, Map<TopicPartition, ReassignmentStatus> reassignedPartitionsStatus, Map<TopicPartitionReplica, ReassignmentStatus> replicasReassignmentStatus, AdminZkClient adminZkClient) {
        if (reassignedPartitionsStatus.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, ReassignmentStatus> x0$3) {
                Tuple2<TopicPartition, ReassignmentStatus> tuple2 = x0$3;
                if (tuple2 != null) {
                    ReassignmentStatus status;
                    ReassignmentStatus reassignmentStatus = status = (ReassignmentStatus)tuple2._2();
                    ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                    boolean bl = !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }) && replicasReassignmentStatus.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartitionReplica, ReassignmentStatus> x0$4) {
                Tuple2<TopicPartitionReplica, ReassignmentStatus> tuple2 = x0$4;
                if (tuple2 != null) {
                    ReassignmentStatus status;
                    ReassignmentStatus reassignmentStatus = status = (ReassignmentStatus)tuple2._2();
                    ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                    boolean bl = !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })) {
            BooleanRef changed = BooleanRef.create((boolean)false);
            ((IterableLike)zkClient.getAllBrokersInCluster().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Broker x$2) {
                    return x$2.id();
                }
            }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(adminZkClient, changed){
                public static final long serialVersionUID = 0L;
                private final AdminZkClient adminZkClient$1;
                private final BooleanRef changed$1;

                public final void apply(int brokerId) {
                    this.apply$mcVI$sp(brokerId);
                }

                public void apply$mcVI$sp(int brokerId) {
                    Properties configs = this.adminZkClient$1.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString());
                    if (configs.remove(DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp()) != null | configs.remove(DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp()) != null | configs.remove(DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp()) != null) {
                        this.adminZkClient$1.changeBrokerConfig((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId}))), configs);
                        this.changed$1.elem = true;
                    }
                }
                {
                    this.adminZkClient$1 = adminZkClient$1;
                    this.changed$1 = changed$1;
                }
            });
            Seq topics = (Seq)((SetLike)reassignedPartitionsStatus.keySet().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(TopicPartition tp) {
                    return tp.topic();
                }
            }, Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)replicasReassignmentStatus.keySet().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(TopicPartitionReplica replica) {
                    return replica.topic();
                }
            }, Set$.MODULE$.canBuildFrom())).toSeq().distinct();
            topics.foreach((Function1)new Serializable(adminZkClient, changed){
                public static final long serialVersionUID = 0L;
                private final AdminZkClient adminZkClient$1;
                private final BooleanRef changed$1;

                public final void apply(String topic) {
                    Properties configs = this.adminZkClient$1.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
                    if (configs.remove(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()) != null | configs.remove(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()) != null) {
                        this.adminZkClient$1.changeTopicConfig(topic, configs);
                        this.changed$1.elem = true;
                    }
                }
                {
                    this.adminZkClient$1 = adminZkClient$1;
                    this.changed$1 = changed$1;
                }
            });
            if (changed.elem) {
                Predef$.MODULE$.println((Object)"Throttle was removed.");
            }
        }
    }

    public void generateAssignment(KafkaZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String topicsToMoveJsonFile = (String)opts.options().valueOf(opts.topicsToMoveJsonFileOpt());
        int[] brokerListToReassign = (int[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)opts.options().valueOf(opts.brokerListOpt()))).split(',')).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Iterable duplicateReassignments = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerListToReassign));
        if (duplicateReassignments.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Broker list contains duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignments.mkString(",")})));
        }
        String topicsToMoveJsonString = Utils.readFileAsString((String)topicsToMoveJsonFile);
        boolean disableRackAware = opts.options().has((OptionSpec)opts.disableRackAware());
        Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> tuple2 = this.generateAssignment(zkClient, (Seq<Object>)Predef$.MODULE$.wrapIntArray(brokerListToReassign), topicsToMoveJsonString, disableRackAware);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Map proposedAssignments = (Map)tuple2._1();
            Map currentAssignments = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)proposedAssignments, (Object)currentAssignments);
            Map proposedAssignments2 = (Map)tuple23._1();
            Map currentAssignments2 = (Map)tuple23._2();
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n%s\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson((Map<TopicPartition, Seq<Object>>)currentAssignments2, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Proposed partition reassignment configuration\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson((Map<TopicPartition, Seq<Object>>)proposedAssignments2, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
            return;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> generateAssignment(KafkaZkClient zkClient, Seq<Object> brokerListToReassign, String topicsToMoveJsonString, boolean disableRackAware) {
        Seq<String> topicsToReassign = this.parseTopicsData(topicsToMoveJsonString);
        Iterable<String> duplicateTopicsToReassign = CoreUtils$.MODULE$.duplicates(topicsToReassign);
        if (duplicateTopicsToReassign.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("List of topics to reassign contains duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateTopicsToReassign.mkString(",")})));
        }
        scala.collection.immutable.Map<TopicPartition, Seq<Object>> currentAssignment = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)topicsToReassign.toSet());
        scala.collection.immutable.Map groupedByTopic = currentAssignment.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicPartition, Seq<Object>> x0$5) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$5;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    String string = tp.topic();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        });
        Product rackAwareMode = disableRackAware ? RackAwareMode$Disabled$.MODULE$ : RackAwareMode$Enforced$.MODULE$;
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        Seq<BrokerMetadata> brokerMetadatas = adminZkClient.getBrokerMetadatas((RackAwareMode)rackAwareMode, (Option<Seq<Object>>)new Some(brokerListToReassign));
        scala.collection.mutable.Map partitionsToBeReassigned = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        groupedByTopic.foreach((Function1)new Serializable(brokerMetadatas, partitionsToBeReassigned){
            public static final long serialVersionUID = 0L;
            private final Seq brokerMetadatas$1;
            private final scala.collection.mutable.Map partitionsToBeReassigned$2;

            public final scala.collection.mutable.Map<TopicPartition, Seq<Object>> apply(Tuple2<String, scala.collection.immutable.Map<TopicPartition, Seq<Object>>> x0$6) {
                Tuple2<String, scala.collection.immutable.Map<TopicPartition, Seq<Object>>> tuple2 = x0$6;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)tuple2._2();
                    Tuple2 tuple22 = (Tuple2)assignment.head();
                    if (tuple22 != null) {
                        Seq replicas;
                        Seq seq;
                        Seq replicas2 = seq = (replicas = (Seq)tuple22._2());
                        Map<Object, Seq<Object>> assignedReplicas2 = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)this.brokerMetadatas$1, assignment.size(), replicas2.size(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                        scala.collection.mutable.Map map = (scala.collection.mutable.Map)this.partitionsToBeReassigned$2.$plus$plus$eq((TraversableOnce)assignedReplicas2.map((Function1)new Serializable(this, topic){
                            public static final long serialVersionUID = 0L;
                            private final String topic$1;

                            public final Tuple2<TopicPartition, Seq<Object>> apply(Tuple2<Object, Seq<Object>> x0$7) {
                                Tuple2<Object, Seq<Object>> tuple2 = x0$7;
                                if (tuple2 != null) {
                                    int partition = tuple2._1$mcI$sp();
                                    Seq replicas = (Seq)tuple2._2();
                                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic$1, partition)), (Object)replicas);
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.topic$1 = topic$1;
                            }
                        }, scala.collection.Map$.MODULE$.canBuildFrom()));
                        return map;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                this.brokerMetadatas$1 = brokerMetadatas$1;
                this.partitionsToBeReassigned$2 = partitionsToBeReassigned$2;
            }
        });
        return new Tuple2((Object)partitionsToBeReassigned, currentAssignment);
    }

    public void executeAssignment(KafkaZkClient zkClient, Option<AdminClient> adminClientOpt, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String reassignmentJsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String reassignmentJsonString = Utils.readFileAsString((String)reassignmentJsonFile);
        long interBrokerThrottle = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.interBrokerThrottleOpt()));
        long replicaAlterLogDirsThrottle = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.replicaAlterLogDirsThrottleOpt()));
        long timeoutMs = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.timeoutOpt()));
        this.executeAssignment(zkClient, adminClientOpt, reassignmentJsonString, new ReassignPartitionsCommand.Throttle(interBrokerThrottle, replicaAlterLogDirsThrottle, ReassignPartitionsCommand$Throttle$.MODULE$.apply$default$3()), timeoutMs);
    }

    public void executeAssignment(KafkaZkClient zkClient, Option<AdminClient> adminClientOpt, String reassignmentJsonString, ReassignPartitionsCommand.Throttle throttle2, long timeoutMs) {
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parseAndValidate(zkClient, reassignmentJsonString);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq partitionAssignment = (Seq)tuple2._1();
            Map replicaAssignment = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionAssignment, (Object)replicaAssignment);
            Seq partitionAssignment2 = (Seq)tuple23._1();
            Map replicaAssignment2 = (Map)tuple23._2();
            AdminZkClient adminZkClient = new AdminZkClient(zkClient);
            ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(zkClient, adminClientOpt, (Map<TopicPartition, Seq<Object>>)partitionAssignment2.toMap(Predef$.MODULE$.$conforms()), (Map<TopicPartitionReplica, String>)replicaAssignment2, adminZkClient);
            if (zkClient.reassignPartitionsInProgress()) {
                Predef$.MODULE$.println((Object)"There is an existing assignment running.");
                reassignPartitionsCommand.maybeLimit(throttle2);
            } else {
                this.printCurrentAssignment(zkClient, (Seq<String>)((Seq)partitionAssignment2.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<TopicPartition, Seq<Object>> x$6) {
                        return ((TopicPartition)x$6._1()).topic();
                    }
                }, Seq$.MODULE$.canBuildFrom())));
                if (throttle2.interBrokerLimit() >= 0L || throttle2.replicaAlterLogDirsLimit() >= 0L) {
                    Predef$.MODULE$.println((Object)String.format("Warning: You must run Verify periodically, until the reassignment completes, to ensure the throttle is removed. You can also alter the throttle by rerunning the Execute command passing a new value.", new Object[0]));
                }
                if (reassignPartitionsCommand.reassignPartitions(throttle2, timeoutMs)) {
                    Predef$.MODULE$.println((Object)"Successfully started reassignment of partitions.");
                } else {
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Failed to reassign partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionAssignment2})));
                }
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public long executeAssignment$default$5() {
        return 10000L;
    }

    public void printCurrentAssignment(KafkaZkClient zkClient, Seq<String> topics) {
        scala.collection.immutable.Map<TopicPartition, Seq<Object>> currentPartitionReplicaAssignment = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)topics.toSet());
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s\n\nSave this to use as the --reassignment-json-file option during rollback")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson((Map<TopicPartition, Seq<Object>>)currentPartitionReplicaAssignment, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
    }

    public String formatAsReassignmentJson(Map<TopicPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicPartitionReplica, String> replicaLogDirAssignment) {
        return Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)partitionsToBeReassigned.map((Function1)new Serializable(replicaLogDirAssignment){
            public static final long serialVersionUID = 0L;
            public final Map replicaLogDirAssignment$1;

            public final java.util.Map<String, Object> apply(Tuple2<TopicPartition, Seq<Object>> x0$8) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$8;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    java.util.Map map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)tp.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)tp.partition())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replicas"), JavaConverters$.MODULE$.seqAsJavaListConverter(replicas).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log_dirs"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1)new Serializable(this, tp){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.formatAsReassignmentJson.1 $outer;
                        private final TopicPartition tp$1;

                        public final String apply(int r) {
                            return (String)this.$outer.replicaLogDirAssignment$1.getOrElse((Object)new TopicPartitionReplica(this.tp$1.topic(), this.tp$1.partition(), r), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return ReassignPartitionsCommand$.MODULE$.AnyLogDir();
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.tp$1 = tp$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).asJava())}))).asJava();
                    return map;
                }
                throw new MatchError(tuple2);
            }
            {
                this.replicaLogDirAssignment$1 = replicaLogDirAssignment$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).asJava())}))).asJava());
    }

    public Seq<String> parseTopicsData(String jsonData) {
        Option<JsonValue> option;
        block4: {
            Option<JsonValue> option2;
            block7: {
                int n;
                JsonValue js;
                block6: {
                    block5: {
                        option = Json$.MODULE$.parseFull(jsonData);
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        js = (JsonValue)some.x();
                        option2 = js.asJsonObject().get("version");
                        if (!(option2 instanceof Some)) break block5;
                        Some some2 = (Some)option2;
                        JsonValue jsonValue = (JsonValue)some2.x();
                        n = BoxesRunTime.unboxToInt((Object)jsonValue.to(DecodeJson$DecodeInt$.MODULE$));
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option2)) break block7;
                    n = this.EarliestVersion();
                }
                int version = n;
                Seq<String> seq = this.parseTopicsData(version, js);
                return seq;
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new AdminOperationException("The input string is not a valid JSON");
        }
        throw new MatchError(option);
    }

    public Seq<String> parseTopicsData(int version, JsonValue js) {
        int n = version;
        switch (n) {
            default: {
                throw new AdminOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not supported version field value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
            }
            case 1: 
        }
        return (Seq)Option$.MODULE$.option2Iterable(js.asJsonObject().get("topics")).toSeq().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<String> apply(JsonValue partitionsSeq) {
                return partitionsSeq.asJsonArray().iterator().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(JsonValue p) {
                        return p.asJsonObject().apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                    }
                });
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(String jsonData) {
        Option<JsonValue> option;
        block4: {
            Option<JsonValue> option2;
            block7: {
                int n;
                JsonValue js;
                block6: {
                    block5: {
                        option = Json$.MODULE$.parseFull(jsonData);
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        js = (JsonValue)some.x();
                        option2 = js.asJsonObject().get("version");
                        if (!(option2 instanceof Some)) break block5;
                        Some some2 = (Some)option2;
                        JsonValue jsonValue = (JsonValue)some2.x();
                        n = BoxesRunTime.unboxToInt((Object)jsonValue.to(DecodeJson$DecodeInt$.MODULE$));
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option2)) break block7;
                    n = this.EarliestVersion();
                }
                int version = n;
                Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(version, js);
                return tuple2;
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new AdminOperationException("The input string is not a valid JSON");
        }
        throw new MatchError(option);
    }

    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(int version, JsonValue jsonData) {
        int n = version;
        switch (n) {
            default: {
                throw new AdminOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not supported version field value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
            }
            case 1: 
        }
        ListBuffer partitionAssignment = (ListBuffer)ListBuffer$.MODULE$.empty();
        scala.collection.mutable.Map replicaAssignment = Map$.MODULE$.empty();
        Option$.MODULE$.option2Iterable(jsonData.asJsonObject().get("partitions")).toSeq().foreach((Function1)new Serializable(partitionAssignment, replicaAssignment){
            public static final long serialVersionUID = 0L;
            public final ListBuffer partitionAssignment$1;
            public final scala.collection.mutable.Map replicaAssignment$1;

            public final void apply(JsonValue partitionsSeq) {
                partitionsSeq.asJsonArray().iterator().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.parsePartitionReassignmentData.1 $outer;

                    public final scala.collection.mutable.Map<TopicPartitionReplica, String> apply(JsonValue p) {
                        Option<JsonValue> option;
                        block6: {
                            Seq seq;
                            Seq newReplicas;
                            int partition;
                            String topic;
                            block5: {
                                block4: {
                                    JsonObject partitionFields = p.asJsonObject();
                                    topic = partitionFields.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                                    partition = BoxesRunTime.unboxToInt((Object)partitionFields.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                                    newReplicas = (Seq)partitionFields.apply("replicas").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
                                    option = partitionFields.get("log_dirs");
                                    if (!(option instanceof Some)) break block4;
                                    Some some = (Some)option;
                                    JsonValue jsonValue = (JsonValue)some.x();
                                    seq = (Seq)jsonValue.to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
                                    break block5;
                                }
                                if (!None$.MODULE$.equals(option)) break block6;
                                seq = (Seq)newReplicas.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(int x$7) {
                                        return ReassignPartitionsCommand$.MODULE$.AnyLogDir();
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                            }
                            Seq newLogDirs = seq;
                            if (newReplicas.size() != newLogDirs.size()) {
                                throw new AdminCommandFailedException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Size of replicas list ", " is different from "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newReplicas}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size of log dirs list ", " for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newLogDirs, new TopicPartition(topic, partition)}))).toString());
                            }
                            this.$outer.partitionAssignment$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)newReplicas));
                            return (scala.collection.mutable.Map)this.$outer.replicaAssignment$1.$plus$plus$eq((TraversableOnce)((TraversableLike)((TraversableLike)newReplicas.zip((GenIterable)newLogDirs, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, topic, partition){
                                public static final long serialVersionUID = 0L;
                                private final String topic$2;
                                private final int partition$1;

                                public final Tuple2<TopicPartitionReplica, String> apply(Tuple2<Object, String> x0$9) {
                                    Tuple2<Object, String> tuple2 = x0$9;
                                    if (tuple2 != null) {
                                        int replica = tuple2._1$mcI$sp();
                                        String logDir = (String)tuple2._2();
                                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(this.topic$2, this.partition$1, replica)), (Object)logDir);
                                        return tuple22;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    this.topic$2 = topic$2;
                                    this.partition$1 = partition$1;
                                }
                            }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Tuple2<TopicPartitionReplica, String> x$8) {
                                    Object object = x$8._2();
                                    String string = ReassignPartitionsCommand$.MODULE$.AnyLogDir();
                                    return object != null ? !object.equals(string) : string != null;
                                }
                            }));
                        }
                        throw new MatchError(option);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.partitionAssignment$1 = partitionAssignment$1;
                this.replicaAssignment$1 = replicaAssignment$1;
            }
        });
        return new Tuple2((Object)partitionAssignment, (Object)replicaAssignment);
    }

    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parseAndValidate(KafkaZkClient zkClient, String reassignmentJsonString) {
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(reassignmentJsonString);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq partitionsToBeReassigned = (Seq)tuple2._1();
            Map replicaAssignment = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionsToBeReassigned, (Object)replicaAssignment);
            Seq partitionsToBeReassigned2 = (Seq)tuple23._1();
            Map replicaAssignment2 = (Map)tuple23._2();
            if (partitionsToBeReassigned2.isEmpty()) {
                throw new AdminCommandFailedException("Partition reassignment data file is empty");
            }
            if (partitionsToBeReassigned2.exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<TopicPartition, Seq<Object>> x$10) {
                    return ((SeqLike)x$10._2()).isEmpty();
                }
            })) {
                throw new AdminCommandFailedException("Partition replica list cannot be empty");
            }
            Iterable duplicateReassignedPartitions = CoreUtils$.MODULE$.duplicates((Traversable)partitionsToBeReassigned2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final TopicPartition apply(Tuple2<TopicPartition, Seq<Object>> x0$10) {
                    Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$10;
                    if (tuple2 != null) {
                        TopicPartition tp;
                        TopicPartition topicPartition = tp = (TopicPartition)tuple2._1();
                        return topicPartition;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom()));
            if (duplicateReassignedPartitions.nonEmpty()) {
                throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition reassignment contains duplicate topic partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignedPartitions.mkString(",")})));
            }
            Seq duplicateEntries = (Seq)((TraversableLike)partitionsToBeReassigned2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<TopicPartition, Iterable<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$11) {
                    Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$11;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        Seq replicas = (Seq)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)tp, CoreUtils$.MODULE$.duplicates(replicas));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<TopicPartition, Iterable<Object>> x0$12) {
                    Tuple2<TopicPartition, Iterable<Object>> tuple2 = x0$12;
                    if (tuple2 != null) {
                        Iterable duplicatedReplicas = (Iterable)tuple2._2();
                        boolean bl = duplicatedReplicas.nonEmpty();
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            });
            if (duplicateEntries.nonEmpty()) {
                String duplicatesMsg = ((TraversableOnce)duplicateEntries.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<TopicPartition, Iterable<Object>> x0$13) {
                        Tuple2<TopicPartition, Iterable<Object>> tuple2 = x0$13;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            Iterable duplicateReplicas = (Iterable)tuple2._2();
                            String string = new StringOps(Predef$.MODULE$.augmentString("%s contains multiple entries for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, duplicateReplicas.mkString(",")}));
                            return string;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(". ");
                throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition replica lists may not contain duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatesMsg})));
            }
            Seq proposedTopics = (Seq)((SeqLike)partitionsToBeReassigned2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<TopicPartition, Seq<Object>> x0$14) {
                    Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$14;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        String string = tp.topic();
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom())).distinct();
            scala.collection.immutable.Map<TopicPartition, Seq<Object>> existingAssignment = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)proposedTopics.toSet());
            Seq nonExistentPartitions = (Seq)((TraversableLike)partitionsToBeReassigned2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final TopicPartition apply(Tuple2<TopicPartition, Seq<Object>> x0$15) {
                    Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$15;
                    if (tuple2 != null) {
                        TopicPartition tp;
                        TopicPartition topicPartition = tp = (TopicPartition)tuple2._1();
                        return topicPartition;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(existingAssignment){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map existingAssignment$1;

                public final boolean apply(TopicPartition key) {
                    return this.existingAssignment$1.contains((Object)key);
                }
                {
                    this.existingAssignment$1 = existingAssignment$1;
                }
            });
            if (nonExistentPartitions.nonEmpty()) {
                throw new AdminCommandFailedException(new StringBuilder().append((Object)"The proposed assignment contains non-existent partitions: ").append((Object)nonExistentPartitions).toString());
            }
            Seq<Object> existingBrokerIDs = zkClient.getSortedBrokerList();
            scala.collection.immutable.Set nonExistingBrokerIDs = ((TraversableOnce)((TraversableLike)partitionsToBeReassigned2.toMap(Predef$.MODULE$.$conforms()).values().flatten((Function1)Predef$.MODULE$.$conforms())).filterNot((Function1)new Serializable(existingBrokerIDs){
                public static final long serialVersionUID = 0L;
                private final Seq existingBrokerIDs$1;

                public final boolean apply(Object elem) {
                    return this.existingBrokerIDs$1.contains(elem);
                }
                {
                    this.existingBrokerIDs$1 = existingBrokerIDs$1;
                }
            })).toSet();
            if (nonExistingBrokerIDs.nonEmpty()) {
                throw new AdminCommandFailedException(new StringBuilder().append((Object)"The proposed assignment contains non-existent brokerIDs: ").append((Object)nonExistingBrokerIDs.mkString(",")).toString());
            }
            return new Tuple2((Object)partitionsToBeReassigned2, (Object)replicaAssignment2);
        }
        throw new MatchError(tuple2);
    }

    private Map<TopicPartition, ReassignmentStatus> checkIfPartitionReassignmentSucceeded(KafkaZkClient zkClient, Map<TopicPartition, Seq<Object>> partitionsToBeReassigned) {
        Map<TopicPartition, Seq<Object>> partitionsBeingReassigned = zkClient.getPartitionReassignment();
        return ((TraversableOnce)partitionsToBeReassigned.keys().map((Function1)new Serializable(zkClient, partitionsToBeReassigned, partitionsBeingReassigned){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$1;
            private final Map partitionsToBeReassigned$1;
            private final Map partitionsBeingReassigned$1;

            public final Tuple2<TopicPartition, ReassignmentStatus> apply(TopicPartition topicAndPartition) {
                return new Tuple2((Object)topicAndPartition, (Object)ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkClient$1, topicAndPartition, (Map<TopicPartition, Seq<Object>>)this.partitionsToBeReassigned$1, (Map<TopicPartition, Seq<Object>>)this.partitionsBeingReassigned$1));
            }
            {
                this.zkClient$1 = zkClient$1;
                this.partitionsToBeReassigned$1 = partitionsToBeReassigned$1;
                this.partitionsBeingReassigned$1 = partitionsBeingReassigned$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<TopicPartitionReplica, ReassignmentStatus> checkIfReplicaReassignmentSucceeded(Option<AdminClient> adminClientOpt, Map<TopicPartitionReplica, String> replicaAssignment) {
        scala.collection.immutable.Map map;
        if (replicaAssignment.nonEmpty()) {
            AdminClient adminClient = (AdminClient)adminClientOpt.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new AdminCommandFailedException("bootstrap-server needs to be provided in order to reassign replica to the specified log directory");
                }
            });
            map = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)adminClient.describeReplicaLogDirs((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter(replicaAssignment.keySet()).asJava()).all().get()).asScala();
        } else {
            map = scala.collection.Map$.MODULE$.empty();
        }
        scala.collection.immutable.Map replicaLogDirInfos = map;
        return (Map)replicaAssignment.map((Function1)new Serializable((Map)replicaLogDirInfos){
            public static final long serialVersionUID = 0L;
            private final Map replicaLogDirInfos$1;

            public final Tuple2<TopicPartitionReplica, ReassignmentStatus> apply(Tuple2<TopicPartitionReplica, String> x0$16) {
                Tuple2<TopicPartitionReplica, String> tuple2;
                block11: {
                    Option option;
                    block14: {
                        Product product;
                        TopicPartitionReplica replica;
                        block13: {
                            block12: {
                                Product product2;
                                tuple2 = x0$16;
                                if (tuple2 == null) break block11;
                                replica = (TopicPartitionReplica)tuple2._1();
                                String newLogDir = (String)tuple2._2();
                                option = this.replicaLogDirInfos$1.get((Object)replica);
                                if (!(option instanceof Some)) break block12;
                                Some some = (Some)option;
                                DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaLogDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)some.x();
                                if (replicaLogDirInfo.getCurrentReplicaLogDir() == null) {
                                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", "-", " is not found in any live log dir on "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica.topic(), BoxesRunTime.boxToInteger((int)replica.partition())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker ", ". There is likely offline log directory on the broker."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replica.brokerId())}))).toString());
                                    product2 = ReassignmentFailed$.MODULE$;
                                } else {
                                    String string = replicaLogDirInfo.getFutureReplicaLogDir();
                                    String string2 = newLogDir;
                                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                        product2 = ReassignmentInProgress$.MODULE$;
                                    } else if (replicaLogDirInfo.getFutureReplicaLogDir() == null) {
                                        String string3 = replicaLogDirInfo.getCurrentReplicaLogDir();
                                        String string4 = newLogDir;
                                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                                            product2 = ReassignmentCompleted$.MODULE$;
                                        } else {
                                            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", "-", " on broker ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica.topic(), BoxesRunTime.boxToInteger((int)replica.partition()), BoxesRunTime.boxToInteger((int)replica.brokerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is not being moved from log dir ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicaLogDirInfo.getCurrentReplicaLogDir(), newLogDir}))).toString());
                                            product2 = ReassignmentFailed$.MODULE$;
                                        }
                                    } else {
                                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", "-", " on broker ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica.topic(), BoxesRunTime.boxToInteger((int)replica.partition()), BoxesRunTime.boxToInteger((int)replica.brokerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is being moved to log dir ", " instead of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicaLogDirInfo.getFutureReplicaLogDir(), newLogDir}))).toString());
                                        product2 = ReassignmentFailed$.MODULE$;
                                    }
                                }
                                product = product2;
                                break block13;
                            }
                            if (!None$.MODULE$.equals(option)) break block14;
                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", "-", " is not found in any live log dir on broker ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica.topic(), BoxesRunTime.boxToInteger((int)replica.partition()), BoxesRunTime.boxToInteger((int)replica.brokerId())})));
                            product = ReassignmentFailed$.MODULE$;
                        }
                        ReassignmentInProgress$ status = product;
                        Tuple2 tuple22 = new Tuple2((Object)replica, (Object)status);
                        return tuple22;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple2);
            }
            {
                this.replicaLogDirInfos$1 = replicaLogDirInfos$1;
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public ReassignmentStatus checkIfPartitionReassignmentSucceeded(KafkaZkClient zkClient, TopicPartition topicAndPartition, Map<TopicPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicPartition, Seq<Object>> partitionsBeingReassigned) {
        Option option;
        block7: {
            Product product;
            block6: {
                Product product2;
                Seq<Object> assignedReplicas2;
                Seq newReplicas;
                block5: {
                    newReplicas = (Seq)partitionsToBeReassigned.apply((Object)topicAndPartition);
                    option = partitionsBeingReassigned.get((Object)topicAndPartition);
                    if (!(option instanceof Some)) break block5;
                    product = ReassignmentInProgress$.MODULE$;
                    break block6;
                }
                if (!None$.MODULE$.equals(option)) break block7;
                Seq<Object> seq = assignedReplicas2 = zkClient.getReplicasForPartition(new TopicPartition(topicAndPartition.topic(), topicAndPartition.partition()));
                Seq seq2 = newReplicas;
                if (!(seq != null ? !seq.equals((Object)seq2) : seq2 != null)) {
                    product2 = ReassignmentCompleted$.MODULE$;
                } else {
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("ERROR: Assigned replicas (%s) don't match the list of replicas for reassignment (%s) for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{assignedReplicas2.mkString(","), newReplicas.mkString(","), topicAndPartition})));
                    product2 = ReassignmentFailed$.MODULE$;
                }
                product = product2;
            }
            return product;
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReassignPartitionsCommand.ReassignPartitionsCommandOptions validateAndParseArgs(String[] args) {
        void var2_2;
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "This command moves topic partitions between replicas.");
        }
        int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.generateOpt(), opts.executeOpt(), opts.verifyOpt()}))).count((Function1)new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts$1;

            public final boolean apply(OptionSpec<?> x$1) {
                return this.opts$1.options().has(x$1);
            }
            {
                this.opts$1 = opts$1;
            }
        });
        if (actions != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --generate, --execute or --verify");
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.zkConnectOpt()}));
        if (opts.options().has((OptionSpec)opts.verifyOpt())) {
            if (!opts.options().has(opts.reassignmentJsonFileOpt())) throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --verify option is used, command must include --reassignment-json-file that was used during the --execute option");
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.verifyOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.interBrokerThrottleOpt(), opts.replicaAlterLogDirsThrottleOpt(), opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()}))));
            return var2_2;
        } else if (opts.options().has((OptionSpec)opts.generateOpt())) {
            if (!opts.options().has(opts.topicsToMoveJsonFileOpt()) || !opts.options().has(opts.brokerListOpt())) throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options");
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.generateOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.interBrokerThrottleOpt(), opts.replicaAlterLogDirsThrottleOpt(), opts.reassignmentJsonFileOpt()}))));
            return var2_2;
        } else {
            if (!opts.options().has((OptionSpec)opts.executeOpt())) return var2_2;
            if (!opts.options().has(opts.reassignmentJsonFileOpt())) throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --execute option is used, command must include --reassignment-json-file that was output during the --generate option");
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.executeOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()}))));
        }
        return var2_2;
    }

    public Map<TopicPartitionReplica, String> $lessinit$greater$default$4() {
        return scala.collection.Map$.MODULE$.empty();
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.NoThrottle = new ReassignPartitionsCommand.Throttle(-1L, -1L, ReassignPartitionsCommand$Throttle$.MODULE$.apply$default$3());
        this.AnyLogDir = "any";
        this.EarliestVersion = 1;
    }
}

