/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GetOffsetShell$ {
    public static final GetOffsetShell$ MODULE$;

    static {
        new GetOffsetShell$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionOpt = parser.accepts("partitions", "comma separated list of partition ids. If not specified, it will find offsets for all partitions").withRequiredArg().describedAs("partition ids").ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec timeOpt = parser.accepts("time", "timestamp of the offsets before that").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(-1L), (Object[])new Long[0]);
        parser.accepts("offsets", "DEPRECATED AND IGNORED: number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        parser.accepts("max-wait-ms", "DEPRECATED AND IGNORED: The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An interactive shell for getting topic offsets.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt}));
        String clientId2 = "GetOffsetShell";
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        String topic = (String)options.valueOf((OptionSpec)topicOpt);
        String partitionsString = (String)options.valueOf((OptionSpec)partitionOpt);
        Set partitionIdsRequested = partitionsString.isEmpty() ? Predef$.MODULE$.Set().empty() : Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])partitionsString.split(",")).map((Function1)new Serializable(partitionsString){
            public static final long serialVersionUID = 0L;
            private final String partitionsString$1;

            public final int apply(String partitionString) {
                try {
                    return new StringOps(Predef$.MODULE$.augmentString(partitionString)).toInt();
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--partitions expects a comma separated list of numeric partition ids, but received: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsString$1})));
                    throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
                }
            }
            {
                this.partitionsString$1 = partitionsString$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toSet();
        long listOffsetsTimestamp = (Long)options.valueOf((OptionSpec)timeOpt);
        Properties config = new Properties();
        config.setProperty("bootstrap.servers", brokerList);
        config.setProperty("client.id", clientId2);
        KafkaConsumer consumer = new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        boolean bl = false;
        Some some = null;
        Option<Seq<PartitionInfo>> option = this.listPartitionInfos(consumer, topic, (Set<Object>)partitionIdsRequested);
        if (None$.MODULE$.equals(option)) {
            System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Seq p = (Seq)some.x();
            if (p.isEmpty()) {
                if (partitionIdsRequested.isEmpty()) {
                    System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " has 0 partitions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                } else {
                    System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " does not have any of the requested partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, partitionIdsRequested.mkString(",")})));
                }
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
        }
        if (bl) {
            Map map;
            Seq p;
            Seq seq;
            Seq partitionInfos = seq = (p = (Seq)some.x());
            if (partitionIdsRequested.nonEmpty()) {
                ((IterableLike)partitionIdsRequested.$minus$minus((GenTraversableOnce)partitionInfos.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(PartitionInfo x$1) {
                        return x$1.partition();
                    }
                }, Seq$.MODULE$.canBuildFrom()))).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(int partitionId) {
                        this.apply$mcVI$sp(partitionId);
                    }

                    public void apply$mcVI$sp(int partitionId) {
                        System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: partition ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)})));
                    }
                });
            }
            Seq topicPartitions = (Seq)((TraversableLike)partitionInfos.sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(PartitionInfo x$2) {
                    return x$2.partition();
                }
            }, (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<TopicPartition> apply(PartitionInfo p) {
                    Iterable iterable;
                    if (p.leader() == null) {
                        System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: partition ", " does not have a leader. Skip getting offsets"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)p.partition())})));
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    } else {
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new TopicPartition(p.topic(), p.partition())));
                    }
                    return iterable;
                }
            }, Seq$.MODULE$.canBuildFrom());
            long l = listOffsetsTimestamp;
            if (-2L == l) {
                map = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.beginningOffsets((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala();
            } else if (-1L == l) {
                map = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.endOffsets((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala();
            } else {
                java.util.Map timestampsToSearch = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)topicPartitions.map((Function1)new Serializable(listOffsetsTimestamp){
                    public static final long serialVersionUID = 0L;
                    private final long listOffsetsTimestamp$1;

                    public final Tuple2<TopicPartition, Long> apply(TopicPartition tp) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Predef$.MODULE$.long2Long(this.listOffsetsTimestamp$1));
                    }
                    {
                        this.listOffsetsTimestamp$1 = listOffsetsTimestamp$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
                map = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.offsetsForTimes(timestampsToSearch)).asScala()).mapValues((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Long apply(OffsetAndTimestamp x) {
                        return x == null ? null : Predef$.MODULE$.long2Long(x.offset());
                    }
                });
            }
            Map partitionOffsets = map;
            ((IterableLike)partitionOffsets.toSeq().sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<TopicPartition, Long> x0$1) {
                    Tuple2<TopicPartition, Long> tuple2 = x0$1;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        int n = tp.partition();
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
            }, (Ordering)Ordering.Int$.MODULE$)).foreach((Function1)new Serializable(topic){
                public static final long serialVersionUID = 0L;
                private final String topic$1;

                public final void apply(Tuple2<TopicPartition, Long> x0$2) {
                    Tuple2<TopicPartition, Long> tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        Long offset2 = (Long)tuple2._2();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)tp.partition()), Option$.MODULE$.apply((Object)offset2).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        })})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.topic$1 = topic$1;
                }
            });
            return;
        }
        throw new MatchError(option);
    }

    private Option<Seq<PartitionInfo>> listPartitionInfos(KafkaConsumer<?, ?> consumer, String topic, Set<Object> partitionIds) {
        Buffer partitionInfos = ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.listTopics()).asScala()).filterKeys((Function1)new Serializable(topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final boolean apply(String x$3) {
                String string = x$3;
                String string2 = this.topic$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.topic$2 = topic$2;
            }
        }).values().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Buffer<PartitionInfo> apply(List<PartitionInfo> x$4) {
                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$4).asScala();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toBuffer();
        return partitionInfos.isEmpty() ? None$.MODULE$ : (partitionIds.isEmpty() ? new Some((Object)partitionInfos) : new Some(partitionInfos.filter((Function1)new Serializable(partitionIds){
            public static final long serialVersionUID = 0L;
            private final Set partitionIds$1;

            public final boolean apply(PartitionInfo p) {
                return this.partitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)p.partition()));
            }
            {
                this.partitionIds$1 = partitionIds$1;
            }
        })));
    }

    private GetOffsetShell$() {
        MODULE$ = this;
    }
}

