/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.net.SocketTimeoutException;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\t\u001d\u0011!DU3qY&\u001c\u0017MR3uG\",'O\u00117pG.LgnZ*f]\u0012T!a\u0001\u0003\u0002\u000bQ|w\u000e\\:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aD\u0001b\u0004\u0001\u0003\u0002\u0003\u0006I\u0001E\u0001\u000bg>,(oY3O_\u0012,\u0007CA\t\u001a\u001b\u0005\u0011\"BA\n\u0015\u0003\u0019\u0019w.\\7p]*\u0011Q!\u0006\u0006\u0003-]\ta!\u00199bG\",'\"\u0001\r\u0002\u0007=\u0014x-\u0003\u0002\u001b%\t!aj\u001c3f\u0011!a\u0002A!A!\u0002\u0013i\u0012AD2p]N,X.\u001a:D_:4\u0017n\u001a\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\n\u0001bY8ogVlWM\u001d\u0006\u0003EQ\tqa\u00197jK:$8/\u0003\u0002%?\tq1i\u001c8tk6,'oQ8oM&<\u0007\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u000f5,GO]5dgB\u0011\u0001FK\u0007\u0002S)\u0011aEE\u0005\u0003W%\u0012q!T3ue&\u001c7\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003\u0011!\u0018.\\3\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\u0012\u0012!B;uS2\u001c\u0018BA\u001a1\u0005\u0011!\u0016.\\3\t\u0011U\u0002!\u0011!Q\u0001\nY\n\u0011BZ3uG\",'/\u00133\u0011\u0005%9\u0014B\u0001\u001d\u000b\u0005\rIe\u000e\u001e\u0005\tu\u0001\u0011\t\u0011)A\u0005w\u0005A1\r\\5f]RLE\r\u0005\u0002=\u007f9\u0011\u0011\"P\u0005\u0003})\ta\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011aH\u0003\u0005\u0006\u0007\u0002!\t\u0001R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f\u0015;\u0005*\u0013&L\u0019B\u0011a\tA\u0007\u0002\u0005!)qB\u0011a\u0001!!)AD\u0011a\u0001;!)aE\u0011a\u0001O!)QF\u0011a\u0001]!)QG\u0011a\u0001m!)!H\u0011a\u0001w!9a\n\u0001b\u0001\n\u0013y\u0015!D:pG.,G\u000fV5nK>,H/F\u00017\u0011\u0019\t\u0006\u0001)A\u0005m\u0005q1o\\2lKR$\u0016.\\3pkR\u0004\u0003bB*\u0001\u0005\u0004%I\u0001V\u0001\u000e]\u0016$xo\u001c:l\u00072LWM\u001c;\u0016\u0003U\u0003\"AV,\u000e\u0003\u0005J!\u0001W\u0011\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u0011\u0019Q\u0006\u0001)A\u0005+\u0006qa.\u001a;x_J\\7\t\\5f]R\u0004\u0003\"\u0002/\u0001\t\u0003i\u0016aC:f]\u0012\u0014V-];fgR$\"AX1\u0011\u0005Y{\u0016B\u00011\"\u00059\u0019E.[3oiJ+7\u000f]8og\u0016DQAY.A\u0002\r\faB]3rk\u0016\u001cHOQ;jY\u0012,'\u000f\r\u0002eyB\u0019Qm\u001e>\u000f\u0005\u0019$hBA4s\u001d\tA\u0017O\u0004\u0002ja:\u0011!n\u001c\b\u0003W:l\u0011\u0001\u001c\u0006\u0003[\u001a\ta\u0001\u0010:p_Rt\u0014\"\u0001\r\n\u0005Y9\u0012BA\u0003\u0016\u0013\t\u0019B#\u0003\u0002t%\u0005A!/Z9vKN$8/\u0003\u0002vm\u0006y\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cHO\u0003\u0002t%%\u0011\u00010\u001f\u0002\b\u0005VLG\u000eZ3s\u0015\t)h\u000f\u0005\u0002|y2\u0001A!C?b\u0003\u0003\u0005\tQ!\u0001\u007f\u0005\ryF%M\t\u0004\u007f\u0006\u0015\u0001cA\u0005\u0002\u0002%\u0019\u00111\u0001\u0006\u0003\u000f9{G\u000f[5oOB!\u0011qAA\u0005\u001b\u00051\u0018bAA\u0006m\ny\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000fC\u0004\u0002\u0010\u0001!\t!!\u0005\u0002\u000b\rdwn]3\u0015\u0005\u0005M\u0001cA\u0005\u0002\u0016%\u0019\u0011q\u0003\u0006\u0003\tUs\u0017\u000e\u001e")
public class ReplicaFetcherBlockingSend {
    private final Node sourceNode;
    private final Time time;
    private final int socketTimeout;
    private final NetworkClient networkClient;

    private int socketTimeout() {
        return this.socketTimeout;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        try {
            if (NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.sourceNode, (Time)this.time, (long)this.socketTimeout())) {
                ClientRequest clientRequest = this.networkClient().newClientRequest(((Object)BoxesRunTime.boxToInteger((int)this.sourceNode.id())).toString(), requestBuilder, this.time.milliseconds(), true);
                return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time);
            }
            throw new SocketTimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to connect within ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.socketTimeout())})));
        }
        catch (Throwable throwable) {
            this.networkClient().close(((Object)BoxesRunTime.boxToInteger((int)this.sourceNode.id())).toString());
            throw throwable;
        }
    }

    public void close() {
        this.networkClient().close();
    }

    public ReplicaFetcherBlockingSend(Node sourceNode, ConsumerConfig consumerConfig, Metrics metrics, Time time, int fetcherId, String clientId2) {
        this.sourceNode = sourceNode;
        this.time = time;
        this.socketTimeout = Predef$.MODULE$.Integer2int(consumerConfig.getInt("request.timeout.ms"));
        ChannelBuilder channelBuilder = ClientUtils.createChannelBuilder((AbstractConfig)consumerConfig);
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(consumerConfig.getLong("connections.max.idle.ms")), metrics, time, "replica-fetcher", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)sourceNode.id())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)fetcherId)).toString())}))).asJava(), false, channelBuilder, new LogContext());
        this.networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId2, 1, 0L, 0L, -1, Predef$.MODULE$.Integer2int(consumerConfig.getInt("receive.buffer.bytes")), Predef$.MODULE$.Integer2int(consumerConfig.getInt("request.timeout.ms")), time, false, new ApiVersions(), new LogContext());
    }
}

