/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommand$;
import kafka.admin.ConfigCommandTest;
import kafka.admin.ConfigCommandTest$CredentialChange$2$;
import kafka.api.ApiVersion$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfigTest;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Sanitizer;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\u0005b\u0001\u0002$H\u00011CQ!\u0017\u0001\u0005\u0002iCQ!\u0018\u0001\u0005\u0002yCQA\u001c\u0001\u0005\u0002yCQ\u0001\u001d\u0001\u0005\u0002yCQA\u001d\u0001\u0005\nMDa!!\u0003\u0001\t\u0003q\u0006BBA\u0007\u0001\u0011\u0005a\f\u0003\u0004\u0002\u0012\u0001!\tA\u0018\u0005\u0007\u0003+\u0001A\u0011\u00010\t\r\u0005e\u0001\u0001\"\u0001_\u0011\u0019\ti\u0002\u0001C\u0001=\"1\u0011\u0011\u0005\u0001\u0005\u0002yCq!!\n\u0001\t\u0003\t9\u0003\u0003\u0004\u00028\u0001!\tA\u0018\u0005\u0007\u0003w\u0001A\u0011\u00010\t\r\u0005U\u0003\u0001\"\u0001_\u0011\u0019\tI\u0006\u0001C\u0001=\"1\u0011Q\f\u0001\u0005\u0002yCa!!\u0019\u0001\t\u0003q\u0006BBA3\u0001\u0011\u0005a\f\u0003\u0004\u0002j\u0001!\tA\u0018\u0005\u0007\u0003[\u0002A\u0011\u00010\t\r\u0005E\u0004\u0001\"\u0001_\u0011\u0019\t)\b\u0001C\u0001=\"1\u0011\u0011\u0010\u0001\u0005\u0002yCa!! \u0001\t\u0003q\u0006BBAA\u0001\u0011\u0005a\f\u0003\u0004\u0002\u0006\u0002!\tA\u0018\u0005\u0007\u0003\u0013\u0003A\u0011\u00010\t\r\u00055\u0005\u0001\"\u0001_\u0011\u0019\t\t\n\u0001C\u0001=\"1\u0011Q\u0013\u0001\u0005\u0002yCa!!'\u0001\t\u0003q\u0006BBAO\u0001\u0011\u0005a\f\u0003\u0004\u0002\"\u0002!\tA\u0018\u0005\u0007\u0003K\u0003A\u0011\u00010\t\r\u0005\u0005\u0007\u0001\"\u0001_\u0011\u001d\t)\r\u0001C\u0001\u0003\u000fDq!a9\u0001\t\u0003\t)\u000f\u0003\u0004\u0003\u0004\u0001!\tA\u0018\u0005\u0007\u0005\u000f\u0001A\u0011\u00010\t\r\t-\u0001\u0001\"\u0001_\u0011\u0019\u0011y\u0001\u0001C\u0001=\"1!1\u0003\u0001\u0005\u0002yCaAa\u0006\u0001\t\u0003q\u0006B\u0002B\u000e\u0001\u0011\u0005a\f\u0003\u0004\u0003 \u0001!\tA\u0018\u0005\u0007\u0005G\u0001A\u0011\u00010\t\r\t\u001d\u0002\u0001\"\u0001_\u0011\u0019\u0011Y\u0003\u0001C\u0001=\"1!q\u0006\u0001\u0005\u0002yCaAa\r\u0001\t\u0003q\u0006B\u0002B\u001c\u0001\u0011\u0005a\f\u0003\u0004\u0003<\u0001!\tA\u0018\u0005\b\u0005\u007f\u0001A\u0011\u0002B!\r\u0019\u0011i\u0005\u0001\u0001\u0003P!Q!q\u000b\u001d\u0003\u0002\u0003\u0006IA!\u0017\t\reCD\u0011\u0001B0\u0011\u001d\u00119\u0007\u000fC!\u0005SBqAa$9\t\u0003\u0012\t\nC\u0004\u0003\u0018b\"\tE!'\t\u000f\t\u0005\u0006\b\"\u0011\u0003$\"9!1\u0016\u001d\u0005B\t5fA\u0002B[\u0001\u0001\u00119\f\u0003\u0006\u0002L\u0002\u0013\t\u0011)A\u0005\u0003\u001bDa!\u0017!\u0005\u0002\t}\u0006b\u0002Bc\u0001\u0012\u0005#q\u0019\u0005\b\u0005_\u0004E\u0011\tBy\u0011\u001d\u0019\t\u0002\u0011C!\u0007'\u0011\u0011cQ8oM&<7i\\7nC:$G+Z:u\u0015\tA\u0015*A\u0003bI6LgNC\u0001K\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A'T!\tq\u0015+D\u0001P\u0015\t\u0001\u0016*\u0001\u0002{W&\u0011!k\u0014\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005Q;V\"A+\u000b\u0005YK\u0015!B;uS2\u001c\u0018B\u0001-V\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A.\u0011\u0005q\u0003Q\"A$\u0002KMDw.\u001e7e\u000bbLGoV5uQ:{gNW3s_N#\u0018\r^;t\u001f:\f%oZ#se>\u0014H#A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0003\t\fQa]2bY\u0006L!\u0001Z1\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u0019\u0004\"a\u001a7\u000e\u0003!T!!\u001b6\u0002\u000b),h.\u001b;\u000b\u0003-\f1a\u001c:h\u0013\ti\u0007N\u0001\u0003UKN$\u0018aK:i_VdG-\u0012=ji^KG\u000f\u001b(p]j+'o\\*uCR,8o\u00148[W\u000e{W.\\1oI\u0016\u0013(o\u001c:)\u0005\r1\u0017aL:i_VdG-\u0012=ji^KG\u000f\u001b(p]j+'o\\*uCR,8o\u00148Ce>\\WM]\"p[6\fg\u000eZ#se>\u0014\bF\u0001\u0003g\u0003]\t7o]3si:{gNW3s_N#\u0018\r^;t\u000bbLG\u000f\u0006\u0002`i\")Q/\u0002a\u0001m\u0006!\u0011M]4t!\r\u0001w/_\u0005\u0003q\u0006\u0014Q!\u0011:sCf\u00042A_A\u0002\u001d\tYx\u0010\u0005\u0002}C6\tQP\u0003\u0002\u007f\u0017\u00061AH]8pizJ1!!\u0001b\u0003\u0019\u0001&/\u001a3fM&!\u0011QAA\u0004\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011A1\u0002mMDw.\u001e7e!\u0006\u00148/Z!sOVlWM\u001c;t\r>\u00148\t\\5f]R\u001cXI\u001c;jif$\u0016\u0010]3Vg&twMW8pW\u0016,\u0007/\u001a:)\u0005\u00191\u0017\u0001N:i_VdG\rU1sg\u0016\f%oZ;nK:$8OR8s+N,'o]#oi&$\u0018\u0010V=qKV\u001b\u0018N\\4[_>\\W-\u001a9fe\"\u0012qAZ\u00016g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J$v\u000e]5dg\u0016sG/\u001b;z)f\u0004X-V:j]\u001eTvn\\6fKB,'\u000f\u000b\u0002\tM\u000693\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN\u001d+pa&\u001c7/\u00128uSRLH+\u001f9fQ\tIa-\u0001\u001ctQ>,H\u000e\u001a)beN,\u0017I]4v[\u0016tGo\u001d$pe\n\u0013xn[3sg\u0016sG/\u001b;z)f\u0004X-V:j]\u001eTvn\\6fKB,'\u000f\u000b\u0002\u000bM\u0006A3\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN\u001d\"s_.,'o]#oi&$\u0018\u0010V=qK\"\u00121BZ\u0001/g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J\u0014%o\\6fe2{wmZ3sg\u0016sG/\u001b;z)f\u0004X\r\u000b\u0002\rM\u0006\tB/Z:u\u0003J<W/\\3oiB\u000b'o]3\u0015\u000b}\u000bI#!\f\t\r\u0005-R\u00021\u0001z\u0003))g\u000e^5usRK\b/\u001a\u0005\b\u0003_i\u0001\u0019AA\u0019\u0003!Q8nQ8oM&<\u0007c\u00011\u00024%\u0019\u0011QG1\u0003\u000f\t{w\u000e\\3b]\u0006IB/Z:u\u001fB$\u0018n\u001c8F]RLG/\u001f+za\u0016t\u0015-\\3tQ\tqa-\u0001\u0019tQ>,H\u000e\u001a$bS2Le-\u00168sK\u000e|wM\\5tK\u0012,e\u000e^5usRK\b/Z+tS:<'l\\8lK\u0016\u0004XM\u001d\u0015\u0007\u001f\u0019\fy$!\u0011\u0002\u0011\u0015D\b/Z2uK\u0012\u001c#!a\u0011\u0011\t\u0005\u0015\u0013q\n\b\u0005\u0003\u000f\nYED\u0002}\u0003\u0013J\u0011AY\u0005\u0004\u0003\u001b\n\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003#\n\u0019F\u0001\rJY2,w-\u00197Be\u001e,X.\u001a8u\u000bb\u001cW\r\u001d;j_:T1!!\u0014b\u0003\t\u001a\bn\\;mI\u001a\u000b\u0017\u000e\\%g+:\u0014XmY8h]&\u001cX\rZ#oi&$\u0018\u0010V=qK\"2\u0001CZA \u0003\u0003\n\u0001h\u001d5pk2$g)Y5m\u0013\u001a\u0014%o\\6fe\u0016sG/\u001b;z)f\u0004X-S:O_R\fe.\u00138uK\u001e,'/V:j]\u001eTvn\\6fKB,'\u000f\u000b\u0004\u0012M\u0006}\u0012\u0011I\u0001+g\"|W\u000f\u001c3GC&d\u0017J\u001a\"s_.,'/\u00128uSRLH+\u001f9f\u0013Ntu\u000e^!o\u0013:$XmZ3sQ\u0019\u0011b-a\u0010\u0002B\u0005i4\u000f[8vY\u00124\u0015-\u001b7JMNCwN\u001d;Ce>\\WM]#oi&$\u0018\u0010V=qK&\u001bhj\u001c;B]&sG/Z4feV\u001b\u0018N\\4[_>\\W-\u001a9fe\"21CZA \u0003\u0003\nqf\u001d5pk2$g)Y5m\u0013\u001a\u001c\u0006n\u001c:u\u0005J|7.\u001a:F]RLG/\u001f+za\u0016L5OT8u\u0003:Le\u000e^3hKJDc\u0001\u00064\u0002@\u0005\u0005\u0013AL:i_VdGMR1jY&3W*\u001b=fI\u0016sG/\u001b;z)f\u0004XM\u00127bON,6/\u001b8h5>|7.Z3qKJDc!\u00064\u0002@\u0005\u0005\u0013aI:i_VdG-\u00113e\u00072LWM\u001c;D_:4\u0017nZ+tS:<'l\\8lK\u0016\u0004XM\u001d\u0015\u0003-\u0019\f!e\u001d5pk2$\u0017\t\u001a3U_BL7mQ8oM&<Wk]5oOj{wn[3fa\u0016\u0014\bFA\fg\u0003Y\u0019\bn\\;mI\u0006cG/\u001a:U_BL7mQ8oM&<\u0007F\u0001\rg\u0003q\u0019\bn\\;mI\u0012+7o\u0019:jE\u0016\u001cuN\u001c4jONKhn\u001c8z[ND#!\u00074\u00025MDw.\u001e7e\u0003\u0012$'I]8lKJ\fVo\u001c;b\u0007>tg-[4)\u0005i1\u0017\u0001H:i_VdG-\u00113e\u0005J|7.\u001a:Es:\fW.[2D_:4\u0017n\u001a\u0015\u00037\u0019\f1d\u001d5pk2$\u0017\t\u001a3Ce>\\WM\u001d'pO\u001e,'oQ8oM&<\u0007F\u0001\u000fg\u0003m\"Xm\u001d;O_N\u0003XmY5gS\u0016$WI\u001c;jif|\u0005\u000f^5p]^KG\u000f\u001b#fg\u000e\u0014\u0018NY3Ce>\\WM]:J]j[\u0015j]!mY><X\r\u001a\u0015\u0003;\u0019\f\u0001\n^3ti:{7\u000b]3dS\u001aLW\rZ#oi&$\u0018p\u00149uS>tw+\u001b;i\t\u0016\u001c8M]5cK\n\u0013xn[3sg&s'i\\8ugR\u0014\u0018\r]*feZ,'/S:BY2|w/\u001a3)\u0005y1\u0017a\u0007;fgR$Um]2sS\n,\u0017\t\u001c7Ce>\\WM]\"p]\u001aLw\r\u000b\u0002 M\u0006QB/Z:u\t\u0016\u001c8M]5cK\u0006cG\u000eV8qS\u000e\u001cuN\u001c4jO\"\u0012\u0001EZ\u00013i\u0016\u001cH\u000fR3tGJL'-Z!mY\n\u0013xn[3s\u0007>tg-[4C_>$8\u000f\u001e:baN+'O^3s%\u0016\fX/\u001b:fI\"2\u0011EZA \u0003\u0003\n1\b^3ti\u0016sG/\u001b;z\t\u00164\u0017-\u001e7u\u001fB$\u0018n\u001c8XSRDG)Z:de&\u0014WM\u0011:pW\u0016\u0014Hj\\4hKJL5OT8u\u00032dwn^3eQ\u0019\u0011c-a\u0010\u0002B\u0005AD/Z:u\u000b:$\u0018\u000e^=EK\u001a\fW\u000f\u001c;PaRLwN\\,ji\"\fE\u000e^3s\u0005J|7.\u001a:M_\u001e<WM]%t\u001d>$\u0018\t\u001c7po\u0016$\u0007FB\u0012g\u0003\u007f\t\t%A&tQ>,H\u000e\u001a*bSN,\u0017J\u001c<bY&$7i\u001c8gS\u001e,(/\u0019;j_:,\u0005pY3qi&|gn\u00165f]\u0006#G-\u001b8h\u0013:4\u0018\r\\5e\u0005J|7.\u001a:M_\u001e<WM]\"p]\u001aLw\r\u000b\u0004%M\u0006}\u0012\u0011V\u0012\u0003\u0003W\u0003B!!,\u0002>6\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019,\u0001\u0004feJ|'o\u001d\u0006\u0005\u0003k\u000b9,\u0001\u0004d_6lwN\u001c\u0006\u0004\u0015\u0006e&bAA^U\u00061\u0011\r]1dQ\u0016LA!a0\u00020\ni\u0012J\u001c<bY&$7i\u001c8gS\u001e,(/\u0019;j_:,\u0005pY3qi&|g.A\u0012tQ>,H\u000eZ!eI\u0012+g-Y;mi\n\u0013xn[3s\tft\u0017-\\5d\u0007>tg-[4)\u0005\u00152\u0017a\u0006<fe&4\u00170\u00117uKJ\u0014%o\\6fe\u000e{gNZ5h)\u001dy\u0016\u0011ZAk\u00033Dq!a3'\u0001\u0004\ti-\u0001\u0003o_\u0012,\u0007\u0003BAh\u0003#l!!a-\n\t\u0005M\u00171\u0017\u0002\u0005\u001d>$W\r\u0003\u0004\u0002X\u001a\u0002\r!_\u0001\re\u0016\u001cx.\u001e:dK:\u000bW.\u001a\u0005\b\u000374\u0003\u0019AAo\u00031\u0011Xm]8ve\u000e,w\n\u001d;t!\u0015\t)%a8z\u0013\u0011\t\t/a\u0015\u0003\t1K7\u000f^\u0001\u001em\u0016\u0014\u0018NZ=BYR,'O\u0011:pW\u0016\u0014Hj\\4hKJ\u001cuN\u001c4jORIq,a:\u0002j\u0006-\u0018q\u001e\u0005\b\u0003\u0017<\u0003\u0019AAg\u0011\u0019\t9n\na\u0001s\"1\u0011Q^\u0014A\u0002e\f!\"\u001a8uSRLh*Y7f\u0011\u001d\t\tp\na\u0001\u0003g\fQ\u0003Z3tGJL'-Z\"p]\u001aLw-\u00128ue&,7\u000f\u0005\u0004\u0002F\u0005}\u0017Q\u001f\t\u0005\u0003o\fy0\u0004\u0002\u0002z*\u0019\u0001*a?\u000b\t\u0005u\u0018qW\u0001\bG2LWM\u001c;t\u0013\u0011\u0011\t!!?\u0003\u0017\r{gNZ5h\u000b:$(/_\u00010g\"|W\u000f\u001c3TkB\u0004xN\u001d;D_6l\u0017mU3qCJ\fG/\u001a3WC2,Xm]+tS:<'l\\8lK\u0016\u0004XM\u001d\u0015\u0003Q\u0019\fah\u001d5pk2$gj\u001c;Va\u0012\fG/\u001a\"s_.,'oQ8oM&<\u0017JZ'bY\u001a|'/\\3e\u000b:$\u0018\u000e^=OC6,Wk]5oOj{wn[3fa\u0016\u0014\bFB\u0015g\u0003\u007f\t\t%\u0001\u0019tQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ%g\u001b\u0006dgm\u001c:nK\u0012,e\u000e^5us:\u000bW.\u001a\u0015\u0007U\u0019\fy$!\u0011\u0002WQ,7\u000f\u001e#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<W\u000b\u001d3bi\u0016,6/\u001b8h5>|7*Z3qKJD#a\u000b4\u0002uMDw.\u001e7e\u001d>$X\u000b\u001d3bi\u0016\u0014%o\\6fe\u000e{gNZ5h\u0013\u001al\u0015\r\u001c4pe6,GmQ8oM&<Wk]5oOj{wn[3fa\u0016\u0014\bF\u0002\u0017g\u0003\u007f\t\t%\u0001\u0017tQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ%g\u001b\u0006dgm\u001c:nK\u0012\u001cuN\u001c4jO\"2QFZA \u0003\u0003\n\u0011i\u001d5pk2$gj\u001c;Va\u0012\fG/\u001a\"s_.,'oQ8oM&<\u0017JZ'bY\u001a|'/\\3e\u0005J\f7m[3u\u0007>tg-[4Vg&twMW8pW\u0016,\u0007/\u001a:)\r92\u0017qHA!\u0003M\u001a\bn\\;mI:{G/\u00169eCR,'I]8lKJ\u001cuN\u001c4jO&3W*\u00197g_JlW\r\u001a\"sC\u000e\\W\r^\"p]\u001aLw\r\u000b\u00040M\u0006}\u0012\u0011I\u0001?g\"|W\u000f\u001c3O_R,\u0006\u000fZ1uK\u000e{gNZ5h\u0013\u001atuN\\#ySN$\u0018N\\4D_:4\u0017nZ%t\t\u0016dW\r^3e+NLgn\u001a.p_.,\u0007/\u001a:)\rA2\u0017qHAU\u0003E\u001a\bn\\;mI:{G/\u00169eCR,7i\u001c8gS\u001eLeMT8o\u000bbL7\u000f^5oO\u000e{gNZ5h\u0013N$U\r\\3uK\u0012Dc!\r4\u0002@\u0005%\u0016\u0001G:i_VdG\rR3mKR,'I]8lKJ\u001cuN\u001c4jO\"\u0012!GZ\u0001\u0015i\u0016\u001cHoU2sC6\u001c%/\u001a3f]RL\u0017\r\\:)\u0005M2\u0017!\u0006;fgR\fVo\u001c;b\u0007>tg-[4F]RLG/\u001f\u0015\u0003i\u0019\fq\u0003^3tiV\u001bXM]\"mS\u0016tG/U;pi\u0006|\u0005\u000f^:)\u0005U2\u0017!\u0007;fgR\fVo\u001c;b\t\u0016\u001c8M]5cK\u0016sG/\u001b;jKND#A\u000e4\u0002%I,w-[:uKJ\u0014%o\\6fe&s'l\u001b\u000b\u0004?\n\r\u0003b\u0002B#o\u0001\u0007!qI\u0001\u0003S\u0012\u00042\u0001\u0019B%\u0013\r\u0011Y%\u0019\u0002\u0004\u0013:$(A\u0005#v[6L\u0018\tZ7j]j[7\t\\5f]R\u001c2\u0001\u000fB)!\rq%1K\u0005\u0004\u0005+z%!D!e[&t'l[\"mS\u0016tG/\u0001\u0005{W\u000ec\u0017.\u001a8u!\rq%1L\u0005\u0004\u0005;z%!D&bM.\f'l[\"mS\u0016tG\u000f\u0006\u0003\u0003b\t\u0015\u0004c\u0001B2q5\t\u0001\u0001C\u0004\u0003Xi\u0002\rA!\u0017\u0002%\rD\u0017M\\4f\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\u0006?\n-$1\u0010\u0005\b\u0005[Z\u0004\u0019\u0001B8\u0003%\u0011'o\\6fe&#7\u000f\u0005\u0004\u0003r\t]$qI\u0007\u0003\u0005gR1A!\u001eb\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005s\u0012\u0019HA\u0002TKFDqA! <\u0001\u0004\u0011y(A\u0004d_:4\u0017nZ:\u0011\t\t\u0005%1R\u0007\u0003\u0005\u0007SAA!\"\u0003\b\u0006!Q\u000f^5m\u0015\t\u0011I)\u0001\u0003kCZ\f\u0017\u0002\u0002BG\u0005\u0007\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003E1W\r^2i\u000b:$\u0018\u000e^=D_:4\u0017n\u001a\u000b\u0007\u0005\u007f\u0012\u0019J!&\t\r\u0005-B\b1\u0001z\u0011\u0019\ti\u000f\u0010a\u0001s\u0006!2\r[1oO\u0016\u001cE.[3oi&#7i\u001c8gS\u001e$Ra\u0018BN\u0005?CaA!(>\u0001\u0004I\u0018\u0001C2mS\u0016tG/\u00133\t\u000f\tuT\b1\u0001\u0003\u0000\u0005q2\r[1oO\u0016,6/\u001a:PeV\u001bXM]\"mS\u0016tG/\u00133D_:4\u0017n\u001a\u000b\u0006?\n\u0015&\u0011\u0016\u0005\u0007\u0005Os\u0004\u0019A=\u0002'M\fg.\u001b;ju\u0016$WI\u001c;jift\u0015-\\3\t\u000f\tud\b1\u0001\u0003\u0000\u0005\t2\r[1oO\u0016$v\u000e]5d\u0007>tg-[4\u0015\u000b}\u0013yKa-\t\r\tEv\b1\u0001z\u0003\u0015!x\u000e]5d\u0011\u001d\u0011ih\u0010a\u0001\u0005\u007f\u0012\u0001\u0003R;n[f\fE-\\5o\u00072LWM\u001c;\u0014\u0007\u0001\u0013I\f\u0005\u0003\u0002x\nm\u0016\u0002\u0002B_\u0003s\u0014q\"T8dW\u0006#W.\u001b8DY&,g\u000e\u001e\u000b\u0005\u0005\u0003\u0014\u0019\rE\u0002\u0003d\u0001Cq!a3C\u0001\u0004\ti-A\beKN\u001c'/\u001b2f\u0007>tg-[4t)\u0019\u0011IMa4\u0003fB!\u0011q\u001fBf\u0013\u0011\u0011i-!?\u0003+\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014Vm];mi\"9!\u0011[\"A\u0002\tM\u0017!\u0003:fg>,(oY3t!\u0019\u0011\tI!6\u0003Z&!!q\u001bBB\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0005\u00057\u0014\t/\u0004\u0002\u0003^*!!q\\AZ\u0003\u0019\u0019wN\u001c4jO&!!1\u001dBo\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016DqAa:D\u0001\u0004\u0011I/A\u0004paRLwN\\:\u0011\t\u0005](1^\u0005\u0005\u0005[\fIP\u0001\fEKN\u001c'/\u001b2f\u0007>tg-[4t\u001fB$\u0018n\u001c8t\u0003]Ign\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7\u000f\u0006\u0004\u0003t\ne8\u0011\u0002\t\u0005\u0003o\u0014)0\u0003\u0003\u0003x\u0006e(AE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z:vYRDqA! E\u0001\u0004\u0011Y\u0010\u0005\u0005\u0003\u0002\nu(\u0011\\B\u0001\u0013\u0011\u0011yPa!\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u0003\u0002\nU71\u0001\t\u0005\u0003o\u001c)!\u0003\u0003\u0004\b\u0005e(!D!mi\u0016\u00148i\u001c8gS\u001e|\u0005\u000fC\u0004\u0003h\u0012\u0003\raa\u0003\u0011\t\u0005]8QB\u0005\u0005\u0007\u001f\tIPA\nBYR,'oQ8oM&<7o\u00149uS>t7/\u0001\u0007bYR,'oQ8oM&<7\u000f\u0006\u0004\u0003t\u000eU1q\u0004\u0005\b\u0005{*\u0005\u0019AB\f!!\u0011\tI!@\u0003Z\u000ee\u0001\u0003BA|\u00077IAa!\b\u0002z\n11i\u001c8gS\u001eDqAa:F\u0001\u0004\u0019Y\u0001")
public class ConfigCommandTest
extends ZooKeeperTestHarness {
    @Test
    public void shouldExitWithNonZeroStatusOnArgError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--blah"}));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnZkCommandError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "security.inter.broker.protocol=PLAINTEXT"}));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnBrokerCommandError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--bootstrap-server", "invalid host", "--entity-type", "brokers", "--entity-name", "1", "--describe"}));
    }

    /*
     * WARNING - void declaration
     */
    private void assertNonZeroStatusExit(String[] args) {
        void setExitProcedure_exitProcedure;
        ObjectRef exitStatus = ObjectRef.create((Object)None$.MODULE$);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(status, x$1) -> ConfigCommandTest.$anonfun$assertNonZeroStatusExit$1(exitStatus, BoxesRunTime.unboxToInt((Object)status), x$1);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            try {
                ConfigCommand$.MODULE$.main(args);
            }
            catch (RuntimeException runtimeException) {}
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((Option)exitStatus.elem));
    }

    @Test
    public void shouldParseArgumentsForClientsEntityTypeUsingZookeeper() {
        this.testArgumentParse("clients", true);
    }

    @Test
    public void shouldParseArgumentsForUsersEntityTypeUsingZookeeper() {
        this.testArgumentParse("clients", true);
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityTypeUsingZookeeper() {
        this.testArgumentParse("topics", true);
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityType() {
        this.testArgumentParse("topics", false);
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityTypeUsingZookeeper() {
        this.testArgumentParse("brokers", true);
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityType() {
        this.testArgumentParse("brokers", false);
    }

    @Test
    public void shouldParseArgumentsForBrokerLoggersEntityType() {
        this.testArgumentParse("broker-loggers", false);
    }

    public void testArgumentParse(String entityType, boolean zkConfig) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        String shortFlag = new StringBuilder(2).append("--").append(new StringOps(entityType).dropRight(1)).toString();
        Tuple2 connectOpts = zkConfig ? new Tuple2((Object)"--zookeeper", (Object)this.zkConnect()) : new Tuple2((Object)"--bootstrap-server", (Object)"localhost:9092");
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--describe"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--describe"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=d"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--delete-config", "a,b,c"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--delete-config", "a,b,c"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"}));
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)2L, (long)addedProps.size());
        Assert.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assert.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Seq deletedProps = ConfigCommand$.MODULE$.parseConfigsToBeDeleted(createOpts);
        Assert.assertEquals((long)1L, (long)deletedProps.size());
        Assert.assertEquals((Object)"a", (Object)deletedProps.head());
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=,d=e,f="}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=,d=e,f="}));
        createOpts.checkArgs();
        Properties addedProps2 = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)4L, (long)addedProps2.size());
        Assert.assertEquals((Object)"b", (Object)addedProps2.getProperty("a"));
        Assert.assertEquals((Object)"e", (Object)addedProps2.getProperty("d"));
        Assert.assertTrue((boolean)addedProps2.getProperty("c").isEmpty());
        Assert.assertTrue((boolean)addedProps2.getProperty("f").isEmpty());
    }

    @Test
    public void testOptionEntityTypeNames() {
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Topic(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "topics", "--entity-name", "A"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"0", (List)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "0", "--entity-type", "brokers"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"A", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients", "--entity-name", "A", "--entity-default"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-default", "--entity-name", "B", "--entity-type", "users", "--entity-type", "clients"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Topic(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", "A"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"0", (List)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--broker", "0"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"B", (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--client", "B", "--user", "A"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"B", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--client", "B", "--user-defaults"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--entity-name", "A"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Topic(), (List)Nil$.MODULE$), List$.MODULE$.empty(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "topics"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$), List$.MODULE$.empty(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)Nil$.MODULE$), List$.MODULE$.empty(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "brokers"}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityTypeUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityType() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfBrokerEntityTypeIsNotAnIntegerUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "A", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfBrokerEntityTypeIsNotAnInteger() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "A", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfShortBrokerEntityTypeIsNotAnIntegerUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--broker", "A", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfShortBrokerEntityTypeIsNotAnInteger() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--broker", "A", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfMixedEntityTypeFlagsUsingZookeeper() {
        new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "A", "--entity-type", "users", "--client", "B", "--describe"})).checkArgs();
    }

    @Test
    public void shouldAddClientConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-client-id", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$1
        extends AdminZkClient {
            public void changeClientIdConfig(String clientId, Properties configChange) {
                Assert.assertEquals((Object)"my-client-id", (Object)clientId);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(null, this.zkClient()));
    }

    @Test
    public void shouldAddTopicConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=d"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$2
        extends AdminZkClient {
            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(null, this.zkClient()));
    }

    @Test
    public void shouldAlterTopicConfig() {
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--alter", "--add-config", "delete.retention.ms=1000000,min.insync.replicas=2", "--delete-config", "unclean.leader.election.enable"}));
        BooleanRef alteredConfigs = BooleanRef.create((boolean)false);
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        java.util.List configEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("min.insync.replicas", "1"), (List)new .colon.colon((Object)ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("unclean.leader.election.enable", "1"), (List)Nil$.MODULE$))).asJava();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(this, node, resourceName, describeResult, alteredConfigs, alterResult){
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String resourceName$1;
            private final DescribeConfigsResult describeResult$1;
            private final BooleanRef alteredConfigs$1;
            private final AlterConfigsResult alterResult$1;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertFalse((String)"Config synonyms requested unnecessarily", (boolean)options.includeSynonyms());
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)resource.type(), (Object)ConfigResource.Type.TOPIC);
                Assert.assertEquals((Object)resource.name(), (Object)this.resourceName$1);
                return this.describeResult$1;
            }

            public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Collection<AlterConfigOp> alterConfigOps = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.TOPIC, (Object)resource.type());
                Assert.assertEquals((long)3L, (long)alterConfigOps.size());
                Assert.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("delete.retention.ms", "1000000"), AlterConfigOp.OpType.SET), new AlterConfigOp(ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("min.insync.replicas", "2"), AlterConfigOp.OpType.SET), new AlterConfigOp(ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("unclean.leader.election.enable", ""), AlterConfigOp.OpType.DELETE)}))), (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(alterConfigOps).asScala()).toSet());
                this.alteredConfigs$1.elem = true;
                return this.alterResult$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resourceName$1 = resourceName$1;
                this.describeResult$1 = describeResult$1;
                this.alteredConfigs$1 = alteredConfigs$1;
                this.alterResult$1 = alterResult$1;
                super(Collections.singletonList(node$1), node$1);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        Assert.assertTrue((boolean)alteredConfigs.elem);
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldDescribeConfigSynonyms() {
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--describe", "--all"}));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(Collections.emptyList())));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resource, describeResult){
            private final ConfigResource resource$1;
            private final DescribeConfigsResult describeResult$2;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertTrue((String)"Synonyms not requested", (boolean)options.includeSynonyms());
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{this.resource$1})), (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(resources).asScala()).toSet());
                return this.describeResult$2;
            }
            {
                this.resource$1 = resource$1;
                this.describeResult$2 = describeResult$2;
                super(Collections.singletonList(node$2), node$2);
            }
        };
        EasyMock.replay((Object[])new Object[]{describeResult});
        ConfigCommand$.MODULE$.describeConfig((Admin)mockAdminClient, describeOpts);
        EasyMock.reset((Object[])new Object[]{describeResult});
    }

    @Test
    public void shouldAddBrokerQuotaConfig() {
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10,follower.replication.throttled.rate=20"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$3
        extends AdminZkClient {
            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"10", (Object)configChange.get("leader.replication.throttled.rate"));
                Assert.assertEquals((Object)"20", (Object)configChange.get("follower.replication.throttled.rate"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, alterOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(null, this.zkClient()));
    }

    @Test
    public void shouldAddBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "1", (List<String>)new .colon.colon((Object)"--entity-name", (List)new .colon.colon((Object)"1", (List)Nil$.MODULE$)));
    }

    @Test
    public void shouldAddBrokerLoggerConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerLoggerConfig(node, "1", "1", (List<ConfigEntry>)new .colon.colon((Object)new ConfigEntry("kafka.log.LogCleaner", "INFO"), (List)new .colon.colon((Object)new ConfigEntry("kafka.server.ReplicaManager", "INFO"), (List)new .colon.colon((Object)new ConfigEntry("kafka.server.KafkaApi", "INFO"), (List)Nil$.MODULE$))));
    }

    @Test
    public void testNoSpecifiedEntityOptionWithDescribeBrokersInZKIsAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--zookeeper", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$)))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testNoSpecifiedEntityOptionWithDescribeBrokersInBootstrapServerIsAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$)))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testDescribeAllBrokerConfig() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigType$.MODULE$.Broker(), "--entity-name", "1", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testDescribeAllTopicConfig() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigType$.MODULE$.Topic(), "--entity-name", "foo", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDescribeAllBrokerConfigBootstrapServerRequired() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", ConfigType$.MODULE$.Broker(), "--entity-name", "1", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntityDefaultOptionWithDescribeBrokerLoggerIsNotAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigCommand$.MODULE$.BrokerLoggerConfigType(), (List)new .colon.colon((Object)"--entity-default", (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$))))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntityDefaultOptionWithAlterBrokerLoggerIsNotAllowed() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand$.MODULE$.BrokerLoggerConfigType(), "--entity-default", "--alter", "--add-config", "kafka.log.LogCleaner=DEBUG"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldRaiseInvalidConfigurationExceptionWhenAddingInvalidBrokerLoggerConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerLoggerConfig(node, "1", "1", (List<ConfigEntry>)new .colon.colon((Object)new ConfigEntry("kafka.server.KafkaApi", "INFO"), (List)Nil$.MODULE$));
    }

    @Test
    public void shouldAddDefaultBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "", (List<String>)new .colon.colon((Object)"--entity-default", (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    public void verifyAlterBrokerConfig(Node node, String resourceName, List<String> resourceOpts) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        List optsList = (List)new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)"brokers", (List)new .colon.colon((Object)"--alter", (List)new .colon.colon((Object)"--add-config", (List)new .colon.colon((Object)"message.max.bytes=10", (List)Nil$.MODULE$))))))).$plus$plus(resourceOpts, List$.MODULE$.canBuildFrom());
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = "5";
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"num.io.threads");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        scala.collection.mutable.Map brokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, resourceName);
        java.util.List<ConfigEntry> configEntries = Collections.singletonList(new ConfigEntry("num.io.threads", "5"));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, describeResult, brokerConfigs, alterResult){
            private final String resourceName$2;
            private final DescribeConfigsResult describeResult$3;
            private final scala.collection.mutable.Map brokerConfigs$1;
            private final AlterConfigsResult alterResult$2;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertFalse((String)"Config synonyms requested unnecessarily", (boolean)options.includeSynonyms());
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                Assert.assertEquals((Object)this.resourceName$2, (Object)resource.name());
                return this.describeResult$3;
            }

            public AlterConfigsResult alterConfigs(java.util.Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Config> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Config config = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)e -> $this.brokerConfigs$1.put((Object)e.name(), (Object)e.value()));
                return this.alterResult$2;
            }
            {
                this.resourceName$2 = resourceName$2;
                this.describeResult$3 = describeResult$3;
                this.brokerConfigs$1 = brokerConfigs$1;
                this.alterResult$2 = alterResult$2;
                super(Collections.singletonList(node$3), node$3);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$alterConfigs$1(kafka.admin.ConfigCommandTest$$anon$3 org.apache.kafka.clients.admin.ConfigEntry )}, serializedLambda);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        Tuple2[] tuple2Array2 = new Tuple2[2];
        String string2 = "10";
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"message.max.bytes");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string3 = "5";
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"num.io.threads");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), (Object)brokerConfigs.toMap(Predef$.MODULE$.$conforms()));
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    public void verifyAlterBrokerLoggerConfig(Node node, String resourceName, String entityName, List<ConfigEntry> describeConfigEntries) {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand$.MODULE$.BrokerLoggerConfigType(), "--alter", "--entity-name", entityName, "--add-config", "kafka.log.LogCleaner=DEBUG", "--delete-config", "kafka.server.ReplicaManager,kafka.server.KafkaApi"}));
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        BooleanRef alteredConfigs = BooleanRef.create((boolean)false);
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, resourceName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(describeConfigEntries).asJava())));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, describeResult, alteredConfigs, alterResult){
            private final String resourceName$3;
            private final DescribeConfigsResult describeResult$4;
            private final BooleanRef alteredConfigs$2;
            private final AlterConfigsResult alterResult$3;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER_LOGGER, (Object)resource.type());
                Assert.assertEquals((Object)this.resourceName$3, (Object)resource.name());
                return this.describeResult$4;
            }

            public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Collection<AlterConfigOp> alterConfigOps = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER_LOGGER, (Object)resource.type());
                Assert.assertEquals((long)3L, (long)alterConfigOps.size());
                Assert.assertEquals((Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.log.LogCleaner", "DEBUG"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.ReplicaManager", ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaApi", ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))), (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(alterConfigOps).asScala()).toList());
                this.alteredConfigs$2.elem = true;
                return this.alterResult$3;
            }
            {
                this.resourceName$3 = resourceName$3;
                this.describeResult$4 = describeResult$4;
                this.alteredConfigs$2 = alteredConfigs$2;
                this.alterResult$3 = alterResult$3;
                super(Collections.singletonList(node$4), node$4);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        Assert.assertTrue((boolean)alteredConfigs.elem);
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldSupportCommaSeparatedValuesUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=[d,e ,f],g=[h,i]"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$4
        extends AdminZkClient {
            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d,e ,f", (Object)configChange.get("c"));
                Assert.assertEquals((Object)"h,i", (Object)configChange.get("g"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(null, this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityNameUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityName() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicBrokerConfigUpdateUsingZooKeeper() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_$this9;
        void $minus$greater$extension_y10;
        void $minus$greater$extension_$this10;
        void $minus$greater$extension_y11;
        void $minus$greater$extension_$this11;
        void $minus$greater$extension_y12;
        void $minus$greater$extension_$this12;
        void $minus$greater$extension_y13;
        void $minus$greater$extension_$this13;
        void $minus$greater$extension_y14;
        void $minus$greater$extension_$this14;
        void $minus$greater$extension_y15;
        void $minus$greater$extension_$this15;
        String brokerId = "1";
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        String[] alterOpts = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", "brokers", "--alter"});
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = "110000";
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"message.max.size");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this15, (Object)$minus$greater$extension_y15);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Tuple2[] tuple2Array2 = new Tuple2[1];
        String string2 = "120000";
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"message.max.size");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this14, (Object)$minus$greater$extension_y14);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), (Option)None$.MODULE$, alterOpts, adminZkClient);
        Tuple2[] tuple2Array3 = new Tuple2[1];
        String string3 = "130000";
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"message.max.size");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)$minus$greater$extension_y13);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3)), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Tuple2[] tuple2Array4 = new Tuple2[1];
        String string4 = "140000";
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)"message.max.size");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)$minus$greater$extension_y12);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4)), (Option)None$.MODULE$, alterOpts, adminZkClient);
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"})), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"})), (Option)None$.MODULE$, alterOpts, adminZkClient);
        Tuple2[] tuple2Array5 = new Tuple2[1];
        String string5 = "/tmp/test.jks";
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y11);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5)), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = "/tmp/test.jks";
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = "/tmp/test.jks";
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Option)None$.MODULE$, ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 741));
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.ssl.keystore.location"})), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = "secret";
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.password");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 745));
        Tuple2[] tuple2Array6 = new Tuple2[2];
        String string6 = "secret";
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.password");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array6[0] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y10);
        String string7 = "2";
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.threads");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array6[1] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y9);
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array6));
        Tuple2[] tuple2Array7 = new Tuple2[1];
        String string8 = "encoder-secret";
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array7[0] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        scala.collection.immutable.Map encoderConfigs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array7));
        this.alterConfigWithZk$1(configs, (Option)new Some((Object)brokerId), encoderConfigs, alterOpts, adminZkClient);
        Properties brokerConfigs = this.zkClient().getEntityConfigs("brokers", brokerId);
        Assert.assertFalse((String)"Encoder secret stored in ZooKeeper", (boolean)brokerConfigs.contains(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()));
        Assert.assertEquals((Object)"2", (Object)brokerConfigs.getProperty("log.cleaner.threads"));
        String encodedPassword = brokerConfigs.getProperty("listener.name.external.ssl.keystore.password");
        PasswordEncoder passwordEncoder = ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs);
        Assert.assertEquals((Object)"secret", (Object)passwordEncoder.decode(encodedPassword).value());
        Assert.assertEquals((long)configs.size(), (long)brokerConfigs.size());
        Tuple2[] tuple2Array8 = new Tuple2[1];
        String string9 = "secret2";
        Object object9 = Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.ssl.keystore.password");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array8[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        scala.collection.immutable.Map configs2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array8));
        Tuple2[] tuple2Array9 = new Tuple2[5];
        String string10 = "encoder-secret";
        Object object10 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array9[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        String string11 = "DES/CBC/PKCS5Padding";
        Object object11 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array9[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        String string12 = "1024";
        Object object12 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderIterationsProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array9[2] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        String string13 = "PBKDF2WithHmacSHA1";
        Object object13 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyFactoryAlgorithmProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array9[3] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string14 = "64";
        Object object14 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array9[4] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        scala.collection.immutable.Map encoderConfigs2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array9));
        this.alterConfigWithZk$1(configs2, (Option)new Some((Object)brokerId), encoderConfigs2, alterOpts, adminZkClient);
        String encodedPassword2 = this.zkClient().getEntityConfigs("brokers", brokerId).getProperty("listener.name.internal.ssl.keystore.password");
        Assert.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs).decode(encodedPassword2).value());
        Assert.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs2).decode(encodedPassword2).value());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterConfigWithZk$1(configs, (Option)None$.MODULE$, encoderConfigs, alterOpts, adminZkClient), ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 774));
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.registerBrokerInZk(new StringOps(brokerId).toInt());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = "210000";
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"message.max.size");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = "220000";
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"message.max.size");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Option)None$.MODULE$, ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
        Tuple2[] tuple2Array10 = new Tuple2[1];
        String string15 = "230000";
        Object object15 = Predef$.MODULE$.ArrowAssoc((Object)"message.max.size");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array10[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array10)), (Option)new Some((Object)"2"), alterOpts, adminZkClient);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=="}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=="}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldNotUpdateConfigIfNonExistingConfigIsDeletedUsingZookeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldNotUpdateConfigIfNonExistingConfigIsDeleted() {
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"}));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        java.util.List configEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, describeResult){
            private final String resourceName$4;
            private final DescribeConfigsResult describeResult$5;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)resource.type(), (Object)ConfigResource.Type.TOPIC);
                Assert.assertEquals((Object)resource.name(), (Object)this.resourceName$4);
                return this.describeResult$5;
            }
            {
                this.resourceName$4 = resourceName$4;
                this.describeResult$5 = describeResult$5;
                super(Collections.singletonList(node$5), node$5);
            }
        };
        EasyMock.replay((Object[])new Object[]{describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, createOpts);
        EasyMock.reset((Object[])new Object[]{describeResult});
    }

    @Test
    public void shouldDeleteBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--delete-config", "a,c"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$5
        extends AdminZkClient {
            /*
             * WARNING - void declaration
             */
            public Properties fetchEntityConfig(String entityType, String entityName) {
                void var3_3;
                Properties properties = new Properties();
                properties.put("a", "b");
                properties.put("c", "d");
                properties.put("e", "f");
                return var3_3;
            }

            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)"f", (Object)configChange.get("e"));
                Assert.assertEquals((long)1L, (long)configChange.size());
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(null, this.zkClient()));
    }

    @Test
    public void testScramCredentials() {
        LazyRef CredentialChange$module = new LazyRef();
        scala.collection.mutable.Map credentials = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ConfigCommand.ConfigCommandOptions optsA = this.createOpts$1("userA", "SCRAM-SHA-256=[iterations=8192,password=abc, def]");
        public class Kafka_admin_ConfigCommandTest$CredentialChange$1
        extends AdminZkClient
        implements Product,
        scala.Serializable {
            private final String user;
            private final Set<String> mechanisms;
            private final int iterations;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final scala.collection.mutable.Map credentials$1;

            public String user() {
                return this.user;
            }

            public Set<String> mechanisms() {
                return this.mechanisms;
            }

            public int iterations() {
                return this.iterations;
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return (Properties)this.credentials$1.getOrElse((Object)entityName, (Function0 & Serializable & scala.Serializable)() -> new Properties());
            }

            public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configChange) {
                Assert.assertEquals((Object)this.user(), (Object)sanitizedEntityName);
                Assert.assertEquals(this.mechanisms(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(configChange.keySet()).asScala());
                this.mechanisms().foreach((Function1 & Serializable & scala.Serializable)mechanism -> {
                    String value = configChange.getProperty((String)mechanism);
                    Assert.assertEquals((long)-1L, (long)value.indexOf("password="));
                    ScramCredential scramCredential = ScramCredentialUtils.credentialFromString((String)value);
                    Assert.assertEquals((long)this.iterations(), (long)scramCredential.iterations());
                    return $this.credentials$1.put((Object)this.user(), (Object)configChange);
                });
            }

            public Kafka_admin_ConfigCommandTest$CredentialChange$1 copy(String user, Set<String> mechanisms, int iterations) {
                return new Kafka_admin_ConfigCommandTest$CredentialChange$1(this.$outer, user, mechanisms, iterations, this.credentials$1);
            }

            public String copy$default$1() {
                return this.user();
            }

            public Set<String> copy$default$2() {
                return this.mechanisms();
            }

            public int copy$default$3() {
                return this.iterations();
            }

            public String productPrefix() {
                return "CredentialChange";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                switch (x$1) {
                    case 0: {
                        return this.user();
                    }
                    case 1: {
                        return this.mechanisms();
                    }
                    case 2: {
                        return BoxesRunTime.boxToInteger((int)this.iterations());
                    }
                }
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$1;
            }

            public int hashCode() {
                return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.user())), (int)Statics.anyHash(this.mechanisms())), (int)this.iterations()), (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                if (!(x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$1)) return false;
                boolean bl = true;
                if (!bl) return false;
                Kafka_admin_ConfigCommandTest$CredentialChange$1 var3_3 = (Kafka_admin_ConfigCommandTest$CredentialChange$1)((Object)x$1);
                String string = this.user();
                String string2 = var3_3.user();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Set<String> set = this.mechanisms();
                Set<String> set2 = var3_3.mechanisms();
                if (set == null) {
                    if (set2 != null) {
                        return false;
                    }
                } else if (!set.equals(set2)) return false;
                if (this.iterations() != var3_3.iterations()) return false;
                if (!var3_3.canEqual((Object)((Object)this))) return false;
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_admin_ConfigCommandTest$CredentialChange$1(String user, Set<String> mechanisms, int iterations) {
                void var5_5;
                this.user = user;
                this.mechanisms = mechanisms;
                this.iterations = iterations;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.credentials$1 = var5_5;
                super($outer.zkClient());
                Product.$init$((Product)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fetchEntityConfig$1(), $anonfun$changeUserOrUserClientIdConfig$1(kafka.admin.ConfigCommandTest$CredentialChange$1 java.util.Properties java.lang.String )}, serializedLambda);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, optsA, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userA", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"}))), 8192));
        ConfigCommand.ConfigCommandOptions optsB = this.createOpts$1("userB", "SCRAM-SHA-256=[iterations=4096,password=abc, def],SCRAM-SHA-512=[password=1234=abc]");
        ConfigCommand$.MODULE$.alterConfigWithZk(null, optsB, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256", "SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del256 = this.deleteOpts$1("userB", "SCRAM-SHA-256");
        ConfigCommand$.MODULE$.alterConfigWithZk(null, del256, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del512 = this.deleteOpts$1("userB", "SCRAM-SHA-512");
        ConfigCommand$.MODULE$.alterConfigWithZk(null, del512, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), 4096));
    }

    @Test
    public void testQuotaConfigEntity() {
        String[] describeOpts = (String[])((Object[])new String[]{"--describe"});
        String[] alterOpts = (String[])((Object[])new String[]{"--alter", "--add-config", "a=b,c=d"});
        String clientId = "client-1";
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$1(this, clientId, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("clients", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("clients", (Option)None$.MODULE$, alterOpts);
        String principal = "CN=ConfigCommandTest,O=Apache,L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        Assert.assertEquals((long)-1L, (long)sanitizedPrincipal.indexOf(61));
        Assert.assertEquals((Object)principal, (Object)Sanitizer.desanitize((String)sanitizedPrincipal));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$2(this, principal, sanitizedPrincipal, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("users", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, alterOpts);
        String userClient = new StringBuilder(9).append(sanitizedPrincipal).append("/clients/").append(clientId).toString();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$3(this, principal, userClient, clientId, sanitizedPrincipal, describeOpts, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("users", (Option)new Some((Object)principal), new StringBuilder(8).append(sanitizedPrincipal).append("/clients").toString(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)new Some((Object)principal), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    @Test
    public void testUserClientQuotaOpts() {
        this.checkEntity$2("users", Sanitizer.sanitize((String)"<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("clients", Sanitizer.sanitize((String)"<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "CN=user1", "--entity-type", "clients", "--entity-name", "client1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "CN=user1", "--entity-type", "users", "--entity-name", "client1", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "client1", "--entity-type", "users", "--entity-name", "CN=user1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(8).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", "/clients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", new StringBuilder(9).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/").append(Sanitizer.sanitize((String)"client1?@%")).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1?@%", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaDescribeEntities() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        String clientId = "a-client";
        String principal = "CN=ConfigCommandTest.testQuotaDescribeEntities , O=Apache, L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        String userClient = new StringBuilder(9).append(sanitizedPrincipal).append("/clients/").append(clientId).toString();
        String[] opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", clientId});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients"});
        Tuple2[] tuple2Array = new Tuple2[1];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"clients");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users"});
        Tuple2[] tuple2Array2 = new Tuple2[1];
        GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"users");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-name", clientId});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{userClient})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(18).append(sanitizedPrincipal).append("/clients/<default>").toString()})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients"});
        Tuple2[] tuple2Array3 = new Tuple2[1];
        GenTraversable genTraversable3 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-4"}));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(14).append("users/").append(sanitizedPrincipal).append("/clients").toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(17).append(sanitizedPrincipal).append("/clients/client-4").toString()})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default", "--entity-type", "clients"});
        Tuple2[] tuple2Array4 = new Tuple2[1];
        GenTraversable genTraversable4 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-5"}));
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-5"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients"});
        Tuple2[] tuple2Array5 = new Tuple2[1];
        GenTraversable genTraversable5 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-2"}));
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(14).append("users/").append(sanitizedPrincipal).append("/clients").toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        scala.collection.immutable.Map userMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5));
        Tuple2[] tuple2Array6 = new Tuple2[1];
        GenTraversable genTraversable6 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-3"}));
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array6[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        scala.collection.immutable.Map defaultUserMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array6));
        Tuple2[] tuple2Array7 = new Tuple2[1];
        GenTraversable genTraversable7 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal}));
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)"users");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array7[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ConfigCommandTest.checkEntities$1(opts, ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array7))).$plus$plus((GenTraversableOnce)defaultUserMap).$plus$plus((GenTraversableOnce)userMap), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-3", new StringBuilder(17).append(sanitizedPrincipal).append("/clients/client-2").toString()})), zkClient);
    }

    private void registerBrokerInZk(int id) {
        this.zkClient().createTopLevelPaths();
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        EndPoint endpoint = new EndPoint("localhost", 9092, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
        BrokerInfo brokerInfo = BrokerInfo$.MODULE$.apply(new Broker(id, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$), ApiVersion$.MODULE$.latestVersion(), 9192);
        this.zkClient().registerBroker(brokerInfo);
    }

    public static final /* synthetic */ Nothing$ $anonfun$assertNonZeroStatusExit$1(ObjectRef exitStatus$1, int status, Option x$1) {
        exitStatus$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)status));
        throw new RuntimeException();
    }

    private final void testExpectedEntityTypeNames$1(List expectedTypes, List expectedNames, Seq args) {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--zookeeper", this.zkConnect(), "--describe"})).$plus$plus((GenTraversableOnce)args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        createOpts.checkArgs();
        Assert.assertEquals((Object)createOpts.entityTypes(), (Object)expectedTypes);
        Assert.assertEquals((Object)createOpts.entityNames(), (Object)expectedNames);
    }

    public static final ConfigEntry kafka$admin$ConfigCommandTest$$newConfigEntry$1(String name, String value) {
        return ConfigTest.newConfigEntry((String)name, (String)value, (ConfigEntry.ConfigSource)ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG, (boolean)false, (boolean)false, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava()));
    }

    public static final /* synthetic */ String[] $anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$1(String id) {
        return (String[])((Object[])new String[]{"--entity-name", id});
    }

    public static final /* synthetic */ String[] $anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$2() {
        return (String[])((Object[])new String[]{"--entity-default"});
    }

    private static final String[] entityOpt$1(Option brokerId) {
        if (brokerId == null) {
            throw null;
        }
        Object object = brokerId.isEmpty() ? None$.MODULE$ : new Some((Object)ConfigCommandTest.$anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$1((String)brokerId.get()));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? ConfigCommandTest.$anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$2() : object.get();
        return object2;
    }

    private final void alterConfigWithZk$1(scala.collection.immutable.Map configs, Option brokerId, scala.collection.immutable.Map encoderConfigs, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        String configStr = ((TraversableOnce)configs.$plus$plus((GenTraversableOnce)encoderConfigs).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        ConfigCommand.ConfigCommandOptions addOpts = new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.entityOpt$1(brokerId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--add-config", configStr})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        ConfigCommand$.MODULE$.alterConfigWithZk(this.zkClient(), addOpts, adminZkClient$1);
    }

    private static final scala.collection.immutable.Map alterConfigWithZk$default$3$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private final void verifyConfig$1(scala.collection.immutable.Map configs, Option brokerId) {
        if (brokerId == null) {
            throw null;
        }
        Object object = brokerId.isEmpty() ? ConfigEntityName$.MODULE$.Default() : brokerId.get();
        Properties entityConfigs = this.zkClient().getEntityConfigs("brokers", (String)object);
        Assert.assertEquals((Object)configs, (Object)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(entityConfigs).asScala());
    }

    private final void alterAndVerifyConfig$1(scala.collection.immutable.Map configs, Option brokerId, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        this.alterConfigWithZk$1(configs, brokerId, ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts$1, adminZkClient$1);
        this.verifyConfig$1(configs, brokerId);
    }

    private final void deleteAndVerifyConfig$1(Set configNames, Option brokerId, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        ConfigCommand.ConfigCommandOptions deleteOpts = new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.entityOpt$1(brokerId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--delete-config", configNames.mkString(",")})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        ConfigCommand$.MODULE$.alterConfigWithZk(this.zkClient(), deleteOpts, adminZkClient$1);
        this.verifyConfig$1(Predef$.MODULE$.Map().empty(), brokerId);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$1(String user, String config) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--add-config", config}));
    }

    private final ConfigCommand.ConfigCommandOptions deleteOpts$1(String user, String mechanism) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--delete-config", mechanism}));
    }

    private final /* synthetic */ ConfigCommandTest$CredentialChange$2$ CredentialChange$lzycompute$1(LazyRef CredentialChange$module$1, scala.collection.mutable.Map credentials$1) {
        synchronized (CredentialChange$module$1) {
            ConfigCommandTest$CredentialChange$2$ configCommandTest$CredentialChange$2$ = CredentialChange$module$1.initialized() ? (ConfigCommandTest$CredentialChange$2$)((Object)CredentialChange$module$1.value()) : (ConfigCommandTest$CredentialChange$2$)((Object)CredentialChange$module$1.initialize((Object)new ConfigCommandTest$CredentialChange$2$(this, credentials$1)));
            return configCommandTest$CredentialChange$2$;
        }
    }

    private final ConfigCommandTest$CredentialChange$2$ CredentialChange$3(LazyRef CredentialChange$module$1, scala.collection.mutable.Map credentials$1) {
        if (CredentialChange$module$1.initialized()) {
            return (ConfigCommandTest$CredentialChange$2$)((Object)CredentialChange$module$1.value());
        }
        return this.CredentialChange$lzycompute$1(CredentialChange$module$1, credentials$1);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$2(String entityType, Option entityName, String[] otherArgs) {
        String[] stringArray;
        String[] optArray = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", entityType});
        if (entityName instanceof Some) {
            String name = (String)((Some)entityName).value();
            stringArray = (String[])((Object[])new String[]{"--entity-name", name});
        } else if (None$.MODULE$.equals(entityName)) {
            stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new MatchError((Object)entityName);
        }
        return new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])optArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])otherArgs)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private final void checkEntity$1(String entityType, Option entityName, String expectedEntityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)entityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkInvalidEntity$1(String entityType, Option entityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        try {
            opts.checkArgs();
            ConfigCommand$.MODULE$.parseEntity(opts);
            Assert.fail((String)"Did not fail with invalid argument list");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$1(ConfigCommandTest $this, String clientId$1, String[] opts) {
        $this.checkEntity$1("clients", (Option)new Some((Object)clientId$1), clientId$1, opts);
        $this.checkEntity$1("clients", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$2(ConfigCommandTest $this, String principal$1, String sanitizedPrincipal$1, String[] opts) {
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), sanitizedPrincipal$1, opts);
        $this.checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
    }

    private static final String[] clientIdOpts$1(String name) {
        return (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", name});
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$3(ConfigCommandTest $this, String principal$1, String userClient$1, String clientId$1, String sanitizedPrincipal$1, String[] describeOpts$1, String[] opts) {
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), userClient$1, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), new StringBuilder(9).append(sanitizedPrincipal$1).append("/clients/").append(ConfigEntityName$.MODULE$.Default()).toString(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(""))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder(9).append(ConfigEntityName$.MODULE$.Default()).append("/clients/").append(clientId$1).toString(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeOpts$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder(9).append(ConfigEntityName$.MODULE$.Default()).append("/clients/").append(ConfigEntityName$.MODULE$.Default()).toString(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(""))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private final void checkEntity$2(String expectedEntityType, String expectedEntityName, Seq args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--zookeeper", this.zkConnect()})).$plus$plus((GenTraversableOnce)args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)expectedEntityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private static final void checkEntities$1(String[] opts, scala.collection.immutable.Map expectedFetches, Seq expectedEntityNames, KafkaZkClient zkClient$1) {
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$colon$plus((Object)"--describe", ClassTag$.MODULE$.apply(String.class))));
        expectedFetches.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            Seq values = (Seq)x0$1._2();
            IExpectationSetters iExpectationSetters = EasyMock.expect((Object)zkClient$1.getAllEntitiesWithConfig(name)).andReturn((Object)values);
            return iExpectationSetters;
        });
        EasyMock.replay((Object[])new Object[]{zkClient$1});
        Seq entities = entity.getAllEntities(zkClient$1);
        Assert.assertEquals((Object)expectedEntityNames, (Object)entities.map((Function1 & Serializable & scala.Serializable)e -> e.fullSanitizedName(), Seq$.MODULE$.canBuildFrom()));
        EasyMock.reset((Object[])new Object[]{zkClient$1});
    }

    public class DummyAdminClient
    extends MockAdminClient {
        public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
            return (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        }

        public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
            return (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        }

        public AlterConfigsResult alterConfigs(java.util.Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
            return (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        }

        public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$DummyAdminClient$$$outer() {
            return ConfigCommandTest.this;
        }

        public DummyAdminClient(Node node) {
            if (ConfigCommandTest.this == null) {
                throw null;
            }
            super(Collections.singletonList(node), node);
        }
    }

    public class DummyAdminZkClient
    extends AdminZkClient {
        public void changeBrokerConfig(Seq<Object> brokerIds, Properties configs) {
        }

        public Properties fetchEntityConfig(String entityType, String entityName) {
            return new Properties();
        }

        public void changeClientIdConfig(String clientId, Properties configs) {
        }

        public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        }

        public void changeTopicConfig(String topic, Properties configs) {
        }

        public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$DummyAdminZkClient$$$outer() {
            return ConfigCommandTest.this;
        }

        public DummyAdminZkClient(KafkaZkClient zkClient) {
            if (ConfigCommandTest.this == null) {
                throw null;
            }
            super(zkClient);
        }
    }
}

