/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.AbstractApiVersionsRequestTest;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00113A\u0001C\u0005\u0001\u001d!)1\u0003\u0001C\u0001)!)a\u0003\u0001C!/!)a\u0004\u0001C\u0001?!)A\u0006\u0001C\u0001?!)a\u0006\u0001C\u0001?!)\u0001\u0007\u0001C\u0001?!)!\u0007\u0001C\u0005g\t1\u0012\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u000b\u0017\u000511/\u001a:wKJT\u0011\u0001D\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0002\u0005\u0002\u0011#5\t\u0011\"\u0003\u0002\u0013\u0013\tq\u0012IY:ue\u0006\u001cG/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"\u0001\u0005\u0001\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u00021A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t\u0019\u0011J\u001c;\u0002-Q,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR$\u0012\u0001\t\t\u00033\u0005J!A\t\u000e\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0007\u0011\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u000b),h.\u001b;\u000b\u0003%\n1a\u001c:h\u0013\tYcE\u0001\u0003UKN$\u0018\u0001\f;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;XSRDWK\\:vaB|'\u000f^3e-\u0016\u00148/[8oQ\t!A%\u0001\u0012uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u-\u0006d\u0017\u000eZ1uS>tg\u000b\r\u0015\u0003\u000b\u0011\n!\u0005^3ti\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e,bY&$\u0017\r^5p]Z\u001b\u0004F\u0001\u0004%\u0003Y\u0019XM\u001c3Ba&4VM]:j_:\u001c(+Z9vKN$HC\u0001\u001b@!\t)T(D\u00017\u0015\t9\u0004(\u0001\u0005sKF,Xm\u001d;t\u0015\tI$(\u0001\u0004d_6lwN\u001c\u0006\u0003\u0019mR!\u0001\u0010\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tqdGA\nBa&4VM]:j_:\u001c(+Z:q_:\u001cX\rC\u0003A\u000f\u0001\u0007\u0011)A\u0004sKF,Xm\u001d;\u0011\u0005U\u0012\u0015BA\"7\u0005I\t\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;")
public class ApiVersionsRequestTest
extends AbstractApiVersionsRequestTest {
    @Override
    public int brokerCount() {
        return 1;
    }

    @Test
    public void testApiVersionsRequest() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request);
        this.validateApiVersionsResponse(apiVersionsResponse);
    }

    @Test
    public void testApiVersionsRequestWithUnsupportedVersion() {
        ApiVersionsRequest apiVersionsRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendUnsupportedApiVersionRequest(apiVersionsRequest);
        Assert.assertEquals((long)Errors.UNSUPPORTED_VERSION.code(), (long)apiVersionsResponse.data.errorCode());
        Assert.assertFalse((boolean)apiVersionsResponse.data.apiKeys().isEmpty());
        ApiVersionsResponseData.ApiVersionsResponseKey apiVersion = apiVersionsResponse.data.apiKeys().find(ApiKeys.API_VERSIONS.id);
        Assert.assertEquals((long)ApiKeys.API_VERSIONS.id, (long)apiVersion.apiKey());
        Assert.assertEquals((long)ApiKeys.API_VERSIONS.oldestVersion(), (long)apiVersion.minVersion());
        Assert.assertEquals((long)ApiKeys.API_VERSIONS.latestVersion(), (long)apiVersion.maxVersion());
    }

    @Test
    public void testApiVersionsRequestValidationV0() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest);
        this.validateApiVersionsResponse(apiVersionsResponse);
    }

    @Test
    public void testApiVersionsRequestValidationV3() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new ApiVersionsRequestData(), (short)3);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest);
        Assert.assertEquals((long)Errors.INVALID_REQUEST.code(), (long)apiVersionsResponse.data.errorCode());
    }

    private ApiVersionsResponse sendApiVersionsRequest(ApiVersionsRequest request) {
        return (ApiVersionsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }
}

