/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.BrokerIdsZNode$;
import kafka.zk.BrokerInfo;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BrokerIdZNode$ {
    public static BrokerIdZNode$ MODULE$;
    private final String HostKey;
    private final String PortKey;
    private final String VersionKey;
    private final String EndpointsKey;
    private final String RackKey;
    private final String JmxPortKey;
    private final String ListenerSecurityProtocolMapKey;
    private final String TimestampKey;

    static {
        new BrokerIdZNode$();
    }

    private String HostKey() {
        return this.HostKey;
    }

    private String PortKey() {
        return this.PortKey;
    }

    private String VersionKey() {
        return this.VersionKey;
    }

    private String EndpointsKey() {
        return this.EndpointsKey;
    }

    private String RackKey() {
        return this.RackKey;
    }

    private String JmxPortKey() {
        return this.JmxPortKey;
    }

    private String ListenerSecurityProtocolMapKey() {
        return this.ListenerSecurityProtocolMapKey;
    }

    private String TimestampKey() {
        return this.TimestampKey;
    }

    public String path(int id) {
        return new StringBuilder(1).append(BrokerIdsZNode$.MODULE$.path()).append("/").append(id).toString();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encode(int version, String host, int port, Seq<EndPoint> advertisedEndpoints, int jmxPort, Option<String> rack) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this6;
        Tuple2[] tuple2Array = new Tuple2[6];
        Integer n = BoxesRunTime.boxToInteger((int)version);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.VersionKey());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y5);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.HostKey());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)host);
        Integer n2 = BoxesRunTime.boxToInteger((int)port);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.PortKey());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Object object4 = JavaConverters$.MODULE$.bufferAsJavaListConverter(((TraversableOnce)advertisedEndpoints.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.connectionString(), Seq$.MODULE$.canBuildFrom())).toBuffer()).asJava();
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)this.EndpointsKey());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Integer n3 = BoxesRunTime.boxToInteger((int)jmxPort);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)this.JmxPortKey());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string = ((Object)BoxesRunTime.boxToLong((long)Time.SYSTEM.milliseconds())).toString();
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)this.TimestampKey());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[5] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        if (rack == null) {
            throw null;
        }
        if (!rack.isEmpty()) {
            String string2 = (String)rack.get();
            BrokerIdZNode$.$anonfun$encode$2(version, jsonMap, string2);
        }
        if (version >= 4) {
            void $minus$greater$extension_y6;
            void $minus$greater$extension_$this7;
            Object object8 = JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)advertisedEndpoints.map((Function1 & Serializable & scala.Serializable)endPoint -> {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                String string = endPoint.securityProtocol().name;
                Object object = Predef$.MODULE$.ArrowAssoc((Object)endPoint.listenerName().value());
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            Object object9 = Predef$.MODULE$.ArrowAssoc((Object)this.ListenerSecurityProtocolMapKey());
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            jsonMap.$plus$eq(new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y6));
        }
        return Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(jsonMap).asJava());
    }

    public byte[] encode(BrokerInfo brokerInfo) {
        Broker broker = brokerInfo.broker();
        Option option = broker.endPoints().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BrokerIdZNode$.$anonfun$encode$4(x$2)));
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BrokerIdZNode$.$anonfun$encode$5() : getOrElse_this.get();
        EndPoint plaintextEndpoint = (EndPoint)object;
        return this.encode(brokerInfo.version(), plaintextEndpoint.host(), plaintextEndpoint.port(), broker.endPoints(), brokerInfo.jmxPort(), broker.rack());
    }

    public BrokerInfo decode(int id, byte[] jsonBytes) {
        Option<JsonValue> option;
        Seq endpoints;
        int jmxPort;
        int version;
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(jsonBytes);
        if (either instanceof Right) {
            Seq seq;
            JsonObject brokerInfo = ((JsonValue)((Right)either).value()).asJsonObject();
            version = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            jmxPort = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.JmxPortKey()).to(DecodeJson$DecodeInt$.MODULE$));
            if (version < 1) {
                throw new KafkaException(new StringBuilder(44).append("Unsupported version of broker registration: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            if (version == 1) {
                String host = brokerInfo.apply(this.HostKey()).to(DecodeJson$DecodeString$.MODULE$);
                int port = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.PortKey()).to(DecodeJson$DecodeInt$.MODULE$));
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                EndPoint endPoint = new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endPoint}));
            } else {
                Option<JsonValue> option2 = brokerInfo.get(this.ListenerSecurityProtocolMapKey());
                if (option2 == null) {
                    throw null;
                }
                Option<JsonValue> map_this = option2;
                Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BrokerIdZNode$.$anonfun$decode$2((JsonValue)map_this.get()));
                seq = (Seq)((Seq)brokerInfo.apply(this.EndpointsKey()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()))).map(arg_0 -> BrokerIdZNode$.$anonfun$decode$4((Option)object, arg_0), Seq$.MODULE$.canBuildFrom());
            }
            endpoints = seq;
            option = brokerInfo.get(this.RackKey());
            if (option == null) {
                throw null;
            }
        } else {
            if (either instanceof Left) {
                JsonProcessingException e = (JsonProcessingException)((Left)either).value();
                throw new KafkaException(new StringBuilder(52).append("Failed to parse ZooKeeper registration for broker ").append(id).append(": ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString(), (Throwable)e);
            }
            throw new MatchError(either);
        }
        Option<JsonValue> flatMap_this = option;
        Object object = flatMap_this.isEmpty() ? None$.MODULE$ : ((JsonValue)flatMap_this.get()).to(DecodeJson$.MODULE$.decodeOption(DecodeJson$DecodeString$.MODULE$));
        BrokerInfo brokerInfo = new BrokerInfo(new Broker(id, (Seq<EndPoint>)endpoints, (Option<String>)object), version, jmxPort);
        return brokerInfo;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$encode$2(int version$1, scala.collection.mutable.Map jsonMap$1, String rack) {
        if (version$1 >= 3) {
            void $minus$greater$extension_$this;
            Object object = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.RackKey());
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return jsonMap$1.$plus$eq(new Tuple2((Object)$minus$greater$extension_$this, (Object)rack));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$encode$4(EndPoint x$2) {
        SecurityProtocol securityProtocol = x$2.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ EndPoint $anonfun$encode$5() {
        return new EndPoint(null, -1, null, null);
    }

    public static final /* synthetic */ Map $anonfun$decode$2(JsonValue x$3) {
        return (Map)((TraversableLike)x$3.to(DecodeJson$.MODULE$.decodeMap(DecodeJson$DecodeString$.MODULE$, Map$.MODULE$.canBuildFrom()))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                String listenerName = (String)x0$1._1();
                String securityProtocol = (String)x0$1._2();
                SecurityProtocol securityProtocol2 = SecurityProtocol.forName((String)securityProtocol);
                Object object = Predef$.MODULE$.ArrowAssoc((Object)new ListenerName(listenerName));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ EndPoint $anonfun$decode$4(Option securityProtocolMap$1, String x$4) {
        return EndPoint$.MODULE$.createEndPoint(x$4, (Option<Map<ListenerName, SecurityProtocol>>)securityProtocolMap$1);
    }

    private BrokerIdZNode$() {
        MODULE$ = this;
        this.HostKey = "host";
        this.PortKey = "port";
        this.VersionKey = "version";
        this.EndpointsKey = "endpoints";
        this.RackKey = "rack";
        this.JmxPortKey = "jmx_port";
        this.ListenerSecurityProtocolMapKey = "listener_security_protocol_map";
        this.TimestampKey = "timestamp";
    }
}

