/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00153A!\u0003\u0006\u0001\u001f!AA\u0005\u0001BC\u0002\u0013\u0005Q\u0005\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003'\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u001d\t\u0004A1A\u0005\n\u0015BaA\r\u0001!\u0002\u00131\u0003\"B\u0017\u0001\t\u0003\u0019\u0004\"B\u001e\u0001\t\u0003a\u0004\"\u0002 \u0001\t\u0003y$a\u0003#fY\u0006LX\rZ%uK6T!a\u0003\u0007\u0002\u000bU$\u0018\u000e\\:\u000b\u00035\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001!a\u0001\u0003CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012AC2p]\u000e,(O]3oi*\u0011Q\u0004F\u0001\u0005kRLG.\u0003\u0002 5\t9A)\u001a7bs\u0016$\u0007CA\u0011#\u001b\u0005Q\u0011BA\u0012\u000b\u0005\u001daunZ4j]\u001e\fq\u0001Z3mCfl5/F\u0001'!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0011auN\\4\u0002\u0011\u0011,G.Y=Ng\u0002\na\u0001P5oSRtDCA\u00181!\t\t\u0003\u0001C\u0003%\u0007\u0001\u0007a%A\u0003ek\u0016l5/\u0001\u0004ek\u0016l5\u000f\t\u000b\u0004_Q2\u0004\"B\u001b\u0007\u0001\u00041\u0013!\u00023fY\u0006L\b\"B\u001c\u0007\u0001\u0004A\u0014\u0001B;oSR\u0004\"!G\u001d\n\u0005iR\"\u0001\u0003+j[\u0016,f.\u001b;\u0002\u0011\u001d,G\u000fR3mCf$\"AJ\u001f\t\u000b]:\u0001\u0019\u0001\u001d\u0002\u0013\r|W\u000e]1sKR{GC\u0001!D!\t9\u0013)\u0003\u0002CQ\t\u0019\u0011J\u001c;\t\u000b\u0011C\u0001\u0019\u0001\r\u0002\u0003\u0011\u0004")
public class DelayedItem
implements Delayed,
Logging {
    private final long delayMs;
    private final long dueMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public long delayMs() {
        return this.delayMs;
    }

    private long dueMs() {
        return this.dueMs;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(Math.max(this.dueMs() - Time.SYSTEM.milliseconds(), 0L), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed d) {
        DelayedItem other = (DelayedItem)d;
        return Long.compare(this.dueMs(), other.dueMs());
    }

    public DelayedItem(long delayMs) {
        this.delayMs = delayMs;
        this.dueMs = Time.SYSTEM.milliseconds() + delayMs;
    }

    public DelayedItem(long delay, TimeUnit unit) {
        this(unit.toMillis(delay));
    }
}

