/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ArrayPatternConverter;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;

@Plugin(name="DatePatternConverter", category="Converter")
@ConverterKeys(value={"d", "date"})
public final class DatePatternConverter
extends LogEventPatternConverter
implements ArrayPatternConverter {
    private static final String ABSOLUTE_FORMAT = "ABSOLUTE";
    private static final String ABSOLUTE_TIME_PATTERN = "HH:mm:ss,SSS";
    private static final String COMPACT_FORMAT = "COMPACT";
    private static final String COMPACT_PATTERN = "yyyyMMddHHmmssSSS";
    private static final String DATE_AND_TIME_FORMAT = "DATE";
    private static final String DATE_AND_TIME_PATTERN = "dd MMM yyyy HH:mm:ss,SSS";
    private static final String ISO8601_BASIC_FORMAT = "ISO8601_BASIC";
    private static final String ISO8601_BASIC_PATTERN = "yyyyMMdd HHmmss,SSS";
    private static final String ISO8601_FORMAT = "ISO8601";
    private static final String ISO8601_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    private static final String UNIX_FORMAT = "UNIX";
    private static final String UNIX_MILLIS_FORMAT = "UNIX_MILLIS";
    private String cachedDateString;
    private final Formatter formatter;
    private long lastTimestamp;

    public static DatePatternConverter newInstance(String[] options) {
        return new DatePatternConverter(options);
    }

    private DatePatternConverter(String[] options) {
        super("Date", "date");
        String patternOption = options != null && options.length > 0 ? options[0] : null;
        String pattern = null;
        Formatter tempFormatter = null;
        if (patternOption == null || patternOption.equalsIgnoreCase(ISO8601_FORMAT)) {
            pattern = ISO8601_PATTERN;
        } else if (patternOption.equalsIgnoreCase(ISO8601_BASIC_FORMAT)) {
            pattern = ISO8601_BASIC_PATTERN;
        } else if (patternOption.equalsIgnoreCase(ABSOLUTE_FORMAT)) {
            pattern = ABSOLUTE_TIME_PATTERN;
        } else if (patternOption.equalsIgnoreCase(DATE_AND_TIME_FORMAT)) {
            pattern = DATE_AND_TIME_PATTERN;
        } else if (patternOption.equalsIgnoreCase(COMPACT_FORMAT)) {
            pattern = COMPACT_PATTERN;
        } else if (patternOption.equalsIgnoreCase(UNIX_FORMAT)) {
            tempFormatter = new UnixFormatter();
        } else if (patternOption.equalsIgnoreCase(UNIX_MILLIS_FORMAT)) {
            tempFormatter = new UnixMillisFormatter();
        } else {
            pattern = patternOption;
        }
        if (pattern != null) {
            SimpleDateFormat tempFormat;
            try {
                tempFormat = new SimpleDateFormat(pattern);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Could not instantiate SimpleDateFormat with pattern " + patternOption, (Throwable)e);
                tempFormat = new SimpleDateFormat(ISO8601_PATTERN);
            }
            if (options != null && options.length > 1) {
                TimeZone tz = TimeZone.getTimeZone(options[1]);
                tempFormat.setTimeZone(tz);
            }
            tempFormatter = new PatternFormatter(tempFormat);
        }
        this.formatter = tempFormatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(Date date, StringBuilder toAppendTo) {
        DatePatternConverter datePatternConverter = this;
        synchronized (datePatternConverter) {
            toAppendTo.append(this.formatter.format(date.getTime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(LogEvent event, StringBuilder output) {
        long timestamp = event.getTimeMillis();
        DatePatternConverter datePatternConverter = this;
        synchronized (datePatternConverter) {
            if (timestamp != this.lastTimestamp) {
                this.lastTimestamp = timestamp;
                this.cachedDateString = this.formatter.format(timestamp);
            }
        }
        output.append(this.cachedDateString);
    }

    @Override
    public void format(Object obj, StringBuilder output) {
        if (obj instanceof Date) {
            this.format((Date)obj, output);
        }
        super.format(obj, output);
    }

    @Override
    public void format(StringBuilder toAppendTo, Object ... objects) {
        for (Object obj : objects) {
            if (!(obj instanceof Date)) continue;
            this.format(obj, toAppendTo);
            break;
        }
    }

    public String getPattern() {
        return this.formatter.toPattern();
    }

    private static class UnixMillisFormatter
    extends Formatter {
        private UnixMillisFormatter() {
        }

        @Override
        String format(long time) {
            return Long.toString(time);
        }
    }

    private static class UnixFormatter
    extends Formatter {
        private UnixFormatter() {
        }

        @Override
        String format(long time) {
            return Long.toString(time / 1000L);
        }
    }

    private static class PatternFormatter
    extends Formatter {
        private final SimpleDateFormat simpleDateFormat;

        PatternFormatter(SimpleDateFormat simpleDateFormat) {
            this.simpleDateFormat = simpleDateFormat;
        }

        @Override
        String format(long time) {
            return this.simpleDateFormat.format(time);
        }

        @Override
        public String toPattern() {
            return this.simpleDateFormat.toPattern();
        }
    }

    private static abstract class Formatter {
        private Formatter() {
        }

        abstract String format(long var1);

        public String toPattern() {
            return null;
        }
    }
}

