/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.logging.log4j.core.util.ResourceLoader;

public final class ClassLoaderResourceLoader
implements ResourceLoader {
    private final ClassLoader loader;

    public ClassLoaderResourceLoader(ClassLoader loader) {
        this.loader = loader != null ? loader : this.getClass().getClassLoader();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loader.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        return this.loader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.loader.getResources(name);
    }

    public String toString() {
        return this.getClass().getCanonicalName() + '(' + this.loader.toString() + ')';
    }
}

