/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.server;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LogEventListener;
import org.apache.logging.log4j.core.appender.mom.JmsManager;
import org.apache.logging.log4j.core.net.JndiManager;
import org.apache.logging.log4j.status.StatusLogger;

public class JmsServer
extends LogEventListener
implements MessageListener,
LifeCycle {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final AtomicReference<LifeCycle.State> state = new AtomicReference<LifeCycle.State>(LifeCycle.State.INITIALIZED);
    private final JmsManager jmsManager;
    private MessageConsumer messageConsumer;

    public JmsServer(String connectionFactoryBindingName, String destinationBindingName, String username, String password) {
        String managerName = JmsServer.class.getName() + '@' + JmsServer.class.hashCode();
        JndiManager jndiManager = JndiManager.getDefaultManager(managerName);
        this.jmsManager = JmsManager.getJmsManager(managerName, jndiManager, connectionFactoryBindingName, destinationBindingName, username, password);
    }

    @Override
    public LifeCycle.State getState() {
        return this.state.get();
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof ObjectMessage) {
                Serializable body = ((ObjectMessage)message).getObject();
                if (body instanceof LogEvent) {
                    this.log((LogEvent)body);
                } else {
                    LOGGER.warn("Expected ObjectMessage to contain LogEvent. Got type {} instead.", new Object[]{body.getClass()});
                }
            } else {
                LOGGER.warn("Received message of type {} and JMSType {} which cannot be handled.", new Object[]{message.getClass(), message.getJMSType()});
            }
        }
        catch (JMSException e) {
            LOGGER.catching((Throwable)e);
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
        if (this.state.compareAndSet(LifeCycle.State.INITIALIZED, LifeCycle.State.STARTING)) {
            try {
                this.messageConsumer = this.jmsManager.createMessageConsumer();
                this.messageConsumer.setMessageListener((MessageListener)this);
            }
            catch (JMSException e) {
                throw new LoggingException((Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
        try {
            this.messageConsumer.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.jmsManager.release();
    }

    @Override
    public boolean isStarted() {
        return this.state.get() == LifeCycle.State.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.state.get() == LifeCycle.State.STOPPED;
    }
}

