/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.context;

import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rewrite.parameter.EncryptParameterRewriterBuilder;
import org.apache.shardingsphere.encrypt.rewrite.token.EncryptTokenGenerateBuilder;
import org.apache.shardingsphere.underlying.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.underlying.rewrite.context.SQLRewriteContextDecorator;
import org.apache.shardingsphere.underlying.rewrite.parameter.rewriter.ParameterRewriter;

public final class EncryptSQLRewriteContextDecorator
implements SQLRewriteContextDecorator {
    private final EncryptRule encryptRule;
    private final boolean isQueryWithCipherColumn;

    public void decorate(SQLRewriteContext sqlRewriteContext) {
        for (ParameterRewriter each : new EncryptParameterRewriterBuilder(this.encryptRule, this.isQueryWithCipherColumn).getParameterRewriters(sqlRewriteContext.getRelationMetas())) {
            if (sqlRewriteContext.getParameters().isEmpty() || !each.isNeedRewrite(sqlRewriteContext.getSqlStatementContext())) continue;
            each.rewrite(sqlRewriteContext.getParameterBuilder(), sqlRewriteContext.getSqlStatementContext(), sqlRewriteContext.getParameters());
        }
        sqlRewriteContext.addSQLTokenGenerators(new EncryptTokenGenerateBuilder(this.encryptRule, this.isQueryWithCipherColumn).getSQLTokenGenerators());
    }

    @ConstructorProperties(value={"encryptRule", "isQueryWithCipherColumn"})
    public EncryptSQLRewriteContextDecorator(EncryptRule encryptRule, boolean isQueryWithCipherColumn) {
        this.encryptRule = encryptRule;
        this.isQueryWithCipherColumn = isQueryWithCipherColumn;
    }
}

