/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter;

import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.core.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.sql.parser.relation.statement.SQLStatementContext;
import org.apache.shardingsphere.underlying.rewrite.parameter.rewriter.ParameterRewriter;

public abstract class EncryptParameterRewriter
implements ParameterRewriter,
EncryptRuleAware {
    private EncryptRule encryptRule;

    public final boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        return this.isNeedRewriteForEncrypt(sqlStatementContext) && this.isNeedEncrypt(sqlStatementContext);
    }

    protected abstract boolean isNeedRewriteForEncrypt(SQLStatementContext var1);

    private boolean isNeedEncrypt(SQLStatementContext sqlStatementContext) {
        for (String each : sqlStatementContext.getTablesContext().getTableNames()) {
            if (!this.encryptRule.findEncryptTable(each).isPresent()) continue;
            return true;
        }
        return false;
    }

    public EncryptRule getEncryptRule() {
        return this.encryptRule;
    }

    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }
}

