/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.core.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.encrypt.rewrite.parameter.impl.EncryptAssignmentParameterRewriter;
import org.apache.shardingsphere.encrypt.rewrite.parameter.impl.EncryptInsertValueParameterRewriter;
import org.apache.shardingsphere.encrypt.rewrite.parameter.impl.EncryptPredicateParameterRewriter;
import org.apache.shardingsphere.sql.parser.relation.metadata.RelationMetas;
import org.apache.shardingsphere.underlying.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.underlying.rewrite.parameter.rewriter.ParameterRewriterBuilder;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.RelationMetasAware;

public final class EncryptParameterRewriterBuilder
implements ParameterRewriterBuilder {
    private final EncryptRule encryptRule;
    private final boolean queryWithCipherColumn;

    public Collection<ParameterRewriter> getParameterRewriters(RelationMetas relationMetas) {
        Collection<ParameterRewriter> result = this.getParameterRewriters();
        for (ParameterRewriter each : result) {
            this.setUpParameterRewriters(each, relationMetas);
        }
        return result;
    }

    private Collection<ParameterRewriter> getParameterRewriters() {
        LinkedList<ParameterRewriter> result = new LinkedList<ParameterRewriter>();
        result.add(new EncryptAssignmentParameterRewriter());
        result.add(new EncryptPredicateParameterRewriter());
        result.add(new EncryptInsertValueParameterRewriter());
        return result;
    }

    private void setUpParameterRewriters(ParameterRewriter parameterRewriter, RelationMetas relationMetas) {
        if (parameterRewriter instanceof RelationMetasAware) {
            ((RelationMetasAware)parameterRewriter).setRelationMetas(relationMetas);
        }
        if (parameterRewriter instanceof EncryptRuleAware) {
            ((EncryptRuleAware)parameterRewriter).setEncryptRule(this.encryptRule);
        }
        if (parameterRewriter instanceof QueryWithCipherColumnAware) {
            ((QueryWithCipherColumnAware)parameterRewriter).setQueryWithCipherColumn(this.queryWithCipherColumn);
        }
    }

    @ConstructorProperties(value={"encryptRule", "queryWithCipherColumn"})
    public EncryptParameterRewriterBuilder(EncryptRule encryptRule, boolean queryWithCipherColumn) {
        this.encryptRule = encryptRule;
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

