/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptLiteralAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptParameterAssignmentToken;
import org.apache.shardingsphere.sql.parser.relation.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.relation.statement.impl.InsertSQLStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.SetAssignmentsSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.UpdateStatement;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.CollectionSQLTokenGenerator;

public final class EncryptAssignmentTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator {
    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext.getSqlStatement() instanceof UpdateStatement || sqlStatementContext instanceof InsertSQLStatementContext && sqlStatementContext.getSqlStatement().findSQLSegment(SetAssignmentsSegment.class).isPresent();
    }

    public Collection<EncryptAssignmentToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<EncryptAssignmentToken> result = new LinkedList<EncryptAssignmentToken>();
        String tableName = sqlStatementContext.getTablesContext().getSingleTableName();
        for (AssignmentSegment each : this.getSetAssignmentsSegment(sqlStatementContext.getSqlStatement()).getAssignments()) {
            Optional<EncryptAssignmentToken> sqlToken;
            if (!this.getEncryptRule().findShardingEncryptor(tableName, each.getColumn().getName()).isPresent() || !(sqlToken = this.generateSQLToken(tableName, each)).isPresent()) continue;
            result.add((EncryptAssignmentToken)((Object)sqlToken.get()));
        }
        return result;
    }

    private SetAssignmentsSegment getSetAssignmentsSegment(SQLStatement sqlStatement) {
        if (sqlStatement instanceof InsertStatement) {
            Optional result = ((InsertStatement)sqlStatement).getSetAssignment();
            Preconditions.checkState((boolean)result.isPresent());
            return (SetAssignmentsSegment)result.get();
        }
        return ((UpdateStatement)sqlStatement).getSetAssignment();
    }

    private Optional<EncryptAssignmentToken> generateSQLToken(String tableName, AssignmentSegment assignmentSegment) {
        if (assignmentSegment.getValue() instanceof ParameterMarkerExpressionSegment) {
            return Optional.of((Object)((Object)this.generateParameterSQLToken(tableName, assignmentSegment)));
        }
        if (assignmentSegment.getValue() instanceof LiteralExpressionSegment) {
            return Optional.of((Object)((Object)this.generateLiteralSQLToken(tableName, assignmentSegment)));
        }
        return Optional.absent();
    }

    private EncryptAssignmentToken generateParameterSQLToken(String tableName, AssignmentSegment assignmentSegment) {
        EncryptParameterAssignmentToken result = new EncryptParameterAssignmentToken(assignmentSegment.getColumn().getStartIndex(), assignmentSegment.getStopIndex());
        String columnName = assignmentSegment.getColumn().getName();
        this.addCipherColumn(tableName, columnName, result);
        this.addAssistedQueryColumn(tableName, columnName, result);
        this.addPlainColumn(tableName, columnName, result);
        return result;
    }

    private void addCipherColumn(String tableName, String columnName, EncryptParameterAssignmentToken token) {
        token.addColumnName(this.getEncryptRule().getCipherColumn(tableName, columnName));
    }

    private void addAssistedQueryColumn(String tableName, String columnName, EncryptParameterAssignmentToken token) {
        Optional assistedQueryColumn = this.getEncryptRule().findAssistedQueryColumn(tableName, columnName);
        if (assistedQueryColumn.isPresent()) {
            token.addColumnName((String)assistedQueryColumn.get());
        }
    }

    private void addPlainColumn(String tableName, String columnName, EncryptParameterAssignmentToken token) {
        Optional plainColumn = this.getEncryptRule().findPlainColumn(tableName, columnName);
        if (plainColumn.isPresent()) {
            token.addColumnName((String)plainColumn.get());
        }
    }

    private EncryptAssignmentToken generateLiteralSQLToken(String tableName, AssignmentSegment assignmentSegment) {
        EncryptLiteralAssignmentToken result = new EncryptLiteralAssignmentToken(assignmentSegment.getColumn().getStartIndex(), assignmentSegment.getStopIndex());
        this.addCipherAssignment(tableName, assignmentSegment, result);
        this.addAssistedQueryAssignment(tableName, assignmentSegment, result);
        this.addPlainAssignment(tableName, assignmentSegment, result);
        return result;
    }

    private void addCipherAssignment(String tableName, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
        Object cipherValue = this.getEncryptRule().getEncryptValues(tableName, assignmentSegment.getColumn().getName(), Collections.singletonList(originalValue)).iterator().next();
        token.addAssignment(this.getEncryptRule().getCipherColumn(tableName, assignmentSegment.getColumn().getName()), cipherValue);
    }

    private void addAssistedQueryAssignment(String tableName, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
        Optional assistedQueryColumn = this.getEncryptRule().findAssistedQueryColumn(tableName, assignmentSegment.getColumn().getName());
        if (assistedQueryColumn.isPresent()) {
            Object assistedQueryValue = this.getEncryptRule().getEncryptAssistedQueryValues(tableName, assignmentSegment.getColumn().getName(), Collections.singletonList(originalValue)).iterator().next();
            token.addAssignment((String)assistedQueryColumn.get(), assistedQueryValue);
        }
    }

    private void addPlainAssignment(String tableName, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
        Optional plainColumn = this.getEncryptRule().findPlainColumn(tableName, assignmentSegment.getColumn().getName());
        if (plainColumn.isPresent()) {
            token.addAssignment((String)plainColumn.get(), originalValue);
        }
    }
}

