/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.strategy.encrypt.EncryptTable;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.sql.parser.relation.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.relation.statement.impl.InsertSQLStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.UseDefaultInsertColumnsToken;

public final class EncryptForUseDefaultInsertColumnsTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements OptionalSQLTokenGenerator,
PreviousSQLTokensAware {
    private List<SQLToken> previousSQLTokens;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertSQLStatementContext && ((InsertStatement)sqlStatementContext.getSqlStatement()).useDefaultColumns();
    }

    public UseDefaultInsertColumnsToken generateSQLToken(SQLStatementContext sqlStatementContext) {
        String tableName = sqlStatementContext.getTablesContext().getSingleTableName();
        Optional<UseDefaultInsertColumnsToken> previousSQLToken = this.findInsertColumnsToken();
        if (previousSQLToken.isPresent()) {
            this.processPreviousSQLToken((UseDefaultInsertColumnsToken)previousSQLToken.get(), (InsertSQLStatementContext)sqlStatementContext, tableName);
            return (UseDefaultInsertColumnsToken)previousSQLToken.get();
        }
        return this.generateNewSQLToken((InsertSQLStatementContext)sqlStatementContext, tableName);
    }

    private Optional<UseDefaultInsertColumnsToken> findInsertColumnsToken() {
        for (SQLToken each : this.previousSQLTokens) {
            if (!(each instanceof UseDefaultInsertColumnsToken)) continue;
            return Optional.of((Object)((UseDefaultInsertColumnsToken)each));
        }
        return Optional.absent();
    }

    private void processPreviousSQLToken(UseDefaultInsertColumnsToken previousSQLToken, InsertSQLStatementContext sqlStatementContext, String tableName) {
        Optional encryptTable = this.getEncryptRule().findEncryptTable(tableName);
        Preconditions.checkState((boolean)encryptTable.isPresent());
        List<String> columnNames = this.getColumnNames(sqlStatementContext, (EncryptTable)encryptTable.get(), previousSQLToken.getColumns());
        previousSQLToken.getColumns().clear();
        previousSQLToken.getColumns().addAll(columnNames);
    }

    private UseDefaultInsertColumnsToken generateNewSQLToken(InsertSQLStatementContext sqlStatementContext, String tableName) {
        Optional insertColumnsSegment = sqlStatementContext.getSqlStatement().findSQLSegment(InsertColumnsSegment.class);
        Preconditions.checkState((boolean)insertColumnsSegment.isPresent());
        Optional encryptTable = this.getEncryptRule().findEncryptTable(tableName);
        Preconditions.checkState((boolean)encryptTable.isPresent());
        return new UseDefaultInsertColumnsToken(((InsertColumnsSegment)insertColumnsSegment.get()).getStopIndex(), this.getColumnNames(sqlStatementContext, (EncryptTable)encryptTable.get(), sqlStatementContext.getColumnNames()));
    }

    private List<String> getColumnNames(InsertSQLStatementContext sqlStatementContext, EncryptTable encryptTable, List<String> currentColumnNames) {
        LinkedList<String> result = new LinkedList<String>(currentColumnNames);
        Iterator descendingColumnNames = sqlStatementContext.getDescendingColumnNames();
        while (descendingColumnNames.hasNext()) {
            String columnName = (String)descendingColumnNames.next();
            if (!encryptTable.findShardingEncryptor(columnName).isPresent()) continue;
            int columnIndex = result.indexOf(columnName);
            this.addPlainColumn(result, encryptTable, columnName, columnIndex);
            this.addAssistedQueryColumn(result, encryptTable, columnName, columnIndex);
            this.setCipherColumn(result, encryptTable, columnName, columnIndex);
        }
        return result;
    }

    private void addPlainColumn(List<String> columnNames, EncryptTable encryptTable, String columnName, int columnIndex) {
        Optional plainColumn = encryptTable.findPlainColumn(columnName);
        if (plainColumn.isPresent()) {
            columnNames.add(columnIndex + 1, (String)plainColumn.get());
        }
    }

    private void addAssistedQueryColumn(List<String> columnNames, EncryptTable encryptTable, String columnName, int columnIndex) {
        Optional assistedQueryColumn = encryptTable.findAssistedQueryColumn(columnName);
        if (assistedQueryColumn.isPresent()) {
            columnNames.add(columnIndex + 1, (String)assistedQueryColumn.get());
        }
    }

    private void setCipherColumn(List<String> columnNames, EncryptTable encryptTable, String columnName, int columnIndex) {
        columnNames.set(columnIndex, encryptTable.getCipherColumn(columnName));
    }

    public void setPreviousSQLTokens(List<SQLToken> previousSQLTokens) {
        this.previousSQLTokens = previousSQLTokens;
    }
}

