/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.core.constant.ShardingOperator;
import org.apache.shardingsphere.encrypt.rewrite.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.EncryptConditionEngine;
import org.apache.shardingsphere.encrypt.rewrite.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptPredicateRightValueToken;
import org.apache.shardingsphere.sql.parser.relation.metadata.RelationMetas;
import org.apache.shardingsphere.sql.parser.relation.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.sql.statement.generic.WhereSegmentAvailable;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.ParametersAware;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.RelationMetasAware;

public final class EncryptPredicateRightValueTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator,
RelationMetasAware,
ParametersAware,
QueryWithCipherColumnAware {
    private RelationMetas relationMetas;
    private List<Object> parameters;
    private boolean queryWithCipherColumn;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext.getSqlStatement() instanceof WhereSegmentAvailable && ((WhereSegmentAvailable)sqlStatementContext.getSqlStatement()).getWhere().isPresent();
    }

    public Collection<EncryptPredicateRightValueToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        List<EncryptCondition> encryptConditions = new EncryptConditionEngine(this.getEncryptRule(), this.relationMetas).createEncryptConditions(sqlStatementContext);
        return encryptConditions.isEmpty() ? Collections.emptyList() : this.generateSQLTokens(encryptConditions);
    }

    private Collection<EncryptPredicateRightValueToken> generateSQLTokens(List<EncryptCondition> encryptConditions) {
        LinkedList<EncryptPredicateRightValueToken> result = new LinkedList<EncryptPredicateRightValueToken>();
        for (EncryptCondition each : encryptConditions) {
            result.add(this.generateSQLToken(each));
        }
        return result;
    }

    private EncryptPredicateRightValueToken generateSQLToken(EncryptCondition encryptCondition) {
        List<Object> originalValues = encryptCondition.getValues(this.parameters);
        int startIndex = encryptCondition.getOperator().equals((Object)ShardingOperator.IN) ? encryptCondition.getStartIndex() - 1 : encryptCondition.getStartIndex();
        return this.queryWithCipherColumn ? this.generateSQLTokenForQueryWithCipherColumn(encryptCondition, originalValues, startIndex) : this.generateSQLTokenForQueryWithoutCipherColumn(encryptCondition, originalValues, startIndex);
    }

    private EncryptPredicateRightValueToken generateSQLTokenForQueryWithCipherColumn(EncryptCondition encryptCondition, List<Object> originalValues, int startIndex) {
        List<Object> encryptedValues = this.getEncryptedValues(encryptCondition, originalValues);
        return new EncryptPredicateRightValueToken(startIndex, encryptCondition.getStopIndex(), this.getPositionValues(encryptCondition.getPositionValueMap().keySet(), encryptedValues), encryptCondition.getPositionIndexMap().keySet(), encryptCondition.getOperator());
    }

    private List<Object> getEncryptedValues(EncryptCondition encryptCondition, List<Object> originalValues) {
        Optional assistedQueryColumn = this.getEncryptRule().findAssistedQueryColumn(encryptCondition.getTableName(), encryptCondition.getColumnName());
        return assistedQueryColumn.isPresent() ? this.getEncryptRule().getEncryptAssistedQueryValues(encryptCondition.getTableName(), encryptCondition.getColumnName(), originalValues) : this.getEncryptRule().getEncryptValues(encryptCondition.getTableName(), encryptCondition.getColumnName(), originalValues);
    }

    private EncryptPredicateRightValueToken generateSQLTokenForQueryWithoutCipherColumn(EncryptCondition encryptCondition, List<Object> originalValues, int startIndex) {
        return new EncryptPredicateRightValueToken(startIndex, encryptCondition.getStopIndex(), this.getPositionValues(encryptCondition.getPositionValueMap().keySet(), originalValues), encryptCondition.getPositionIndexMap().keySet(), encryptCondition.getOperator());
    }

    private Map<Integer, Object> getPositionValues(Collection<Integer> valuePositions, List<Object> encryptValues) {
        LinkedHashMap<Integer, Object> result = new LinkedHashMap<Integer, Object>();
        for (int each : valuePositions) {
            result.put(each, encryptValues.get(each));
        }
        return result;
    }

    public void setRelationMetas(RelationMetas relationMetas) {
        this.relationMetas = relationMetas;
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public void setQueryWithCipherColumn(boolean queryWithCipherColumn) {
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

