/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.pojo;

import com.google.common.base.Joiner;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAssignmentToken;

public final class EncryptLiteralAssignmentToken
extends EncryptAssignmentToken {
    private final Collection<LiteralAssignment> assignments = new LinkedList<LiteralAssignment>();

    public EncryptLiteralAssignmentToken(int startIndex, int stopIndex) {
        super(startIndex, stopIndex);
    }

    public void addAssignment(String columnName, Object value) {
        this.assignments.add(new LiteralAssignment(columnName, value));
    }

    public String toString() {
        return Joiner.on((String)", ").join(this.assignments);
    }

    private final class LiteralAssignment {
        private final String columnName;
        private final Object value;

        public String toString() {
            return String.format("%s = %s", this.columnName, this.toString(this.value));
        }

        private String toString(Object value) {
            return String.class == value.getClass() ? String.format("'%s'", value) : value.toString();
        }

        @ConstructorProperties(value={"columnName", "value"})
        public LiteralAssignment(String columnName, Object value) {
            this.columnName = columnName;
            this.value = value;
        }
    }
}

