/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.pojo;

import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.core.constant.ShardingOperator;
import org.apache.shardingsphere.core.exception.ShardingException;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.Substitutable;

public final class EncryptPredicateRightValueToken
extends SQLToken
implements Substitutable {
    private final int stopIndex;
    private final Map<Integer, Object> indexValues;
    private final Collection<Integer> parameterMarkerIndexes;
    private final ShardingOperator operator;

    public EncryptPredicateRightValueToken(int startIndex, int stopIndex, Map<Integer, Object> indexValues, Collection<Integer> parameterMarkerIndexes, ShardingOperator operator) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.indexValues = indexValues;
        this.parameterMarkerIndexes = parameterMarkerIndexes;
        this.operator = operator;
    }

    public String toString() {
        switch (this.operator) {
            case EQUAL: {
                return this.toStringForEqual();
            }
            case IN: {
                return this.toStringForIn();
            }
        }
        throw new ShardingException("Sharding operator do not support.", new Object[0]);
    }

    private String toStringForEqual() {
        if (this.parameterMarkerIndexes.isEmpty()) {
            return this.indexValues.get(0) instanceof String ? String.format("'%s'", this.indexValues.get(0)) : this.indexValues.get(0).toString();
        }
        return "?";
    }

    private String toStringForIn() {
        StringBuilder result = new StringBuilder();
        result.append("(");
        for (int i = 0; i < this.indexValues.size() + this.parameterMarkerIndexes.size(); ++i) {
            if (this.parameterMarkerIndexes.contains(i)) {
                result.append("?");
            } else if (this.indexValues.get(i) instanceof String) {
                result.append("'").append(this.indexValues.get(i)).append("'");
            } else {
                result.append(this.indexValues.get(i));
            }
            result.append(", ");
        }
        result.delete(result.length() - 2, result.length()).append(")");
        return result.toString();
    }

    public int getStopIndex() {
        return this.stopIndex;
    }
}

