/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.fetcher.prometheus.http;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.fetcher.prometheus.http.HttpClientInitializer;
import org.apache.skywalking.oap.server.library.server.ssl.HttpDynamicSslContext;

public class HttpClient {
    private final String url;
    private final String caFilePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String request() throws URISyntaxException, InterruptedException {
        URI uri = new URI(this.url);
        String scheme = uri.getScheme() == null ? "http" : uri.getScheme();
        String host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
        int port = uri.getPort();
        boolean ssl = "https".equalsIgnoreCase(scheme);
        HttpDynamicSslContext sslCtx = ssl ? HttpDynamicSslContext.forClient((String)this.caFilePath) : null;
        NioEventLoopGroup group = new NioEventLoopGroup();
        SynchronousQueue<String> channel = new SynchronousQueue<String>();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new HttpClientInitializer((SslContext)sslCtx, channel));
            Channel ch = b.connect(host, port).sync().channel();
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri.getRawPath(), Unpooled.EMPTY_BUFFER);
            request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)host);
            request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.TEXT_PLAIN);
            ch.writeAndFlush((Object)request);
            String string = (String)Objects.requireNonNull(channel.poll(10L, TimeUnit.SECONDS), "Request timeout");
            return string;
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Generated
    HttpClient(String url, String caFilePath) {
        this.url = url;
        this.caFilePath = caFilePath;
    }

    @Generated
    public static HttpClientBuilder builder() {
        return new HttpClientBuilder();
    }

    @Generated
    public static class HttpClientBuilder {
        @Generated
        private String url;
        @Generated
        private String caFilePath;

        @Generated
        HttpClientBuilder() {
        }

        @Generated
        public HttpClientBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public HttpClientBuilder caFilePath(String caFilePath) {
            this.caFilePath = caFilePath;
            return this;
        }

        @Generated
        public HttpClient build() {
            return new HttpClient(this.url, this.caFilePath);
        }

        @Generated
        public String toString() {
            return "HttpClient.HttpClientBuilder(url=" + this.url + ", caFilePath=" + this.caFilePath + ")";
        }
    }
}

