/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.fetcher.prometheus.provider;

import com.google.common.collect.Maps;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.codec.Charsets;
import org.apache.skywalking.oap.meter.analyzer.MetricConvert;
import org.apache.skywalking.oap.meter.analyzer.prometheus.PrometheusMetricConverter;
import org.apache.skywalking.oap.meter.analyzer.prometheus.rule.Rule;
import org.apache.skywalking.oap.meter.analyzer.prometheus.rule.Rules;
import org.apache.skywalking.oap.meter.analyzer.prometheus.rule.StaticConfig;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.fetcher.prometheus.http.HttpClient;
import org.apache.skywalking.oap.server.fetcher.prometheus.module.PrometheusFetcherModule;
import org.apache.skywalking.oap.server.fetcher.prometheus.provider.PrometheusFetcherConfig;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.server.pool.CustomThreadFactory;
import org.apache.skywalking.oap.server.library.util.prometheus.Parser;
import org.apache.skywalking.oap.server.library.util.prometheus.Parsers;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.MetricFamily;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusFetcherProvider
extends ModuleProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusFetcherProvider.class);
    private final PrometheusFetcherConfig config = new PrometheusFetcherConfig();
    private List<Rule> rules;
    private ScheduledExecutorService ses;
    private HistogramMetrics histogram;
    private CounterMetrics errorCounter;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return PrometheusFetcherModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        this.rules = Rules.loadRules((String)this.config.getRulePath(), this.config.getEnabledRules());
        this.ses = Executors.newScheduledThreadPool(Math.min(this.rules.size(), this.config.getMaxConvertWorker()), (ThreadFactory)new CustomThreadFactory("meter-converter"));
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        MetricsCreator metricsCreator = (MetricsCreator)this.getManager().find("telemetry").provider().getService(MetricsCreator.class);
        this.histogram = metricsCreator.createHistogramMetric("metrics_fetcher_latency", "The process latency of metrics scraping", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
        this.errorCounter = metricsCreator.createCounter("metrics_fetcher_error_count", "The error number of metrics scraping", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
        if (this.rules.isEmpty()) {
            return;
        }
        MeterSystem service = (MeterSystem)this.getManager().find("core").provider().getService(MeterSystem.class);
        this.rules.forEach(r -> this.ses.scheduleAtFixedRate(new Runnable((Rule)r, service){
            private final PrometheusMetricConverter converter;
            final /* synthetic */ Rule val$r;
            final /* synthetic */ MeterSystem val$service;
            {
                this.val$r = rule;
                this.val$service = meterSystem;
                this.converter = new PrometheusMetricConverter(this.val$r, this.val$service);
            }

            @Override
            public void run() {
                try (HistogramMetrics.Timer ignored = PrometheusFetcherProvider.this.histogram.createTimer();){
                    if (Objects.isNull(this.val$r.getStaticConfig())) {
                        return;
                    }
                    StaticConfig sc = this.val$r.getStaticConfig();
                    long now = System.currentTimeMillis();
                    this.converter.toMeter(sc.getTargets().stream().map(CheckedFunction1.liftTry((CheckedFunction1 & Serializable)target -> {
                        URI url = new URI(target.getUrl());
                        URI targetURL = url.resolve(this.val$r.getMetricsPath());
                        String content = HttpClient.builder().url(targetURL.toString()).caFilePath(target.getSslCaFilePath()).build().request();
                        ArrayList result = new ArrayList();
                        try (ByteArrayInputStream targetStream = new ByteArrayInputStream(content.getBytes(Charsets.UTF_8));){
                            MetricFamily mf;
                            Parser p = Parsers.text((InputStream)targetStream);
                            while ((mf = p.parse(now)) != null) {
                                mf.getMetrics().forEach(metric -> {
                                    if (Objects.isNull(sc.getLabels())) {
                                        return;
                                    }
                                    HashMap extraLabels = Maps.newHashMap((Map)sc.getLabels());
                                    extraLabels.put("instance", target.getUrl());
                                    extraLabels.forEach((key, value) -> {
                                        if (metric.getLabels().containsKey(key)) {
                                            metric.getLabels().put("exported_" + key, metric.getLabels().get(key));
                                        }
                                        metric.getLabels().put(key, value);
                                    });
                                });
                                result.addAll(mf.getMetrics());
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Fetch metrics from prometheus: {}", result);
                        }
                        return result;
                    })).flatMap(tryIt -> MetricConvert.log((Try)tryIt, (String)"Load metric")).flatMap(Collection::stream));
                }
                catch (Exception e) {
                    PrometheusFetcherProvider.this.errorCounter.inc();
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }, 0L, Duration.parse(r.getFetcherInterval()).getSeconds(), TimeUnit.SECONDS));
    }

    public String[] requiredModules() {
        return new String[]{"telemetry", "core"};
    }
}

