/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.DependenciesToolException;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=DependenciesTool.class, hint="default")
public class DefaultDependenciesTool
extends AbstractLogEnabled
implements DependenciesTool {
    public static final String INVALID_PATTERN_MESSAGE = "The pattern specified by expression <%s> seems to be invalid.";
    @Requirement
    private MavenProjectBuilder mavenProjectBuilder;
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private ArtifactMetadataSource artifactMetadataSource;

    @Override
    public SortedMap<String, MavenProject> loadProjectDependencies(MavenProject project, MavenProjectDependenciesConfigurator configuration, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, SortedMap<String, MavenProject> cache) {
        boolean haveNoIncludedGroups = StringUtils.isEmpty((CharSequence)configuration.getIncludedGroups());
        boolean haveNoIncludedArtifacts = StringUtils.isEmpty((CharSequence)configuration.getIncludedArtifacts());
        boolean excludeTransitiveDependencies = configuration.isExcludeTransitiveDependencies();
        boolean haveExcludedGroups = StringUtils.isNotEmpty((CharSequence)configuration.getExcludedGroups());
        boolean haveExcludedArtifacts = StringUtils.isNotEmpty((CharSequence)configuration.getExcludedArtifacts());
        boolean haveExclusions = haveExcludedGroups || haveExcludedArtifacts;
        Pattern includedGroupPattern = null;
        Pattern includedArtifactPattern = null;
        Pattern excludedGroupPattern = null;
        Pattern excludedArtifactPattern = null;
        if (!haveNoIncludedGroups) {
            includedGroupPattern = Pattern.compile(configuration.getIncludedGroups());
        }
        if (!haveNoIncludedArtifacts) {
            includedArtifactPattern = Pattern.compile(configuration.getIncludedArtifacts());
        }
        if (haveExcludedGroups) {
            excludedGroupPattern = Pattern.compile(configuration.getExcludedGroups());
        }
        if (haveExcludedArtifacts) {
            excludedArtifactPattern = Pattern.compile(configuration.getExcludedArtifacts());
        }
        Set depArtifacts = configuration.isIncludeTransitiveDependencies() ? project.getArtifacts() : project.getDependencyArtifacts();
        List<String> includedScopes = configuration.getIncludedScopes();
        List<String> excludeScopes = configuration.getExcludedScopes();
        boolean verbose = configuration.isVerbose();
        TreeMap<String, MavenProject> result = new TreeMap<String, MavenProject>();
        HashMap<String, Artifact> excludeArtifacts = new HashMap<String, Artifact>();
        HashMap<String, Artifact> includeArtifacts = new HashMap<String, Artifact>();
        TreeMap<String, MavenProject> localCache = new TreeMap<String, MavenProject>();
        if (cache != null) {
            localCache.putAll(cache);
        }
        for (Object e : depArtifacts) {
            boolean isToExclude;
            Artifact artifact = (Artifact)e;
            excludeArtifacts.put(artifact.getId(), artifact);
            if ("license.properties".equals(artifact.getType())) continue;
            String scope = artifact.getScope();
            if (CollectionUtils.isNotEmpty(includedScopes) && !includedScopes.contains(scope) || excludeScopes.contains(scope)) continue;
            Logger log = this.getLogger();
            String id = MojoHelper.getArtifactId(artifact);
            if (verbose) {
                log.info("detected artifact " + id);
            }
            boolean isToInclude = haveNoIncludedArtifacts && haveNoIncludedGroups || this.isIncludable(artifact, includedGroupPattern, includedArtifactPattern);
            boolean bl = isToExclude = isToInclude && haveExclusions && this.isExcludable(artifact, excludedGroupPattern, excludedArtifactPattern);
            if (!isToInclude || isToExclude) {
                if (!verbose) continue;
                log.info("skip artifact " + id);
                continue;
            }
            MavenProject depMavenProject = (MavenProject)localCache.get(id);
            if (depMavenProject != null) {
                if (verbose) {
                    log.info("add dependency [" + id + "] (from cache)");
                }
            } else {
                try {
                    depMavenProject = this.mavenProjectBuilder.buildFromRepository(artifact, remoteRepositories, localRepository, true);
                    depMavenProject.getArtifact().setScope(artifact.getScope());
                }
                catch (ProjectBuildingException e2) {
                    log.warn("Unable to obtain POM for artifact : " + artifact, (Throwable)e2);
                    continue;
                }
                if (verbose) {
                    log.info("add dependency [" + id + "]");
                }
                localCache.put(id, depMavenProject);
            }
            result.put(id, depMavenProject);
            excludeArtifacts.remove(artifact.getId());
            includeArtifacts.put(artifact.getId(), artifact);
        }
        if (excludeTransitiveDependencies) {
            for (Map.Entry entry : includeArtifacts.entrySet()) {
                List dependencyTrail = ((Artifact)entry.getValue()).getDependencyTrail();
                boolean remove = false;
                for (int i = 1; i < dependencyTrail.size() - 1; ++i) {
                    if (!excludeArtifacts.containsKey(dependencyTrail.get(i))) continue;
                    remove = true;
                    break;
                }
                if (!remove) continue;
                result.remove(MojoHelper.getArtifactId((Artifact)entry.getValue()));
            }
        }
        if (cache != null) {
            cache.putAll(result);
        }
        return result;
    }

    @Override
    public void loadProjectArtifacts(ArtifactRepository localRepository, List remoteRepositories, MavenProject project) throws DependenciesToolException {
        if (CollectionUtils.isEmpty((Collection)project.getDependencyArtifacts())) {
            ArtifactResolutionResult result;
            Set dependenciesArtifacts;
            try {
                dependenciesArtifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, (List)project.getDependencies(), null, null, (MavenProject)project);
            }
            catch (InvalidDependencyVersionException e) {
                throw new DependenciesToolException(e);
            }
            project.setDependencyArtifacts(dependenciesArtifacts);
            Artifact artifact = project.getArtifact();
            try {
                result = this.artifactResolver.resolveTransitively(dependenciesArtifacts, artifact, remoteRepositories, localRepository, this.artifactMetadataSource);
            }
            catch (ArtifactResolutionException e) {
                throw new DependenciesToolException(e);
            }
            catch (ArtifactNotFoundException e) {
                throw new DependenciesToolException(e);
            }
            project.setArtifacts(result.getArtifacts());
        }
    }

    protected boolean isIncludable(Artifact project, Pattern includedGroupPattern, Pattern includedArtifactPattern) {
        Matcher matchGroupId;
        Logger log = this.getLogger();
        if (includedGroupPattern != null) {
            try {
                matchGroupId = includedGroupPattern.matcher(project.getGroupId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Include " + project.getGroupId());
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn(String.format(INVALID_PATTERN_MESSAGE, includedGroupPattern.pattern()));
            }
        }
        if (includedArtifactPattern != null) {
            try {
                matchGroupId = includedArtifactPattern.matcher(project.getArtifactId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Include " + project.getArtifactId());
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn(String.format(INVALID_PATTERN_MESSAGE, includedArtifactPattern.pattern()));
            }
        }
        return false;
    }

    protected boolean isExcludable(Artifact project, Pattern excludedGroupPattern, Pattern excludedArtifactPattern) {
        Matcher matchGroupId;
        Logger log = this.getLogger();
        if (excludedGroupPattern != null) {
            try {
                matchGroupId = excludedGroupPattern.matcher(project.getGroupId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exclude " + project.getGroupId());
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn(String.format(INVALID_PATTERN_MESSAGE, excludedGroupPattern.pattern()));
            }
        }
        if (excludedArtifactPattern != null) {
            try {
                matchGroupId = excludedArtifactPattern.matcher(project.getArtifactId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exclude " + project.getArtifactId());
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn(String.format(INVALID_PATTERN_MESSAGE, excludedArtifactPattern.pattern()));
            }
        }
        return false;
    }
}

