/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.hibernate.Incubating;
import org.hibernate.SharedSessionContract;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractJavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JdbcTypeRecommendationException;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.format.FormatMapper;
import org.hibernate.type.spi.TypeConfiguration;

@Incubating
public abstract class FormatMapperBasedJavaType<T>
extends AbstractJavaType<T>
implements MutabilityPlan<T> {
    private final TypeConfiguration typeConfiguration;

    public FormatMapperBasedJavaType(Type type, MutabilityPlan<T> mutabilityPlan, TypeConfiguration typeConfiguration) {
        super(type, mutabilityPlan);
        this.typeConfiguration = typeConfiguration;
    }

    protected abstract FormatMapper getFormatMapper(TypeConfiguration var1);

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        throw new JdbcTypeRecommendationException("Could not determine recommended JdbcType for Java type '" + this.getTypeName() + "'");
    }

    @Override
    public String toString(T value) {
        return this.getFormatMapper(this.typeConfiguration).toString(value, this, this.typeConfiguration.getSessionFactory().getWrapperOptions());
    }

    @Override
    public T fromString(CharSequence string) {
        return this.getFormatMapper(this.typeConfiguration).fromString(string, this, this.typeConfiguration.getSessionFactory().getWrapperOptions());
    }

    @Override
    public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
        if (type.isAssignableFrom(this.getJavaTypeClass())) {
            return (X)value;
        }
        if (type == String.class) {
            return (X)this.getFormatMapper(this.typeConfiguration).toString(value, this, options);
        }
        throw new UnsupportedOperationException("Unwrap strategy not known for this Java type: " + this.getTypeName());
    }

    @Override
    public <X> T wrap(X value, WrapperOptions options) {
        if (this.getJavaTypeClass().isInstance(value)) {
            return (T)value;
        }
        if (value instanceof String) {
            return this.getFormatMapper(this.typeConfiguration).fromString((String)value, this, options);
        }
        throw new UnsupportedOperationException("Wrap strategy not known for this Java type: " + this.getTypeName());
    }

    @Override
    public MutabilityPlan<T> getMutabilityPlan() {
        MutabilityPlan mutabilityPlan = super.getMutabilityPlan();
        return mutabilityPlan == null ? this : mutabilityPlan;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public T deepCopy(T value) {
        return this.fromString(this.toString(value));
    }

    @Override
    public Serializable disassemble(T value, SharedSessionContract session) {
        return this.toString(value);
    }

    @Override
    public T assemble(Serializable cached, SharedSessionContract session) {
        return this.fromString((CharSequence)((Object)cached));
    }
}

