/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.Metamodel;

public class DaoConstructor
implements MetaAttribute {
    private final @UnknownKeyFor @NonNull @Initialized Metamodel annotationMetaEntity;
    private final @UnknownKeyFor @NonNull @Initialized String constructorName;
    private final @UnknownKeyFor @NonNull @Initialized String methodName;
    private final @UnknownKeyFor @NonNull @Initialized String returnTypeName;
    private final @UnknownKeyFor @NonNull @Initialized boolean addInjectAnnotation;
    private final @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation;

    public DaoConstructor(@UnknownKeyFor @NonNull @Initialized Metamodel annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String constructorName, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String returnTypeName, @UnknownKeyFor @NonNull @Initialized boolean addInjectAnnotation, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation) {
        this.annotationMetaEntity = annotationMetaEntity;
        this.constructorName = constructorName;
        this.methodName = methodName;
        this.returnTypeName = returnTypeName;
        this.addInjectAnnotation = addInjectAnnotation;
        this.addNonnullAnnotation = addNonnullAnnotation;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        declaration.append("\nprivate final ");
        this.notNull(declaration);
        declaration.append(this.annotationMetaEntity.importType(this.returnTypeName)).append(" entityManager;").append("\n");
        this.inject(declaration);
        declaration.append("\npublic ").append(this.constructorName).append("(");
        this.notNull(declaration);
        declaration.append(this.annotationMetaEntity.importType(this.returnTypeName)).append(" entityManager) {").append("\n\tthis.entityManager = entityManager;").append("\n}").append("\n\n").append("public ");
        this.notNull(declaration);
        declaration.append(this.annotationMetaEntity.importType(this.returnTypeName)).append(" ").append(this.methodName).append("() {").append("\n\treturn entityManager;").append("\n}");
        return declaration.toString();
    }

    private void inject(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.addInjectAnnotation) {
            declaration.append("\n@").append(this.annotationMetaEntity.importType("jakarta.inject.Inject"));
        }
    }

    private void notNull(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.addNonnullAnnotation) {
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.annotation.Nonnull")).append(' ');
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMetaType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return this.methodName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return "jakarta.persistence.EntityManager";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.annotationMetaEntity;
    }
}

